/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.dump;

import info.bliki.wiki.dump.IArticleFilter;
import info.bliki.wiki.dump.WikiArticle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class WikiXMLParser
extends DefaultHandler {
    private static final String WIKIPEDIA_TITLE = "title";
    private static final String WIKIPEDIA_TEXT = "text";
    private static final String WIKIPEDIA_PAGE = "page";
    private static final String WIKIPEDIA_NAMESPACE = "namespace";
    private static final String WIKIPEDIA_TIMESTAMP = "timestamp";
    private WikiArticle fArticle;
    private StringBuffer fData;
    private XMLReader fXMLReader;
    private Reader fReader;
    private IArticleFilter fArticleFilter;

    public WikiXMLParser(String filename, IArticleFilter filter) throws SAXException, FileNotFoundException {
        this(new FileInputStream(filename), filter);
    }

    public WikiXMLParser(InputStream inputStream, IArticleFilter filter) throws SAXException {
        try {
            this.fArticleFilter = filter;
            this.fXMLReader = XMLReaderFactory.createXMLReader();
            this.fXMLReader.setContentHandler(this);
            this.fXMLReader.setErrorHandler(this);
            this.fReader = new InputStreamReader(inputStream, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private String getString() {
        if (this.fData == null) {
            return null;
        }
        String s = this.fData.toString();
        this.fData = null;
        return s;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (WIKIPEDIA_PAGE.equals(qName)) {
            this.fArticle = new WikiArticle();
        }
        this.fData = null;
    }

    public void endElement(String uri, String name, String qName) {
        try {
            if (!WIKIPEDIA_PAGE.equals(qName)) {
                if (WIKIPEDIA_TEXT.equals(qName)) {
                    this.fArticle.setText(this.getString());
                    this.fArticleFilter.process(this.fArticle);
                } else if (WIKIPEDIA_TITLE.equals(qName)) {
                    this.fArticle.setTitle(this.getString());
                } else if (WIKIPEDIA_TIMESTAMP.equals(qName)) {
                    this.fArticle.setTimeStamp(this.getString());
                }
            }
            this.fData = null;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.fData == null) {
            this.fData = new StringBuffer(length);
        }
        this.fData.append(ch, start, length);
    }

    public void parse() throws IOException, SAXException {
        this.fXMLReader.parse(new InputSource(this.fReader));
    }
}

