/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.util;

import java.io.Serializable;

public abstract class Attribute
implements Serializable {
    private static final long serialVersionUID = 1010771448030194792L;
    protected String mName;
    protected String mAssignment;
    protected String mValue;
    protected char mQuote;

    public Attribute(String name, String assignment, String value, char quote) {
        this.mName = name;
        this.mAssignment = assignment;
        if (quote == '\u0000') {
            this.setRawValue(value);
        } else {
            this.mValue = value;
            this.mQuote = quote;
        }
    }

    public Attribute(String name, String value, char quote) {
        this(name, value == null ? "" : "=", value, quote);
    }

    public Attribute(String value) throws IllegalArgumentException {
        if (value.trim().length() != 0) {
            throw new IllegalArgumentException("non whitespace value");
        }
        this.mName = null;
        this.mAssignment = null;
        this.mValue = value;
        this.mQuote = '\u0000';
    }

    public Attribute(String name, String value) {
        this(name, value == null ? "" : "=", value, '\u0000');
    }

    public Attribute(String name, String assignment, String value) {
        this(name, assignment, value, '\u0000');
    }

    public Attribute() {
        this(null, null, null, '\u0000');
    }

    public String getName() {
        return this.mName;
    }

    public void getName(StringBuilder buffer) {
        if (this.mName != null) {
            buffer.append(this.mName);
        }
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getAssignment() {
        return this.mAssignment;
    }

    public void getAssignment(StringBuilder buffer) {
        if (this.mAssignment != null) {
            buffer.append(this.mAssignment);
        }
    }

    public void setAssignment(String assignment) {
        this.mAssignment = assignment;
    }

    public String getValue() {
        return this.mValue;
    }

    public void getValue(StringBuilder buffer) {
        if (this.mValue != null) {
            buffer.append(this.mValue);
        }
    }

    public void setValue(String value) {
        this.mValue = value;
    }

    public char getQuote() {
        return this.mQuote;
    }

    public void getQuote(StringBuilder buffer) {
        if (this.mQuote != '\u0000') {
            buffer.append(this.mQuote);
        }
    }

    public void setQuote(char quote) {
        this.mQuote = quote;
    }

    public String getRawValue() {
        String ret;
        if (this.isValued()) {
            char quote = this.getQuote();
            if (quote != '\u0000') {
                StringBuilder buffer = new StringBuilder();
                buffer.append(quote);
                this.getValue(buffer);
                buffer.append(quote);
                ret = buffer.toString();
            } else {
                ret = this.getValue();
            }
        } else {
            ret = null;
        }
        return ret;
    }

    public void getRawValue(StringBuilder buffer) {
        if (this.mValue != null) {
            buffer.append("\"");
            this.getValue(buffer);
            buffer.append("\"");
        }
    }

    public void setRawValue(String value) {
        char quote = '\u0000';
        if (value != null && value.trim().length() != 0) {
            if (value.startsWith("'") && value.endsWith("'") && 2 <= value.length()) {
                quote = '\'';
                value = value.substring(1, value.length() - 1);
            } else if (value.startsWith("\"") && value.endsWith("\"") && 2 <= value.length()) {
                quote = '\"';
                value = value.substring(1, value.length() - 1);
            } else {
                char ch;
                boolean needed = false;
                boolean singleq = true;
                boolean doubleq = true;
                int i = 0;
                while (i < value.length()) {
                    ch = value.charAt(i);
                    if ('\'' == ch) {
                        singleq = false;
                        needed = true;
                    } else if ('\"' == ch) {
                        doubleq = false;
                        needed = true;
                    } else if ('-' != ch && '.' != ch && '_' != ch && ':' != ch && !Character.isLetterOrDigit(ch)) {
                        needed = true;
                    }
                    ++i;
                }
                if (needed) {
                    if (doubleq) {
                        quote = '\"';
                    } else if (singleq) {
                        quote = '\'';
                    } else {
                        quote = '\"';
                        String ref = "&quot;";
                        StringBuilder buffer = new StringBuilder(value.length() * (ref.length() - 1));
                        i = 0;
                        while (i < value.length()) {
                            ch = value.charAt(i);
                            if (quote == ch) {
                                buffer.append(ref);
                            } else {
                                buffer.append(ch);
                            }
                            ++i;
                        }
                        value = buffer.toString();
                    }
                }
            }
        }
        this.setValue(value);
        this.setQuote(quote);
    }

    public boolean isWhitespace() {
        return this.getName() == null;
    }

    public boolean isStandAlone() {
        return this.getName() != null && this.getAssignment() == null;
    }

    public boolean isEmpty() {
        return this.getAssignment() != null && this.getValue() == null;
    }

    public boolean isValued() {
        return this.getValue() != null;
    }

    public int getLength() {
        char quote;
        String value;
        String assignment;
        int ret = 0;
        String name = this.getName();
        if (name != null) {
            ret += name.length();
        }
        if ((assignment = this.getAssignment()) != null) {
            ret += assignment.length();
        }
        if ((value = this.getValue()) != null) {
            ret += value.length();
        }
        if ((quote = this.getQuote()) != '\u0000') {
            ret += 2;
        }
        return ret;
    }

    public String toString() {
        int length = this.getLength();
        StringBuilder ret = new StringBuilder(length);
        this.toString(ret);
        return ret.toString();
    }

    public void toString(StringBuilder buffer) {
        this.getName(buffer);
        this.getAssignment(buffer);
        this.getRawValue(buffer);
    }
}

