/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.dendai.cdl.mori.wikie.util;

import java.util.Set;
import java.util.TreeSet;
import jp.ac.dendai.cdl.mori.wikie.util.WNormalizer;
import org.junit.Assert;
import org.junit.Test;

public class WNormalizerTest {
    public Set<String> langSet = new TreeSet<String>();
    public Set<String> proSet;

    public WNormalizerTest() {
        this.langSet.add("en");
        this.proSet = new TreeSet<String>();
        this.proSet.add("w");
    }

    @Test
    public void testDecode() {
        try {
            Assert.assertEquals((Object)"\u771fSAMURAI_SPIRITS_\u8987\u738b\u4e38\u5730\u7344\u5909\uff081994\u5e74\uff09", (Object)WNormalizer.decodeSectionLink(".E7.9C.9FSAMURAI_SPIRITS_.E8.A6.87.E7.8E.8B.E4.B8.B8.E5.9C.B0.E7.8D.84.E5.A4.89.EF.BC.881994.E5.B9.B4.EF.BC.89"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testNormalize() {
        try {
            WNormalizer n = new WNormalizer("pageHead.xml", this.proSet, this.langSet);
            Assert.assertEquals((Object)"", (Object)n.normalize(":").toString());
            Assert.assertEquals((Object)"", (Object)n.normalize(" : ").toString());
            Assert.assertEquals((Object)"", (Object)n.normalize("").toString());
            Assert.assertEquals((Object)"", (Object)n.normalize(" ").toString());
            Assert.assertEquals((Object)"en:category:MAGIC : the", (Object)n.normalize(" : EN : CaTeGoRy : mAGIC : the").toString());
            Assert.assertEquals((Object)"en:category:MAGIC : the", (Object)n.normalize("EN : CaTeGoRy : mAGIC : the").toString());
            Assert.assertEquals((Object)"category:MAGIC : the", (Object)n.normalize("CaTeGoRy : mAGIC : the").toString());
            Assert.assertEquals((Object)"MAGIC : the", (Object)n.normalize("mAGIC : the").toString());
            Assert.assertEquals((Object)".hack//G.U.: The World", (Object)n.normalize(".hack//G.U.: The World").toString());
            Assert.assertEquals((Object)"Abc", (Object)n.normalize("abc").toString());
            Assert.assertEquals((Object)"Abc", (Object)n.normalize(":abc").toString());
            Assert.assertEquals((Object)"en:Abc", (Object)n.normalize(":En:abc").toString());
            Assert.assertEquals((Object)"en:category:Computer: abc", (Object)n.normalize("En : Category : computer: abc").toString());
            Assert.assertEquals((Object)"en:category:Computer: abc", (Object)n.normalize(":En : Category : computer: abc").toString());
            Assert.assertEquals((Object)"", (Object)n.normalize("").toString());
            Assert.assertEquals((Object)"%", (Object)n.normalize("%").toString());
            Assert.assertEquals((Object)"%1", (Object)n.normalize("%1").toString());
            Assert.assertEquals((Object)"\u30cb\u30e5\u30fc\u30b9\u901f\u5831+\u677f", (Object)n.normalize("\u30cb\u30e5\u30fc\u30b9\u901f\u5831+\u677f").toString());
            Assert.assertEquals((Object)")2", (Object)n.normalize("%292").toString());
            Assert.assertEquals((Object)"\u30b8\u30e3\u30ac\u30fc (\u66d6\u6627\u3055\u56de\u907f)", (Object)n.normalize("\u30b8\u30e3\u30ac\u30fc_%28\u66d6\u6627\u3055\u56de\u907f%29").toString());
            Assert.assertEquals((Object)"\u30b8\u30e3\u30ac\u30fc 7(\u66d6\u6627\u3055\u56de\u907f)", (Object)n.normalize("\u30b8\u30e3\u30ac\u30fc_7%28\u66d6\u6627\u3055\u56de\u907f%29").toString());
            Assert.assertEquals((Object)"", (Object)n.normalize(":").toString());
            Assert.assertEquals((Object)"", (Object)n.normalize("category:").toString());
            Assert.assertEquals((Object)"Abc", (Object)n.normalize("abc").toString());
            Assert.assertEquals((Object)"+", (Object)n.normalize("+").toString());
            Assert.assertEquals((Object)"&", (Object)n.normalize("&amp;").toString());
            Assert.assertEquals((Object)"&", (Object)n.normalize("%26amp%3B").toString());
            Assert.assertEquals((Object)"\u30d0\u30c3\u30b7\u30f3\u30b0 (\u6620\u753b)", (Object)n.normalize("%E3%83%90%E3%83%83%E3%82%B7%E3%83%B3%E3%82%B0 %28%E6%98%A0%E7%94%BB%29").toString());
            Assert.assertEquals((Object)"category:Abc", (Object)n.normalize("Category:abc").toString());
            Assert.assertEquals((Object)"category:Abc", (Object)n.normalize("Category : abc").toString());
            Assert.assertEquals((Object)"category:A b c", (Object)n.normalize(" Category _:_ a _ b _ c ").toString());
            Assert.assertEquals((Object)"category:Magic : \u30b6\u30fb\u30ae\u30e3\u30b6\u30ea\u30f3\u30b0", (Object)n.normalize("Category:magic : \u30b6\u30fb\u30ae\u30e3\u30b6\u30ea\u30f3\u30b0").toString());
            Assert.assertEquals((Object)"'''", (Object)"'''");
            Assert.assertEquals((Object)"en:Richard M. Daley|\u30ea\u30c1\u30e3\u30fc\u30c9\u30fb\u30c7\u30a4\u30ea\u30fc", (Object)n.normalize(":en:Richard M. Daley|\u30ea\u30c1\u30e3\u30fc\u30c9\u30fb\u30c7\u30a4\u30ea\u30fc").toString());
            Assert.assertEquals((Object)"\u3042\u3044\u3046", (Object)n.normalize(":\u3042\u3044\u3046").toString());
            Assert.assertEquals((Object)"\u30a6\u30a3\u30f3\u30c9\u30a6\u30ba100%", (Object)n.normalize("\u30a6\u30a3\u30f3\u30c9\u30a6\u30ba100%").toString());
            Assert.assertEquals((Object)"\u30a6\u30a3\u30ea\u30a2\u30e0\u30ba%R", (Object)n.normalize("\u30a6\u30a3\u30ea\u30a2\u30e0\u30ba%R").toString());
            Assert.assertEquals((Object)"\u72ac", (Object)n.normalize("%E7%8A%AC").toString());
            Assert.assertEquals((Object)"en:Wikipedia", (Object)n.normalize("en:Wikipedia").toString());
            Assert.assertEquals((Object)"En", (Object)n.normalize("en").toString());
            Assert.assertEquals((Object)"", (Object)n.normalize("en:").toString());
            Assert.assertEquals((Object)"w:en:wikipedia:Wikipedia", (Object)n.normalize("w:en:Wikipedia:Wikipedia").toString());
            Assert.assertEquals((Object)"w:Xyz", (Object)n.normalize("W:xyz").toString());
            Assert.assertEquals((Object)"category:Category", (Object)n.normalize("category:category").toString());
            Assert.assertEquals((Object)"en:En:category:category", (Object)n.normalize("En:En:category:category").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

