/*
 * Decompiled with CFR 0.152.
 */
package prantl.ant.eclipse;

import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import prantl.ant.eclipse.SettingsElement;
import prantl.ant.eclipse.VariableElement;

public abstract class PreferencesElement {
    private static final String VERSION_NAME = "eclipse.preferences.version";
    private static final String VERSION_VALUE = "1";
    private SettingsElement settings = null;
    private String name = null;
    private Vector variables = new Vector();

    PreferencesElement(SettingsElement parent) {
        this.settings = parent;
    }

    public String getName() {
        return this.name;
    }

    String getValidValues(Set set) {
        StringBuffer result = new StringBuffer();
        Iterator iterator = set.iterator();
        int i = 0;
        int size = set.size();
        while (i != size) {
            result.append('\"');
            result.append(iterator.next());
            if (i == size - 2) {
                result.append("\" and ");
            } else if (i == size - 1) {
                result.append('\"');
            } else {
                result.append("\", ");
            }
            ++i;
        }
        return result.toString();
    }

    VariableElement getVariable(String name) {
        int i = 0;
        int size = this.variables.size();
        while (i != size) {
            VariableElement variable = (VariableElement)this.variables.get(i);
            if (name.equals(variable.getName())) {
                return variable;
            }
            ++i;
        }
        return null;
    }

    public Vector getVariables() {
        return this.variables;
    }

    public String getVersion() {
        VariableElement variable = this.getVariable(VERSION_NAME);
        return variable == null ? VERSION_VALUE : variable.getValue();
    }

    boolean hasVariable(String name) {
        return this.getVariable(name) != null;
    }

    void internalAddVariable(String name, String value) {
        if (!this.hasVariable(name)) {
            this.internalCreateVariable(name, value);
        }
    }

    VariableElement internalCreateVariable() {
        this.variables.addElement(new VariableElement(this));
        return (VariableElement)this.variables.lastElement();
    }

    void internalCreateVariable(String name, String value) {
        VariableElement variable = this.internalCreateVariable();
        variable.setName(name);
        variable.setValue(value);
    }

    void internalSetName(String value) {
        this.settings.validatePreferencesName(value);
        this.name = value;
    }

    public void setVersion(String value) {
        this.internalCreateVariable(VERSION_NAME, value);
    }

    public void validate() {
        if (!this.hasVariable(VERSION_NAME)) {
            this.setVersion(VERSION_VALUE);
        }
        int i = 0;
        int size = this.variables.size();
        while (i != size) {
            VariableElement variable = (VariableElement)this.variables.get(i);
            variable.validate();
            ++i;
        }
    }

    void validateVariableName(String name) {
        if (this.hasVariable(name)) {
            throw new BuildException(name.equals(VERSION_NAME) ? "The variable \"eclipse.preferences.version\" cannot be defined as an element if there has been an attribute \"version\" used for the whole preferences." : "The variable named \"" + name + "\" has alredy been defined.");
        }
    }
}

