/*
 * Decompiled with CFR 0.152.
 */
package prantl.ant.eclipse;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.apache.tools.ant.BuildException;
import prantl.ant.eclipse.EclipseOutput;
import prantl.ant.eclipse.EclipseTask;
import prantl.ant.eclipse.ProjectElement;
import prantl.ant.eclipse.XmlWriter;

final class ProjectGenerator {
    private static final String[] defaultBuidCommands = new String[]{"org.eclipse.jdt.core.javabuilder", "org.eclipse.ajdt.core.ajbuilder"};
    private static final String[][] defaultNatures = new String[][]{{"org.eclipse.jdt.core.javanature"}, {"org.eclipse.ajdt.ui.ajnature", "org.eclipse.jdt.core.javanature"}};
    private EclipseTask task;

    ProjectGenerator(EclipseTask parent) {
        this.task = parent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void generate() {
        ProjectElement project = this.task.getEclipse().getProject();
        if (project == null) {
            this.task.log("There was no description of a project found.", 1);
            return;
        }
        EclipseOutput output = this.task.getOutput();
        if (output.isProjectUpToDate()) {
            this.task.log("The project definition is up-to-date.", 1);
            return;
        }
        this.task.log("Writing the project definition in the mode \"" + this.task.getEclipse().getMode().getValue() + "\".");
        XmlWriter writer = null;
        try {
            try {
                writer = new XmlWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(output.createProject()), "UTF-8"));
                writer.writeXmlDeclaration("UTF-8");
                writer.openElement("projectDescription");
                writer.openElement("name");
                String name = project.getName();
                if (name == null) {
                    name = this.task.getProject().getProperty("ant.project.name");
                }
                if (name == null) {
                    throw new BuildException("Both name of the Eclipse and name of the Ant project cannot be missing.");
                }
                this.task.log("Project name is \"" + name + "\".", 3);
                writer.writeText(name);
                writer.closeElement("name");
                writer.openElement("comment");
                writer.closeElement("comment");
                writer.openElement("projects");
                writer.closeElement("projects");
                writer.openElement("buildSpec");
                writer.openElement("buildCommand");
                writer.openElement("name");
                int mode = this.task.getEclipse().getMode().getIndex();
                writer.writeText(defaultBuidCommands[mode]);
                writer.closeElement("name");
                writer.openElement("arguments");
                writer.closeElement("arguments");
                writer.closeElement("buildCommand");
                writer.closeElement("buildSpec");
                writer.openElement("natures");
                int i = 0;
                int length = defaultNatures[mode].length;
                while (i != length) {
                    writer.openElement("nature");
                    writer.writeText(defaultNatures[mode][i]);
                    writer.closeElement("nature");
                    ++i;
                }
                writer.closeElement("natures");
                writer.closeElement("projectDescription");
            }
            catch (UnsupportedEncodingException exception) {
                throw new BuildException("Encoder to UTF-8 is not supported.", (Throwable)exception);
            }
            catch (IOException exception) {
                throw new BuildException("Writing the project definition failed.", (Throwable)exception);
            }
            Object var5_11 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException exception1) {
                throw new BuildException("Closing the project definition failed.", (Throwable)exception1);
            }
        }
        try {
            writer.close();
            return;
        }
        catch (IOException exception1) {
            throw new BuildException("Closing the project definition failed.", (Throwable)exception1);
        }
    }
}

