/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DBInputFormat;
import com.cloudera.sqoop.mapreduce.db.DataDrivenDBInputFormat;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.sqoop.manager.oracle.OraOopConstants;
import org.apache.sqoop.manager.oracle.OraOopDBInputSplit;
import org.apache.sqoop.manager.oracle.OraOopDBRecordReader;
import org.apache.sqoop.manager.oracle.OraOopLog;
import org.apache.sqoop.manager.oracle.OraOopLogFactory;
import org.apache.sqoop.manager.oracle.OraOopOracleDataChunk;
import org.apache.sqoop.manager.oracle.OraOopOracleQueries;
import org.apache.sqoop.manager.oracle.OraOopUtilities;
import org.apache.sqoop.manager.oracle.OracleConnectionFactory;
import org.apache.sqoop.manager.oracle.OracleTable;

public class OraOopDataDrivenDBInputFormat<T extends SqoopRecord>
extends DataDrivenDBInputFormat<T>
implements Configurable {
    public static final OraOopLog LOG = OraOopLogFactory.getLog(OraOopDataDrivenDBInputFormat.class.getName());

    public OraOopDataDrivenDBInputFormat() {
        OraOopUtilities.checkJavaSecurityEgd();
    }

    @Override
    public List<InputSplit> getSplits(JobContext jobContext) throws IOException {
        int desiredNumberOfMappers = this.getDesiredNumberOfMappers(jobContext);
        OracleTable table = this.identifyOracleTableFromJobContext(jobContext);
        List<String> partitionList = this.getPartitionList(jobContext);
        Connection connection = this.getConnection();
        List<InputSplit> splits = null;
        try {
            OracleConnectionFactory.initializeOracleConnection(connection, this.getConf());
            int numberOfChunksPerOracleDataFile = desiredNumberOfMappers * 2 + 1;
            List<OraOopOracleDataChunk> dataChunks = OraOopUtilities.getOraOopOracleDataChunkMethod(this.getConf()).equals((Object)OraOopConstants.OraOopOracleDataChunkMethod.PARTITION) ? OraOopOracleQueries.getOracleDataChunksPartition(connection, table, partitionList) : OraOopOracleQueries.getOracleDataChunksExtent(jobContext.getConfiguration(), connection, table, partitionList, numberOfChunksPerOracleDataFile);
            if (dataChunks.size() == 0) {
                String errMsg = OraOopUtilities.getOraOopOracleDataChunkMethod(this.getConf()).equals((Object)OraOopConstants.OraOopOracleDataChunkMethod.PARTITION) ? String.format("The table %s does not contain any partitions and you have specified to chunk the table by partitions.", table.getName()) : String.format("The table %s does not contain any data.", table.getName());
                LOG.fatal(errMsg);
                throw new RuntimeException(errMsg);
            }
            OraOopConstants.OraOopOracleBlockToSplitAllocationMethod blockAllocationMethod = OraOopUtilities.getOraOopOracleBlockToSplitAllocationMethod(jobContext.getConfiguration(), OraOopConstants.OraOopOracleBlockToSplitAllocationMethod.ROUNDROBIN);
            splits = this.groupTableDataChunksIntoSplits(dataChunks, desiredNumberOfMappers, blockAllocationMethod);
            String oraoopLocations = jobContext.getConfiguration().get("oraoop.locations", "");
            String[] locations = oraoopLocations.split(",");
            for (int idx = 0; idx < locations.length; ++idx) {
                String location;
                if (idx >= splits.size() || (location = locations[idx].trim()).isEmpty()) continue;
                ((OraOopDBInputSplit)splits.get(idx)).setSplitLocation(location);
                LOG.info(String.format("Split[%d] has been assigned location \"%s\".", idx, location));
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        return splits;
    }

    @Override
    protected RecordReader<LongWritable, T> createDBRecordReader(DBInputFormat.DBInputSplit split, Configuration conf) throws IOException {
        OraOopUtilities.enableDebugLoggingIfRequired(conf);
        OraOopDBInputSplit oraOopSplit = OraOopDBRecordReader.castSplit(split);
        int mapperId = oraOopSplit.getSplitId();
        String mapperJdbcUrlPropertyName = OraOopUtilities.getMapperJdbcUrlPropertyName(mapperId, conf);
        String mapperJdbcUrl = conf.get(mapperJdbcUrlPropertyName, null);
        LOG.debug(String.format("Mapper %d has a JDBC URL of: %s", mapperId, mapperJdbcUrl == null ? "<null>" : mapperJdbcUrl));
        DBConfiguration dbConf = this.getDBConf();
        if (mapperJdbcUrl != null) {
            dbConf.getConf().set("mapreduce.jdbc.url", mapperJdbcUrl);
            conf.set("mapreduce.jdbc.url", mapperJdbcUrl);
        }
        Class<?> inputClass = dbConf.getInputClass();
        try {
            return new OraOopDBRecordReader(split, inputClass, conf, dbConf.getConnection(), dbConf, dbConf.getInputConditions(), dbConf.getInputFieldNames(), dbConf.getInputTableName());
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex);
        }
    }

    private OracleTable identifyOracleTableFromJobContext(JobContext jobContext) {
        OracleTable result = new OracleTable();
        String dbUserName = jobContext.getConfiguration().get("mapreduce.jdbc.username");
        String tableName = this.getDBConf().getInputTableName();
        result = OraOopUtilities.decodeOracleTableName(dbUserName, tableName, jobContext.getConfiguration());
        return result;
    }

    private int getDesiredNumberOfMappers(JobContext jobContext) {
        int minMappersAcceptedByOraOop;
        int desiredNumberOfMappers = jobContext.getConfiguration().getInt("oraoop.desired.num.mappers", -1);
        if (desiredNumberOfMappers < (minMappersAcceptedByOraOop = OraOopUtilities.getMinNumberOfImportMappersAcceptedByOraOop(jobContext.getConfiguration()))) {
            LOG.warn(String.format("%s should not be used to perform a sqoop import when the number of mappers is %d\n i.e. OraOopManagerFactory.accept() should only appect jobs where the number of mappers is at least %d", "Data Connector for Oracle and Hadoop", desiredNumberOfMappers, minMappersAcceptedByOraOop));
        }
        return desiredNumberOfMappers;
    }

    private List<String> getPartitionList(JobContext jobContext) {
        LOG.debug("oraoop.import.partitions = " + jobContext.getConfiguration().get("oraoop.import.partitions"));
        List<String> result = OraOopUtilities.splitOracleStringList(jobContext.getConfiguration().get("oraoop.import.partitions"));
        if (result != null && result.size() > 0) {
            LOG.debug("Partition filter list: " + result.toString());
        }
        return result;
    }

    protected List<InputSplit> groupTableDataChunksIntoSplits(List<? extends OraOopOracleDataChunk> dataChunks, int desiredNumberOfSplits, OraOopConstants.OraOopOracleBlockToSplitAllocationMethod blockAllocationMethod) {
        int numberOfDataChunks = dataChunks.size();
        int actualNumberOfSplits = Math.min(numberOfDataChunks, desiredNumberOfSplits);
        int totalNumberOfBlocksInAllDataChunks = 0;
        for (OraOopOracleDataChunk oraOopOracleDataChunk : dataChunks) {
            totalNumberOfBlocksInAllDataChunks += oraOopOracleDataChunk.getNumberOfBlocks();
        }
        String debugMsg = String.format("The table being imported by sqoop has %d blocks that have been divided into %d chunks which will be processed in %d splits. The chunks will be allocated to the splits using the method : %s", totalNumberOfBlocksInAllDataChunks, numberOfDataChunks, actualNumberOfSplits, blockAllocationMethod.toString());
        LOG.info(debugMsg);
        ArrayList<InputSplit> arrayList = new ArrayList<InputSplit>(actualNumberOfSplits);
        for (int i = 0; i < actualNumberOfSplits; ++i) {
            OraOopDBInputSplit split = new OraOopDBInputSplit();
            split.setSplitId(i);
            split.setTotalNumberOfBlocksInAllSplits(totalNumberOfBlocksInAllDataChunks);
            arrayList.add(split);
        }
        switch (blockAllocationMethod) {
            case RANDOM: {
                Collections.shuffle(dataChunks);
            }
            case ROUNDROBIN: {
                int idxSplitRoundRobin = 0;
                for (OraOopOracleDataChunk oraOopOracleDataChunk : dataChunks) {
                    if (idxSplitRoundRobin >= arrayList.size()) {
                        idxSplitRoundRobin = 0;
                    }
                    OraOopDBInputSplit split = (OraOopDBInputSplit)((Object)arrayList.get(idxSplitRoundRobin++));
                    split.getDataChunks().add(oraOopOracleDataChunk);
                }
                break;
            }
            case SEQUENTIAL: {
                double dataChunksPerSplit = (double)dataChunks.size() / (double)arrayList.size();
                int dataChunksAllocatedToSplits = 0;
                int idxSplitSeq = 0;
                for (OraOopOracleDataChunk oraOopOracleDataChunk : dataChunks) {
                    OraOopDBInputSplit split = (OraOopDBInputSplit)((Object)arrayList.get(idxSplitSeq));
                    split.getDataChunks().add(oraOopOracleDataChunk);
                    if (!((double)(++dataChunksAllocatedToSplits) >= dataChunksPerSplit * (double)(idxSplitSeq + 1)) || idxSplitSeq >= arrayList.size()) continue;
                    ++idxSplitSeq;
                }
                break;
            }
            default: {
                throw new RuntimeException("Block allocation method not implemented.");
            }
        }
        if (LOG.isDebugEnabled()) {
            for (int idx = 0; idx < arrayList.size(); ++idx) {
                LOG.debug("\n\t" + ((OraOopDBInputSplit)((Object)arrayList.get(idx))).getDebugDetails());
            }
        }
        return arrayList;
    }
}

