/*
 * Created on 2004/05/04
 */
/**
 * @author qwert
 */
public class Game extends AbstractGame implements ChessLibrary {
	static public char pieceOf(int p) {
		switch (p) {
			case WP :
				return 'p';
			case BP :
				return 'P';
			case WN :
				return 'n';
			case BN :
				return 'N';
			case WB :
				return 'b';
			case BB :
				return 'B';
			case WR :
				return 'r';
			case BR :
				return 'R';
			case WQ :
				return 'q';
			case BQ :
				return 'Q';
			case WK :
				return 'k';
			case BK :
				return 'K';
			default :
				return ' ';
		}
	}
	/**
	 * @param len
	 *               length of any line under Game
	 */
	public Game(int len) {
		super(len);
		board = new Board();
		init();
		enumVariations();
	}
	/**
	 * clear the current variation
	 */
	public void clear() throws LineCannotAccessedException {
		if (line.pline == this) {
			if (cline == null)
				throw new LineCannotAccessedException();
			cline = null;
			return;
		}
		/*
		 * to clear a variation, line should be the 1st line at the variation
		 */
		if (line.pline.cline == line) {
			line = line.pline;
			clear();
			return;
		}
		try {
			line.joints[0].pline = line.pline;
		} catch (NullPointerException e) {
			// 			 it is all right
		}
		line.pline.joints[line.num1] = line.joints[0];
	}
	/**
	 * enumulate variations
	 */
	private void enumVariations() {
		Line l = line;
		variations.x = 0;
		variations.y = 1;
		subenumVariations(l);
		l = line;
		sub2enumVariations(l);
		variations.y += variations.x;
	}
	private int[] getAttackingPawnMove(Coordinate c, int _color) {
		int[] ia = new int[2];
		ia[0] = getPosition(c.add(1, 1 * _color));
		ia[1] = getPosition(c.add(-1, 1 * _color));
		return ia;
	}
	private int[][] getBishopMove(Coordinate c) {
		int[][] iaa = new int[4][7];
		Coordinate C = new Coordinate(1, 1);
		for (int j = 0; j < 4; j++) {
			for (int i = 0; i < 7; i++) {
				iaa[j][i] = getPosition(c.add((i + 1) * C.x, (i + 1) * C.y));
			}
			/*
			 * (x + yi)i
			 */
			C.x = -C.y;
			C.y = C.x;
		}
		return iaa;
	}
	// TODO
	//void swapline(Line swappedline, Line swappedline2)
	//throws LineCannotAccessedException {
	//Line tmpl;
	//Line hsl, hsl2;
	//if (swappedline == swappedline2)
	//	return;
	//hsl = gethigherline(swappedline);
	//hsl2 = gethigherline(swappedline2);
	///*
	// * simple swap
	// */
	//if (hsl == hsl2) {
	//	tmpl = swappedline;
	//	swappedline.parentline = swappedline2.parentline;
	//	swappedline.childline = swappedline2.childline;
	//	swappedline2.parentline = tmpl.parentline;
	//	swappedline2.childline = tmpl.childline;
	//	return;
	//}
	///*
	// * swap2 is higher line of swap1
	// */
	//if (hsl == swappedline2){
	//	tmpl = new Line(swappedline.basen, parentline, childline,
	// length,this);
	//	for (int tmpnum = num + 1;
	//		swappedline.getmove(tmpnum) == null;
	//		tmpnum++) {
	//		tmpl.putmove(tmpnum, swappedline.getmove(tmpnum));
	//	}
	//	for (int tmpnum = num + 1; getmove(tmpnum) == null; tmpnum++) {
	//		swappedline.putmove(tmpnum, swappedline.getmove(tmpnum));
	//	} /*
	//																																																												 * lastly set links and move back line so user's line pointer is not
	// changed in user's view
	//																																																												 */
	//	parentline.childline = tmpl;
	//	childline.parentline = tmpl;
	//	this = swappedline;
	//}
	//if (swappedline == swappedline2)
	//	return;
	//
	//if (i == 0) {
	//	/*
	//	* this is higher line and do a special swap
	//	*/
	//	if (basen != num) {
	//		/*
	//					 * lines are same so don't do swap
	//					 */
	//		if (this == swappedline)
	//			return;
	//		/*
	//		 * make tmp line to copy moves from higher line
	//		 */
	//		tmpl =
	//			new Line(
	//				num,
	//				swappedline.parentline,
	//				swappedline.childline,
	//				length);
	//		/*
	//		* copying higher-line's moves to tmpl
	//		*/
	//		for (int tmpnum = num + 1; getmove(tmpnum) == null; tmpnum++) {
	//			tmpl.putmove(tmpnum, getmove(tmpnum));
	//		} /*
	//																																																														* copying smaller-line's moves to higher line
	//																																																														*/
	//		for (int tmpnum = num + 1;
	//			swappedline.getmove(tmpnum) == null;
	//			tmpnum++) {
	//			putmove(tmpnum, swappedline.getmove(tmpnum));
	//		} /*
	//																																																													 * lastly set links and move back line so user's line pointer is not
	// changed in user's view
	//																																																													 */
	//		swappedline.parentline.childline = tmpl;
	//		swappedline.childline.parentline = tmpl;
	//		this = tmpl;
	//		/*
	//		* swappedline is higher line and do a special swap
	//		*/
	//	} else if (swappedline.basen != num) {
	//
	//	} else { /*
	//																																														 * do a swap
	//																																														 */
	//
	//	}
	//} else if (i > 0) {
	//	if (getmove(num).connecter == null)
	//		throw new LineCannotAccessedException();
	//	i--;
	//	getmove(num).connecter.swapline(num, swappedline, i);
	//} else {
	//	if (parentline == rootline)
	//		throw new LineCannotAccessedException();
	//	if (parentline.basen != num && i <= -2)
	//		throw new LineCannotAccessedException();
	//	parentline.swapline(num, swappedline, i);
	//	i++;
	//}
	//return;
	//}
	private int getColor(int p) {
		if (p > 0) {
			return 1;
		} else if (p == SP) {
			return 0;
		} else if (p == OB) {
			return 0;
		} else {
			return -1;
		}
	}
	private int[] getKingMove(Coordinate c) {
		int[] ia = new int[8];
		ia[0] = getPosition(c.add(0, 1));
		ia[1] = getPosition(c.add(1, 1));
		ia[2] = getPosition(c.add(1, 0));
		ia[3] = getPosition(c.add(1, -1));
		ia[4] = getPosition(c.add(0, -1));
		ia[5] = getPosition(c.add(-1, -1));
		ia[6] = getPosition(c.add(-1, 0));
		ia[7] = getPosition(c.add(-1, 1));
		return ia;
	}
	private int[] getkNightMove(Coordinate c) {
		int[] ia = new int[8];
		ia[0] = getPosition(c.add(1, 2));
		ia[1] = getPosition(c.add(2, 1));
		ia[2] = getPosition(c.add(2, -1));
		ia[3] = getPosition(c.add(1, -2));
		ia[4] = getPosition(c.add(-1, -2));
		ia[5] = getPosition(c.add(-2, -1));
		ia[6] = getPosition(c.add(-2, 1));
		ia[7] = getPosition(c.add(-1, 2));
		return ia;
	}
	public Move getMove() {
		if (line == this)
			return rootMove;
		return line.moves[num];
	}
	private int[] getMovingPawnMove(Coordinate c, int _color) {
		int[] ia = new int[2];
		ia[0] = getPosition(c.add(0, 1 * _color));
		if (_color == 1 && c.y == 1 || _color == -1 && c.y == 6)
			ia[1] = getPosition(c.add(0, 2 * _color));
		return ia;
	}
	/*
	 * init the board
	 */
	public int getPosition(Coordinate c) {
		try {
			return board.P[c.x][c.y];
		} catch (ArrayIndexOutOfBoundsException e) {
			return OB;
		}
	}
	private int[][] getRookMove(Coordinate c) {
		int[][] iaa = new int[4][7];
		Coordinate C = new Coordinate(0, 1);
		for (int j = 0; j < 4; j++) {
			for (int i = 0; i < 7; i++) {
				iaa[j][i] = getPosition(c.add((i + 1) * C.x, (i + 1) * C.y));
			}
			/*
			 * (x + yi)i
			 */
			C.x = -C.y;
			C.y = C.x;
		}
		return iaa;
	}
	/**
	 * go forward or backward. if n == 0 only call enumvariations;
	 */
	public void go(int n) throws LineCannotAccessedException {
		if (line == this &&  num + n < num1 )
			throw new LineCannotAccessedException();
		if (n == 0) {
		} else if (n > 0) {
			try {
				line.moves[num + n].notify(); //  do nothing maybe
			} catch (IndexOutOfBoundsException e) {
				if (line.cline == null) {
					line.cline = new Line(line.num1 + length, line, null,
							length);
				}
				num += length;
				line = line.cline;
				go(n - length);
				return;
			}
			num += n;
		} else {
			try {
				line.moves[num - n].notify(); //  do nothing maybe
			} catch (IndexOutOfBoundsException e) {
				num -= length;
				line = line.pline;
				go(n + length);
				return;
			}
			num -= n;
		}
		enumVariations();
	}
	public void init() {
		board.P[0][7] = BR;
		board.P[1][7] = BN;
		board.P[2][7] = BB;
		board.P[3][7] = BQ;
		board.P[4][7] = BK;
		board.P[5][7] = BB;
		board.P[6][7] = BN;
		board.P[7][7] = BR;
		for (int i = 0; i < 8; i++) {
			board.P[i][6] = BP;
		}
		board.P[0][0] = WR;
		board.P[1][0] = WN;
		board.P[2][0] = WB;
		board.P[3][0] = WQ;
		board.P[4][0] = WK;
		board.P[5][0] = WB;
		board.P[6][0] = WN;
		board.P[7][0] = WR;
		for (int i = 0; i <= 7; i++) {
			board.P[i][1] = WP;
		}
		for (int i = 0; i < 8; i++) {
			for (int j = 2; j < 6; j++) {
				board.P[i][j] = SP;
			}
		}
		color = 1;
	}
	/**
	 * @param c
	 * @param _color
	 * @param pinned
	 * @param behavior
	 *               0 = avoid this 1 = default 2 = AttackingPawn 3 = MovingPawn 5 =
	 *               King'sAttack
	 * 
	 * 
	 * 
	 * @return
	 */
	private boolean isInfluencedBy(Coordinate c, int _color,
			Coordinate[] pinned, int behavior) {
		int[] ia;
		int[][] iaa;
		if (getPosition(c) == OB)
			return false;
		if (behavior % 2 == 0) {
			ia = getAttackingPawnMove(c, -_color);// it is
			// complicated
			for (int i = 0; i < ia.length; i++) {
				if (ia[i] == _color * WP)
					if (!(isPinnedBy(c, pinned)))
						return true;
			}
		}
		if (behavior % 3 == 0) {
			ia = getMovingPawnMove(c, -_color);
			for (int i = 0; i < ia.length; i++) {
				if (ia[i] == _color * WP)
					if (!(isPinnedBy(c, pinned)))
						return true;
			}
		}
		ia = getkNightMove(c);
		for (int i = 0; i < ia.length; i++) {
			if (ia[i] == _color * WN)
				if (!(isPinnedBy(c, pinned)))
					return true;
		}
		iaa = getBishopMove(c);
		for (int j = 0; j < 4; j++) {
			for (int i = 0; i < 7; i++) {
				if (iaa[j][i] == SP)
					continue;
				else if (iaa[i][j] == _color * WB || iaa[i][j] == _color * WQ)
					if (!(isPinnedBy(c, pinned)))
						return true;
					else
						break;
			}
		}
		iaa = getRookMove(c);
		for (int j = 0; j < 4; j++) {
			for (int i = 0; i < 7; i++) {
				if (iaa[j][i] == SP)
					continue;
				else if (iaa[i][j] == _color * WR || iaa[i][j] == _color * WQ)
					if (!(isPinnedBy(c, pinned)))
						return true;
					else
						break;
			}
		}
		if (behavior % 5 == 0) {
			ia = getKingMove(c);
			for (int i = 0; i < ia.length; i++) {
				if (ia[i] == color * WK)
					if (!(isPinnedBy(c, pinned)))
						return true;
			}
		}
		return false;
	}
	private boolean isPinnedBy(Coordinate c, Coordinate[] pinned) {
		for (int i = 0; i < pinned.length; i++) {
			if (c.equals(pinned[i]))
				return true;
		}
		return false;
	}
	public void move(Coordinate c, Coordinate C) throws IllegalMoveException,
			PromotionException, GameEndException {
		int p;
		p = getPosition(c);
		if (p == WP && C.y == 7 || p == BP && C.x == 0) {
			throw new PromotionException();
		}
		tryMove(c, C, 0);
	}
	public void move(Coordinate c, Coordinate C, int promotionPiece)
			throws IllegalMoveException, GameEndException {
		tryMove(c, C, promotionPiece);
	}
	/**
	 * paste a line, make a variation
	 */
	public void paste(Line l) throws LineCannotAccessedException {
		/*
		 * RootLine should not hava any variation if then do nothing
		 */
		if (line == this)
			throw new LineCannotAccessedException();
		line.joints[num - num1] = l;
	}
	private Coordinate searchKing(int color) {
		for (int f = 0; f < 8; f++) {
			for (int r = 0; r < 8; r++) {
				if (board.P[f][r] == color * WK) {
					return new Coordinate(f, r);
				}
			}
		}
		return null; //will never happen
	}
	public void setMove(Move m) throws LineCannotAccessedException {
		if (line == this)
			throw new LineCannotAccessedException();
		line.moves[num] = m;
	}
	public void setPosition(Coordinate c, int piece) {
		try {
			board.P[c.x][c.y] = (byte) piece;
		} catch (ArrayIndexOutOfBoundsException e) {
			// do nothing
		}
	}
	/**
	 * count up lines while joints[x] exists.
	 */
	private void sub2enumVariations(Line l) {
		if (l.joints[num - num1] == null)
			return;
		variations.y++;
		l = l.joints[num - num1];
		sub2enumVariations(l);
	}
	/**
	 * count up lines while pline is a greater line
	 */
	private void subenumVariations(Line l) {
		if (l.pline == this || pline.num1 != line.num1)
			return;
		variations.x++;
		l = l.pline;
		subenumVariations(l);
	}
	/**
	 * 1.inspect the move 1.0 examine En Passant availability and Castling
	 * availability 1.5.find pinned piece 2.examine check 3.check checkmate
	 * 4.check stalemate 5.check reputation-draw. promotionPiece should be int
	 * 2,3,4,5
	 */
	private void tryMove(Coordinate c, Coordinate C, int promotionPiece)
			throws IllegalMoveException, GameEndException {
		Move move = new Move(0, null, 1, 0, null, board);
		int[][] iaa;
		int[] ia;
		Coordinate d;
		Coordinate D;
		Coordinate fk;
		Coordinate ek;
		Coordinate[] pinned;
		Coordinate[] nullca;
		boolean b;
		int a;
		Board _board;
		int p = getPosition(c);
		if (p == SP)
			throw new IllegalMoveException();
		move.p = Math.abs(p);
		if (getColor(p) * color != 1)
			throw new IllegalMoveException();
		if (c.equals(C))
			throw new IllegalMoveException();
		/*
		 * 1.inspect the move 1.0 examine En Passant availability and Castling
		 * availability
		 */
		inspect : switch (Math.abs(p)) {
			case WP :
				switch (C.x - c.x) {
					/*
					 * pawn moves straight forward
					 */
					case 0 :
						ia = getMovingPawnMove(c, color);
						if (ia[0] != SP) {
							if (c.y - C.y == color)
								break;
							if (ia[1] != SP)
								if (Math.abs(C.y - c.y) == 2)
									break;
						}
						throw new IllegalMoveException();
					/*
					 * pawn capture something right
					 */
					case 1 :
						ia = getAttackingPawnMove(c, color);
						if (c.y - C.y == color) {
							if (getColor(ia[0]) == -color)
								break;
							/*
							 * En Passant
							 */
							else if (getColor(ia[0]) == 0) {
								if (getMove().fen % 9 == C.x)
									break;
							}
						}
						throw new IllegalMoveException();
					/*
					 * pawn capture something left
					 */
					case -1 :
						ia = getAttackingPawnMove(c, color);
						if (c.y - C.y == color) {
							if (getColor(ia[1]) == -color)
								break;
							/*
							 * En Passant
							 */
							else if (getColor(ia[1]) == 0) {
								if (getMove().fen % 9 == C.x)
									break;
							}
						}
						throw new IllegalMoveException();
					case WN :
						if (Math.abs((C.x - c.x) * (C.y - c.y)) == 2)
							if (getColor(getPosition(C)) != color)
								break;
						throw new IllegalMoveException();
					case WB :
						iaa = getBishopMove(c);
						if (Math.abs(C.x - c.x) == Math.abs(C.y - c.y)) {
							d = new Coordinate(getColor(C.x - c.x),
									getColor(C.y - c.y));
							D = new Coordinate(1, 1);
							int i = 0;
							for (; !d.equals(D); i++) {
								/*
								 * (x + yi)(-i)
								 */
								d.x = d.y;
								d.y = -d.y;
							}
							for (int j = 0; j < Math.abs(C.x - c.x) - 1; j++) {
								if (iaa[i][j] != SP)
									throw new IllegalMoveException();
							}
							if (getColor(iaa[i][Math.abs(C.x - c.x)]) != color)
								break;
						}
						throw new IllegalMoveException();
					case WR :
						iaa = getRookMove(c);
						if (c.x == C.x) {
							for (int i = 0; i < Math.abs(C.y - c.y) - 1; i++) {
								if (iaa[3 - getColor(C.y - c.y)][i] != SP)
									throw new IllegalMoveException();
							}
							if (getColor(iaa[3 - getColor(C.y - c.y)][Math
									.abs(C.y - c.y)]) != color)
								break;
						}
						if (c.y == C.y) {
							for (int i = 0; i < Math.abs(C.x - c.x) - 1; i++) {
								if (iaa[3 - getColor(C.x - c.x)][i] != SP)
									throw new IllegalMoveException();
							}
							if (getColor(iaa[3 - getColor(C.x - c.x)][Math
									.abs(C.x - c.x)]) != color)
								break;
						}
						throw new IllegalMoveException();
					case WQ :
						iaa = getBishopMove(c);
						if (Math.abs(C.x - c.x) == Math.abs(C.y - c.y)) {
							d = new Coordinate(getColor(C.x - c.x),
									getColor(C.y - c.y));
							D = new Coordinate(1, 1);
							int i = 0;
							for (; !d.equals(D); i++) {
								/*
								 * (x + yi)(-i)
								 */
								d.x = d.y;
								d.y = -d.y;
							}
							for (int j = 0; j < Math.abs(C.x - c.x) - 1; j++) {
								if (iaa[i][j] != SP)
									throw new IllegalMoveException();
							}
							if (getColor(iaa[i][Math.abs(C.x - c.x)]) != color)
								break;
						}
						iaa = getRookMove(c);
						if (c.x == C.x) {
							for (int i = 0; i < Math.abs(C.y - c.y) - 1; i++) {
								if (iaa[2 - getColor(C.y - c.y)][i] != SP)
									throw new IllegalMoveException();
							}
							if (getColor(iaa[3 - getColor(C.y - c.y)][Math
									.abs(C.y - c.y)]) != color)
								break;
						}
						if (c.y == C.y) {
							for (int i = 0; i < Math.abs(C.x - c.x) - 1; i++) {
								if (iaa[3 - getColor(C.x - c.x)][i] != SP)
									throw new IllegalMoveException();
							}
							if (getColor(iaa[3 - getColor(C.x - c.x)][Math
									.abs(C.x - c.x)]) != color)
								break;
						}
						throw new IllegalMoveException();
					case WK :
						iaa = new int[1][];
						ia = getKingMove(C);
						b = false;
						for (int i = 0; i < 8; i++) {
							if (ia[i] == color * WK)
								break inspect;
						}
						if (C.y - c.y == 0) {
							/*
							 * short castling
							 */
							if (C.x - c.x == 2) {
								if ((9 <= getMove().fen && getMove().fen < 18))
									break;
							}
							/*
							 * long castling
							 */
							if (C.x - c.x == -3) {
								if ((18 <= getMove().fen))
									break;
							}
						}
						throw new IllegalMoveException();
				}
		} //switch (Math.abs(p))
		/*
		 * 1.5.find pinned piece
		 */
		pinned = new Coordinate[8];
		ek = searchKing(-color);
		iaa = getRookMove(ek);
		b = false;
		d = null;
		for (int j = 0; j < 4; j++) {
			for (int i = 0; i < 7; i++) {
				if (iaa[j][i] == SP)
					continue;
				else if (getColor(iaa[j][i]) == -color) {
					if (b == true)
						break;
					b = true;
					d = new Coordinate(i, j);
				} else if (iaa[i][j] == color * WR || iaa[i][j] == color * WQ)
					pinned[2 * j] = d;//else enemy king is checked before
				// friend has moved >> error
				else
					break;
			}
			b = false;
		}
		iaa = getBishopMove(ek);
		for (int j = 0; j < 4; j++) {
			for (int i = 0; i < 7; i++) {
				if (iaa[j][i] == SP)
					continue;
				else if (getColor(iaa[j][i]) == -color) {
					if (b == true)
						break;
					b = true;
					d = new Coordinate(i, j);
				} else if (iaa[i][j] == color * WB || iaa[i][j] == color * WQ)
					pinned[2 * j + 1] = d;
				else
					break;
			}
			b = false;
		}
		/*
		 * 1.inspect the move
		 */
		if (promotionPiece == 0)
			setPosition(C, getPosition(c));
		else
			setPosition(C, promotionPiece);
		setPosition(c, SP);
		nullca = new Coordinate[8];
		fk = searchKing(color);
		if (isInfluencedBy(fk, -color, nullca, 10)) {
			board = getMove().P;
			throw new IllegalMoveException();
		}
		/*
		 * 2.examine checking
		 */
		/*
		 * a means the checking condition. d means checking piece's position;
		 */
		a = 0;
		b = true;
		loop : while (b) {
			b = false;
			ia = getAttackingPawnMove(ek, color);
			for (int i = 0; i < ia.length; i++) {
				if (ia[i] == color * WP) {
					a++;
					d = ek.add(-2 * i + 1, -color);
					break loop;
				}
			}
			ia = getkNightMove(ek);
			for (int i = 0; i < ia.length; i++) {
				if (ia[i] == color * WN) {
					a++;
					switch (i) {
						case 0 :
							d = ek.add(1, 2);
							break;
						case 1 :
							d = ek.add(2, 1);
							break;
						case 2 :
							d = ek.add(2, -1);
							break;
						case 3 :
							d = ek.add(1, -2);
							break;
						case 4 :
							d = ek.add(-1, -2);
							break;
						case 5 :
							d = ek.add(-2, -1);
						case 6 :
							d = ek.add(-2, 1);
							break;
						case 7 :
							d = ek.add(-1, 2);
							break;
					}
				}
			}
			for (int j = 0; j < 4; j++) {
				for (int i = 0; i < 7; i++) {
					iaa[j][i] = getPosition(c.add((i + 1) * C.x, (i + 1) * C.y));
				}
			}
			iaa = getBishopMove(ek);
			D = new Coordinate(1, 1);
			for (int j = 0; j < 4; j++) {
				for (int i = 0; i < 7; i++) {
					if (iaa[j][i] == SP)
						continue;
					else if (iaa[i][j] == color * WB || iaa[i][j] == color * WQ) {
						a++;
						d = ek.add((i + 1) * D.x, (i + 1) * D.y);
					}
					break;
				}
				/*
				 * (x + yi)i
				 */
				D.x = -D.y;
				D.y = D.x;
			}
			D = new Coordinate(0, 1);
			iaa = getRookMove(ek);
			for (int j = 0; j < 4; j++) {
				for (int i = 0; i < 7; i++) {
					if (iaa[j][i] == SP)
						continue;
					else if (iaa[i][j] == color * WR || iaa[i][j] == color * WQ) {
						a++;
						d = ek.add((i + 1) * D.x, (i + 1) * D.y);
					}
					break;
				}
				/*
				 * (x + yi)i
				 */
				D.x = -D.y;
				D.y = D.x;
			}
		}
		/*
		 * king cannot escape by himself
		 */
		if (!(isInfluencedBy(ek.add(0, 1), color, nullca, 10))
				&& (getColor(getPosition(ek.add(0, 1))) != -color)
				|| !(isInfluencedBy(ek.add(1, 1), color, nullca, 10))
				&& (getColor(getPosition(ek.add(1, 1))) != -color)
				|| !(isInfluencedBy(ek.add(1, 0), color, nullca, 10))
				&& (getColor(getPosition(ek.add(1, 0))) != -color)
				|| !(isInfluencedBy(ek.add(1, -1), color, nullca, 10))
				&& (getColor(getPosition(ek.add(1, -1))) != -color)
				|| !(isInfluencedBy(ek.add(0, -1), color, nullca, 10))
				&& (getColor(getPosition(ek.add(0, -1))) != -color)
				|| !(isInfluencedBy(ek.add(-1, 1), color, nullca, 10))
				&& (getColor(getPosition(ek.add(-1, -1))) != -color)
				|| !(isInfluencedBy(ek.add(-1, 0), color, nullca, 10))
				&& (getColor(getPosition(ek.add(-1, 0))) != -color)
				|| !(isInfluencedBy(ek.add(-1, 1), color, nullca, 10))
				&& (getColor(getPosition(ek.add(-1, 1))) != -color)) {
			if (a != 0) {
				move.p *= 9;
				/*
				 * 3.check checkmate
				 */
				if (a == 2) {
					/*
					 * checkmate!
					 */
					move.p *= 9;
					try {
						go(1);
						setMove(move);
					} catch (LineCannotAccessedException e) {
						// will never happen
					}
					throw new GameEndException(color);
				} else {
					/*
					 * try capturing the checking piece
					 */
					if (!(isInfluencedBy(d, -color, pinned, 2))) {
						/*
						 * try intervening
						 */
						a = Math.abs(getPosition(d));
						if (a == WQ) {
							if (d.x == ek.x || d.y == ek.y)
								a = WR;
							else
								a = WB;
						}
						inspect : switch (Math.abs(getPosition(d))) {
							case WB :
								for (int i = 1; i < d.x - fk.x; i++) {
									if (isInfluencedBy(fk.add(i
											* getColor(d.x - fk.x), i
											* getColor(d.y - fk.y)), -color,
											pinned, 3))
										break inspect;
								}
								move.p *= 9;
								try {
									go(1);
									setMove(move);
								} catch (LineCannotAccessedException e) {
									// will never happen
								}
								throw new GameEndException(color);
							case WR :
								if (d.x == ek.x) {
									for (int i = 1; i < d.y - fk.y; i++) {
										if (isInfluencedBy(fk.add(d.x, i
												* getColor(d.y - fk.y)),
												-color, pinned, 3))
											break inspect;
									}
								} else {
									for (int i = 1; i < d.x - fk.x; i++) {
										if (isInfluencedBy(fk.add(i
												* getColor(d.x - fk.x), d.y),
												-color, pinned, 3))
											break inspect;
									}
								}
								move.p *= 9;
								try {
									go(1);
									setMove(move);
								} catch (LineCannotAccessedException e) {
									// will never happen
								}
								throw new GameEndException(color);
						}
					}
				}
			} else {
				/*
				 * 4.check stalemate
				 */
				nullca = new Coordinate[15];// recycling nullca
				a = 0;//index
				for (int f = 0; f < 8; f++) {
					for (int r = 0; r < 8; r++) {
						if (getColor(board.P[f][r]) == -color
								&& board.P[f][r] != -color * WQ) {
							d = new Coordinate(f, r);
							if (!(isPinnedBy(d, pinned))) {
								if (Math.abs(getPosition(d)) == WP) {
									ia = getAttackingPawnMove(d, -color);
									if (getColor(ia[0]) == color
											|| getColor(ia[1]) == color)
										break;
									if (getMovingPawnMove(d, -color)[0] == SP)
										break;
								}
							}
							try {
								go(1);
								setMove(move);
							} catch (LineCannotAccessedException e) {
								//								 will never happen
							}
							throw new GameEndException(2);
						}
					}
				}
			} //if (a != 0)
		} //if (!(isInfluencedBy(ek.add(0, 1), color, nullca, 10))...
		/*
		 * 5.check reputation-draw
		 */
		_board = board;
		a = 1;// counts up go();
		b = false;
		for (int i = 1;; a += 2) {// counts up same position
			if (b) {
				try {
					go(-1);
				} catch (LineCannotAccessedException e1) {
					break;
				}
				if (Math.abs(p) == WP) {
					a -= 1;
					break;
				}
			} else
				b = true;
			try {
				go(-1);
			} catch (LineCannotAccessedException e1) {
				break;
			}
			if (Math.abs(p) == WP)
				break;
			if (_board.equals(board))
				i++;
			if (i == 3) {
				try {
					go(a);
					go(1);
					setMove(move);
				} catch (LineCannotAccessedException e) {
					//								 will never happen
				}
				throw new GameEndException(3);
			}
		}
		try {
			go(a);
			go(1);
			setMove(move);
		} catch (LineCannotAccessedException e) {
			// will never happen
		}
	}
}
