#pragma once

#include "..\WcsAPI\WcsAPI.h"
#include "Export.h"
#include "StringSplit.h"

// ToDo:
#include "Flactale.h"

//////////////////////////////////////////////////////////////////////////

class CDefaultPlugin : public CPlugin, CStringSplit
{
protected:
	CDefaultPlugin();
	virtual ~CDefaultPlugin();

public:
	// Override method
	virtual BOOL  LoadInitialize();
	virtual void  ReceiveCallBack(const CByteArray &data);

	virtual BOOL  MasterInitialize(const NodeDataList &list, BOOL fSystem);
	virtual BOOL  MasterFinalize();
	virtual DWORD MasterTransaction(LPVOID lpParams);

	virtual BOOL  SlaveInitialize(const SLAVE_PLUGIN &init);
	virtual BOOL  SlaveFinalize();
	virtual DWORD SlaveTransaction(LPVOID lpParams);

public:
	friend CPlugin *CreatePlugin();
	friend void	ReleasePlugin(CDefaultPlugin *obj);

protected:
	void doConstructor();
	void doLoadInitialize();
	BOOL doMasterInitialize(const MASTER_PLUGIN &init);
	void doMasterFinalize();
	BOOL doSlaveInitialize(const SLAVE_PLUGIN &init);
	void doSlaveFinalize();
};

//////////////////////////////////////////////////////////////////////////

CPlugin *CreatePlugin()
{
	return (new CDefaultPlugin());
}

void ReleasePlugin(CDefaultPlugin *obj)
{
	delete obj;
}

//////////////////////////////////////////////////////////////////////////

inline void CDefaultPlugin::doConstructor()
{
	m_CalcSize.nWidth  = CALC_WIDTH;
	m_CalcSize.nHeight = CALC_HEIGHT;
	m_CalcSize.nRange  = CALC_RANGE;
}

inline void CDefaultPlugin::doLoadInitialize()
{
	m_PlgInfo.wPluginID  = PLGINFO_ID;
	m_PlgInfo.wType      = PLGINFO_TYPE;
	m_PlgInfo.wVersion   = PLGINFO_VERSION;
	m_PlgInfo.dwTimeout  = PLGINFO_TIMEOUT;	
	m_PlgInfo.nBuildType = BUILD_TYPE;
	CopyMemory(&m_PlgInfo.szText, PLGINFO_TEXT, MC_MINSIZE(m_PlgInfo.szText, PLGINFO_TEXT));
}

inline BOOL CDefaultPlugin::doMasterInitialize(const MASTER_PLUGIN &init)
{
	if (!CPlugin::doCreateWindow(init))
	{
		return FALSE;
	}

	return API_StartTimer(), TRUE;
}

inline void CDefaultPlugin::doMasterFinalize()
{
	if (!m_fSystem)
	{
		API_StopTimer();
		API_StopPlugin(m_Reportlist);
	}
}

inline BOOL CDefaultPlugin::doSlaveInitialize(const SLAVE_PLUGIN &init)
{
	API_InitProgress(init.dwProcessors);
	return CPlugin::SlaveInitialize(init);
}

inline void CDefaultPlugin::doSlaveFinalize()
{
	if (m_fRunning)
	{
		API_StopPlugin(m_SlavePlugin.dbRuntime);
	}
}

//////////////////////////////////////////////////////////////////////////