#include "stdafx.h"
#include "WinCS.h"
#include "BMConfirmDlg.h"

IMPLEMENT_DYNAMIC(CBMConfirmDlg, CDialog)

BEGIN_MESSAGE_MAP(CBMConfirmDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CBMConfirmDlg::OnBnClickedOk)
	ON_WM_CTLCOLOR()
	ON_CBN_SELCHANGE(IDC_CMB_BMCONFIRM_MODE, &CBMConfirmDlg::OnCbnSelchangeCmbBmconfirmMode)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CBMConfirmDlg::CBMConfirmDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBMConfirmDlg::IDD, pParent),
	m_nSlaves(0),
	m_nSystemProcessors(0),
	m_nSingleProcessors(0),
	m_fSystem(FALSE)
{
}

CBMConfirmDlg::~CBMConfirmDlg()
{
}

void CBMConfirmDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CMB_BMCONFIRM_MODE, m_xCmbMode);
	DDX_Control(pDX, IDC_EDIT_BMCONFIRM_SLAVES, m_xEditSlaves);
	DDX_Control(pDX, IDC_EDIT_BMCONFIRM_PROCESSORS, m_xEditProcessors);
}

BOOL CBMConfirmDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CString cs;

	m_xCmbMode.AddString(_T("Single"));
	m_xCmbMode.AddString(_T("System"));
	m_xCmbMode.SetCurSel(0);
	
	m_xEditSlaves.SetWindowText(DwToString(m_nSlaves));
	m_xEditProcessors.SetWindowText(DwToString(m_nSingleProcessors));

	return FALSE;
}

void CBMConfirmDlg::OnBnClickedOk()
{
	CString cs;
	int nMode = m_xCmbMode.GetCurSel();

	if ((nMode == 1) && (m_nSlaves < 1))
	{
		cs.LoadString(IDS_WCS_ERROR_EXECUTION_MODE_SELECT);
		AfxMessageBox(cs);
		return;
	}

	m_fSystem = (nMode == 1);

	OnOK();
}

HBRUSH CBMConfirmDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	int nCtlID = pWnd->GetDlgCtrlID();

	switch (nCtlID)
	{
	case IDC_EDIT_BMCONFIRM_SLAVES:
	case IDC_EDIT_BMCONFIRM_PROCESSORS:
		hbr = static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH));
		pDC->SetBkColor(RGB(255, 255, 255));
		break;
	}

	return hbr;
}

void CBMConfirmDlg::OnCbnSelchangeCmbBmconfirmMode()
{
	UINT nProcessors = (m_xCmbMode.GetCurSel() == 0) ? m_nSingleProcessors : m_nSystemProcessors;
	m_xEditProcessors.SetWindowText(DwToString(nProcessors));
}


//////////////////////////////////////////////////////////////////////////