#pragma once

#include "afxcmn.h"
#include "afxwin.h"
#include "PictureEx.h"

//////////////////////////////////////////////////////////////////////////

class CBMSingleDlg : public CDialog, CStringConvert
{
	DECLARE_DYNAMIC(CBMSingleDlg)
public:
	CBMSingleDlg(CWnd* pParent = NULL);
	virtual ~CBMSingleDlg();

	enum { IDD = IDD_BMSINGLE_DIALOG };

	BOOL StartTimer();
	BOOL StartBenchmarkTest();
	void StopTimer(BOOL fForce);
	void RuntimeTimer();
	void CancelBenchmarkTest();
	void BenchmarkTestFinish();
	void OutputBenchmarkResult();
	void SetProgressPoint(int nPoint);
	void SetProcessData(BM_PROCESS bp);
	void SetBMData(DWORD dwIndex, BM_DATA bm, LPBOOL lpfOutput);
	void SetNodeType(WORD wNodeType) { m_wNodeType = wNodeType; }
	void SetProcessors(DWORD dwProcessors) { m_dwProcessors = dwProcessors; }
	BOOL IsAlived(DWORD dwIndex) { return m_fpList[dwIndex].fAlive; }
	BM_DATA GetBMData() { return m_bmResult.bm; }
	CStopwatch GetTimer() { return m_Stopwatch; }	

protected:
	DECLARE_MESSAGE_MAP()
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual BOOL OnInitDialog();

	afx_msg void OnBnClickedOk() {}
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnBnClickedBtnBmsingleClose();
	afx_msg void OnBnClickedBtnBmsingleHelp();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg LRESULT OnBMTestFinish(WPARAM wParam, LPARAM lParam);

	void CloseSingleBenchmark();
	void CloseHandleList();
	BOOL SaveReport();

	static void  WINAPI doRuntimeTimer(LPVOID pvContext, BOOLEAN fTimeout);
	static DWORD WINAPI doBenchmark(LPVOID pvParam);

public:
	CProgressCtrl m_xProgress;
	CListCtrl	  m_xDataList;
	CPictureEx	  m_xImgLoader;	
	CButton		  m_xBtnClose;
	CStatic		  m_xTxtPercent;
	CStatic		  m_xTxtState;
	CEdit		  m_xEditAverage;
	CEdit		  m_xEditRuntime;
	CEdit		  m_xEditProcessors;

protected:
	typedef struct _FLOPS_PARAMS
	{
		CBMSingleDlg *obj;
		DWORD dwIndex;
		DWORD dwAffinity;
		BOOL  fAlive;
	}
	FLOPS_PARAMS, *LPFLOPS_PARAMS;

	typedef struct _AFFINITY
	{
		BM_PROCESS bpArray[8];
		DWORD	   dwAftyCntArray[8];
		CLock	   lock;
	}
	AFFINITY, *LPAFFINITY;

	typedef struct _PRG_POINT
	{
		DWORD dwPointArray[11];
		CLock lock;
	}
	PRG_POINT, *LPPRG_POINT;

	typedef struct _BM_RESULT
	{
		BM_DATA	bm;
		DWORD   dwAftyCnt;
		CLock   lock;
	}
	BM_RESULT, *LPBM_RESULT;

	typedef struct _BM_PROCESSOR
	{
		BM_DATA bm;
		DWORD	dwIndex;
	}
	BM_PROCESSOR, *LPBM_PROCESSOR;

	typedef CArray<FLOPS_PARAMS> FPList;
	typedef CArray<BM_PROCESSOR> BPList;

protected:
	CCriticalSection m_cs;
	CStopwatch		 m_Stopwatch;
	HandleList		 m_ThdList;
	DWORDList		 m_ThdIDList;
	PRG_POINT		 m_PrgPoint;
	BM_RESULT		 m_bmResult;	
	AFFINITY		 m_Affinity;
	HANDLE			 m_hTimer;
	FPList			 m_fpList;
	BPList			 m_bpList;
	HICON			 m_hIcon;
	DWORD			 m_dwProcessors;
	BOOL			 m_fEnd;
	WORD			 m_wNodeType;				
};

//////////////////////////////////////////////////////////////////////////
