#pragma once

#include "afxcmn.h"
#include "afxwin.h"
#include "PictureEx.h"

//////////////////////////////////////////////////////////////////////////

class CBMSystemDlg : public CDialog, CStringConvert
{
	DECLARE_DYNAMIC(CBMSystemDlg)

public:
	CBMSystemDlg(CWnd* pParent = NULL);
	virtual ~CBMSystemDlg();
	enum { IDD = IDD_BMSYSTEM_DIALOG };

	void SetNodeList(const NodeDataList &list);
	void SetProgressPoint(WORD wNodeID, int nPoint);	// Per node
	void SetProgress(int nPoint);						// System
	void SetTestScore(WORD wNodeID, BM_DATA bm);
	void SetSystemScore(BM_SYSTEMSCORE bmScore, const CString &csLogPath);
	void GetRuntimeText(CString &cs) { m_xEditRuntime.GetWindowText(cs); }

protected:
	DECLARE_MESSAGE_MAP()
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual BOOL OnInitDialog();

	afx_msg void OnBnClickedOk() {}
	afx_msg void OnBnClickedBtnBmsystemClose();
	afx_msg void OnBnClickedBtnBmsystemHelp();
	afx_msg void OnBnClickedBtnBmsystemLog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);

	int  SearchNodeListIndex(WORD wNodeID);
	BOOL StartTimer();
	void StopTimer();
	void RuntimeTimer();

	static void WINAPI  doRuntimeTimer(LPVOID pvContext, BOOLEAN fTimeout);

public:
	CProgressCtrl m_xProgress;
	CPictureEx	  m_xImgLoader;
	CListCtrl	  m_xNodeList;
	CButton		  m_xBtnLog;
	CStatic		  m_xTxtPercent;
	CStatic		  m_xTxtState;
	CEdit		  m_xEditRuntime;
	CEdit		  m_xEditNodes;
	CEdit		  m_xEditTotal;
	CEdit		  m_xEditAverage;
	CEdit		  m_xEditProcessors;
	CEdit		  m_xEditHigh;
	CEdit		  m_xEditLow;

protected:
	CCriticalSection m_cs;
	NodeDataList     m_NodeList;
	CStopwatch		 m_Stopwatch;
	CString			 m_LogPath;
	HANDLE			 m_hTimer;
	HICON			 m_hIcon;
	BOOL		     m_fEnd;
};

//////////////////////////////////////////////////////////////////////////
