#pragma once

///////////////////////////////////////////////////////////////////////////////

// Config
#define WCS_MAX_NETSIZE					10
#define WCS_SLAVE_AUTOEXIT_TIME			5000	// 5 seconds
#define WCS_QUEUE_SIZE					1000

// Header size
#define TCPHDR_SIZE						20
#define UDPHDR_SIZE						10

// Socket ID
#define WCS_SOCKID_STREAM_SERVER		1000
#define WCS_SOCKID_STREAM_CLIENT		2000
#define WCS_SOCKID_PEER_SERVER			4000
#define WCS_SOCKID_PEER_CLIENT			3000

// Config
#define WCS_DEFAULT_BCAST_ADDRESS		-1
#define WCS_DEFAULT_MASTER_ADDRESS		-1
#define WCS_DEFAULT_TCP_PORT			20000
#define WCS_DEFAULT_UDP_CLIENT_PORT		20001
#define WCS_DEFAULT_UDP_SERVER_PORT		20002
#define WCS_DEFAULT_TIMEOUT				3000
#define WCS_DEFAULT_RETRY				3
#define WCS_DEFAULT_NODE_ID				0xFFFF
#define WCS_MASTER_NODE_ID				0x0000

// Node type
#define WCS_NODE_UNDEFINED				0x0001
#define WCS_NODE_SLAVE					0x0002
#define WCS_NODE_MASTER					0x0004

// Node state
#define WCS_STATE_WAITING				1000
#define WCS_STATE_EXECUTING				1001
#define WCS_STATE_BENCHMARKING			1002
#define WCS_STATE_DOWNLOADING			1003

// Plugin state
#define WCS_PLUGIN_IDLE					2000
#define WCS_PLUGIN_RUNNING				2001
#define WCS_PLUGIN_FINISH				2002

// TCP Message
#define WCS_MSG_MASTER_ACCEPT			3000
#define WCS_MSG_MASTER_ACCEPT_ACK		3001
#define WCS_MSG_BENCHMARK_START			3002
#define WCS_MSG_BENCHMARK_START_ACK		3003
#define WCS_MSG_BENCHMARK_RESULT		3004
#define WCS_MSG_BENCHMARK_RESULT_ACK	3005
#define WCS_MSG_BENCHMARK_CANCEL		3006
#define WCS_MSG_BENCHMARK_CANCEL_ACK	3007
#define WCS_MSG_BENCHMARK_PROGRESS		3008
#define WCS_MSG_BENCHMARK_RANKING		3009
#define WCS_MSG_PLAINTEXT				3010
#define WCS_MSG_CHANGE_PROCESSOR_COUNT	3011

// Plugin
#define WCS_MSG_PLUGIN_START			3100
#define WCS_MSG_PLUGIN_START_ACK		3101
#define WCS_MSG_PLUGIN_CANCEL			3102
#define WCS_MSG_PLUGIN_CANCEL_ACK		3103
#define WCS_MSG_PLUGIN_STOP				3104
#define WCS_MSG_PLUGIN_RAWDATA			3105
#define WCS_MSG_PLUGIN_RAWDATA_ACK		3106
#define WCS_MSG_PLUGIN_TRANSFER			3107

// UDP Message
#define WCS_MSG_MASTER_DISCOVER			4000
#define WCS_MSG_MASTER_OFFER			4001

// Window message
#define WM_SHOWN					(WM_USER + 100)
#define WM_PLUGIN_RELOAD			(WM_USER + 101)
#define WM_PLUGIN_CHANGE			(WM_USER + 102)
#define WM_PLUGIN_LOCK				(WM_USER + 103)
#define WM_PLUGIN_TRANSFER			(WM_USER + 104)
#define WM_PLUGIN_TRANSFER_ERROR	(WM_USER + 105)
#define WM_PLUGIN_SENDING			(WM_USER + 106)
#define WM_WCS_EXECUTE				(WM_USER + 107)
#define WM_WCS_STOP					(WM_USER + 108)
#define WM_WCS_BENCHMARK			(WM_USER + 109)
#define WM_LOG_OUTPUT				(WM_USER + 110)
#define WM_BMSYSTEM_PROGRESS		(WM_USER + 111)
#define WM_BMSYSTEM_FINISH			(WM_USER + 112)
#define WM_SEND_TEXT				(WM_USER + 113)
#define WM_SHOW_LOG					(WM_USER + 114)
#define WM_OUTPUT_REPORT			(WM_USER + 115)

///////////////////////////////////////////////////////////////////////////////