#pragma once
#include "afxwin.h"

//////////////////////////////////////////////////////////////////////////

class CEXEConfirmDlg : public CDialog, CStringConvert
{
	DECLARE_DYNAMIC(CEXEConfirmDlg)

public:
	CEXEConfirmDlg(CWnd* pParent = NULL);
	virtual ~CEXEConfirmDlg();
	enum { IDD = IDD_EXECONFIRM_DIALOG };

	void SetPlugin(const CString &cs) { m_csModule = cs; }
	void SetSlaves(UINT nSlaves) { m_nSlaves = nSlaves; }
	void SetSystemProcessors(UINT nProcessors) { m_nSystemProcessors = nProcessors; }
	void SetSingleProcessors(UINT nProcessors) { m_nSingleProcessors = nProcessors; }
	void SetCalcSize(CALCSIZE size) { m_CalcSize = size; }
	void GetCalcSize(CALCSIZE &size) { size = m_CalcSize; }
	void GetArgument(CString &arg) { arg = m_csArgument; }
	BOOL IsSystemMode() { return m_fSystem; }

protected:
	DECLARE_MESSAGE_MAP()
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual BOOL OnInitDialog();

	afx_msg void OnBnClickedOk();
	afx_msg void OnCbnSelchangeCmbExeconfirmMode();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);

public:
	CComboBox m_xCmbMode;
	CEdit	  m_xEditSlaves;
	CEdit	  m_xEditPlugin;
	CEdit	  m_xEditArgument;
	CEdit	  m_xEditWidth;
	CEdit	  m_xEditHeight;
	CEdit	  m_xEditRange;
	CEdit	  m_xEditProcessors;

protected:
	CALCSIZE  m_CalcSize;
	CString   m_csModule;
	CString   m_csArgument;
	BOOL	  m_fSystem;
	UINT	  m_nSlaves;
	UINT	  m_nSystemProcessors;
	UINT	  m_nSingleProcessors;
};

//////////////////////////////////////////////////////////////////////////