#include "stdafx.h"
#include "WinCS.h"
#include "MasterSettingDlg.h"

IMPLEMENT_DYNAMIC(CMasterSettingDlg, CDialog)

BEGIN_MESSAGE_MAP(CMasterSettingDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CMasterSettingDlg::OnBnClickedOk)
	ON_CBN_SELCHANGE(IDC_CMB_MASTER_SETTING_CONNECTION, &CMasterSettingDlg::OnCbnSelchangeCmbConnections)
	ON_WM_CTLCOLOR()
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CMasterSettingDlg::CMasterSettingDlg(CWnd* pParent)
	: CDialog(CMasterSettingDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_SETTING);
	m_MasterSetting.fInternet    = TRUE;
	m_MasterSetting.nConnections = UINT_MAX;
	m_MasterSetting.nProcessors  = UINT_MAX;
}

CMasterSettingDlg::~CMasterSettingDlg()
{
}

void CMasterSettingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CMB_MASTER_SETTING_CONNECTION, m_xCmbLimit);
	DDX_Control(pDX, IDC_EDIT_MASTER_SETTING_COUNT1, m_xEditCount1);
	DDX_Control(pDX, IDC_CHECK_MASTER_SETTING_INTERNET, m_xCheckInternet);
	DDX_Control(pDX, IDC_SPIN_MASTER_SETTING_CONNECTION, m_xSpnCount1);
	DDX_Control(pDX, IDC_SPIN_MASTER_SETTING_PROCESSORS, m_xSpnCount2);
	DDX_Control(pDX, IDC_EDIT_MASTER_SETTING_COUNT2, m_xEditCount2);
	DDX_Control(pDX, IDC_TXT_MASTER_SETTING_PROCESSORS, m_xTxtCount);
	DDX_Control(pDX, IDC_RADIO_MASTER_SETTING_GRAPHICS1, m_xRadioGraphics1);
	DDX_Control(pDX, IDC_RADIO_MASTER_SETTING_GRAPHICS2, m_xRadioGraphics2);
	DDX_Control(pDX, IDC_CHECK_MASTER_SETTING_LOG_PLUGIN, m_xCheckPlugin);
}

HBRUSH CMasterSettingDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	int nCtlID = pWnd->GetDlgCtrlID();

	switch (nCtlID)
	{
	case IDC_EDIT_MASTER_SETTING_COUNT2:
		hbr = static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH));
		pDC->SetBkColor(RGB(255, 255, 255));
		break;
	}

	return hbr;
}

BOOL CMasterSettingDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SYSTEM_INFO si;
	CString		cs;

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);

	GetSystemInfo(&si);
	m_dwMaxProcessors = si.dwNumberOfProcessors;
	cs.Format(_T("Maximum processors: %d"), m_dwMaxProcessors);
	m_xTxtCount.SetWindowText(cs);
	m_xCmbLimit.AddString(_T("Unlimited"));
	m_xCmbLimit.AddString(_T("Limited"));
	m_xSpnCount1.SetRange32(2, INT_MAX);
	m_xSpnCount2.SetRange32(1, m_dwMaxProcessors);
	m_xSpnCount2.SetPos32(m_MasterSetting.nProcessors);
	m_xRadioGraphics1.SetCheck(m_MasterSetting.fRtRendering ? BST_CHECKED : BST_UNCHECKED);
	m_xRadioGraphics2.SetCheck(m_MasterSetting.fRtRendering ? BST_UNCHECKED : BST_CHECKED);
	m_xCheckInternet.SetCheck(m_MasterSetting.fInternet ? BST_CHECKED : BST_UNCHECKED);
	m_xCheckPlugin.SetCheck(m_MasterSetting.fLogPlugin ? BST_CHECKED : BST_UNCHECKED);
	
	if (m_MasterSetting.nConnections == UINT_MAX)
	{
		m_xCmbLimit.SetCurSel(0);
		m_xEditCount1.EnableWindow(FALSE);
	}
	else
	{
		m_xCmbLimit.SetCurSel(1);
		m_xSpnCount1.SetPos32(m_MasterSetting.nConnections);
	}

	return TRUE;
}

void CMasterSettingDlg::OnBnClickedOk()
{
	CString cs;
	BOOL fError;
	UINT nConnections = UINT_MAX;
	UINT nProcessors  = UINT_MAX;
	int  nIndex;

	nIndex = m_xCmbLimit.GetCurSel();

	if (nIndex == 1)
	{
		nConnections = GetDlgItemInt(IDC_EDIT_MASTER_SETTING_COUNT1, &fError, TRUE);

		if (!fError || nConnections < 2)
		{
			m_xEditCount1.SetFocus();
			cs.LoadString(IDS_WCS_ERROR_CONNECTION_LIMIT);
			AfxMessageBox(cs);
			return;
		}
	}

	nProcessors = GetDlgItemInt(IDC_EDIT_MASTER_SETTING_COUNT2, &fError, TRUE);

	if (!fError || nProcessors < 1 || nProcessors > m_dwMaxProcessors)
	{
		m_xEditCount2.SetFocus();
		cs.LoadString(IDS_WCS_ERROR_PROCESSOR_LIMIT);
		AfxMessageBox(cs);
		return;
	}
	
	m_MasterSetting.nConnections  = nConnections;
	m_MasterSetting.nProcessors   = nProcessors;
	m_MasterSetting.fInternet     = (m_xCheckInternet.GetCheck() == BST_CHECKED);
	m_MasterSetting.fLogPlugin	  = (m_xCheckPlugin.GetCheck() == BST_CHECKED);
	m_MasterSetting.fRtRendering  = (m_xRadioGraphics1.GetCheck() == BST_CHECKED);
	
	OnOK();
}

void CMasterSettingDlg::OnCbnSelchangeCmbConnections()
{
	int nIndex = m_xCmbLimit.GetCurSel();

	if (nIndex == 1)
	{
		m_xEditCount1.EnableWindow(TRUE);
		m_xSpnCount1.SetPos32(50);
	}
	else
	{
		m_xEditCount1.EnableWindow(FALSE);
	}
}

//////////////////////////////////////////////////////////////////////////
