#include "stdafx.h"
#include "WinCS.h"
#include "MasterView.h"

IMPLEMENT_DYNAMIC(CMasterView, CDialog)

BEGIN_MESSAGE_MAP(CMasterView, CDialog)
	ON_BN_CLICKED(IDOK, &CMasterView::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BTN_MASTER_SEND, &CMasterView::OnBnClickedBtnMasterSend)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BTN_MASTER_PLUGIN_TRANSFER, &CMasterView::OnBnClickedBtnMasterPluginDistribution)
	ON_BN_CLICKED(IDC_CHECK_PLUGIN_LOCK, &CMasterView::OnBnClickedCheckPluginLock)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CMasterView::CMasterView(CWnd* pParent /*=NULL*/)
	: CDialog(CMasterView::IDD, pParent),
	m_fPluginLocked(FALSE)
{
}

CMasterView::~CMasterView()
{
}

void CMasterView::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_MASTER_NODELIST, m_xNodeList);
	DDX_Control(pDX, IDC_EDIT_MASTER_INPUT, m_xEditInput);
	DDX_Control(pDX, IDC_EDIT_MASTER_CONSOLE, m_xEditConsole);
	DDX_Control(pDX, IDC_EDIT_MASTER_SYSTEM_SLAVES, m_xEditSlaves);
	DDX_Control(pDX, IDC_EDIT_MASTER_SYSTEM_PROCESSORS, m_xEditProcessors);
	DDX_Control(pDX, IDC_EDIT_MASTER_BENCHMARK_NODES, m_xEditNodes);
	DDX_Control(pDX, IDC_EDIT_MASTER_BENCHMARK_SCORE, m_xEditScore);
	DDX_Control(pDX, IDC_EDIT_MASTER_BENCHMARK_RUNTIME, m_xEditRuntime);
	DDX_Control(pDX, IDC_EDIT_MASTER_PLUGIN, m_xEditPlugin);
	DDX_Control(pDX, IDC_EDIT_MASTER_BENCHMARK_TESTTIME, m_xEditTestTime);
	DDX_Control(pDX, IDC_BTN_MASTER_PLUGIN_TRANSFER, m_xBtnTransfer);
	DDX_Control(pDX, IDC_CHECK_PLUGIN_LOCK, m_xCheckLock);
}

BOOL CMasterView::OnInitDialog()
{
	CDialog::OnInitDialog();

	LVCOLUMN lvc;
	CRect	 cr;

	lvc.mask	= (LVCF_FMT | LVCF_TEXT | LVCF_WIDTH | LVCF_SUBITEM);
	m_xNodeList.GetClientRect(&cr);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 3 / 30;
	lvc.pszText	= _T("ID");
	m_xNodeList.InsertColumn(0, &lvc);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 8 / 30;
	lvc.pszText	= _T("IP Address");
	m_xNodeList.InsertColumn(1, &lvc);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 4 / 30;
	lvc.pszText	= _T("Port");
	m_xNodeList.InsertColumn(2, &lvc);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 4 / 30;
	lvc.pszText	= _T("CPU");
	m_xNodeList.InsertColumn(3, &lvc);

	lvc.fmt		= LVCFMT_CENTER;
	lvc.cx		= (cr.right - cr.left) * 5 / 30;
	lvc.pszText	= _T("Type");
	m_xNodeList.InsertColumn(4, &lvc);

	lvc.fmt		= LVCFMT_CENTER;
	lvc.cx		= (cr.right - cr.left) * 5 / 30;
	lvc.pszText	= _T("State");
	m_xNodeList.InsertColumn(5, &lvc);

	m_xNodeList.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_xEditInput.SetFocus();

	m_xEditSlaves.SetWindowText(STRING_ZERO);
	m_xEditProcessors.SetWindowText(STRING_ZERO);
	m_xEditNodes.SetWindowText(STRING_NONE);
	m_xEditScore.SetWindowText(STRING_NONE);
	m_xEditRuntime.SetWindowText(STRING_NONE);
	m_xEditTestTime.SetWindowText(STRING_NONE);

	return FALSE;
}

BOOL CMasterView::PreTranslateMessage(MSG* pMsg)
{
	if ((pMsg->message == WM_KEYDOWN && pMsg->wParam == VK_RETURN) &&
		(GetFocus() != NULL && GetFocus() == GetDlgItem(IDC_EDIT_MASTER_INPUT))) 
	{
		SendTextMessage();
		return TRUE;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

HBRUSH CMasterView::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	int nCtlID = pWnd->GetDlgCtrlID();

	switch (nCtlID)
	{
	case IDC_EDIT_MASTER_CONSOLE:
	case IDC_EDIT_MASTER_SYSTEM_SLAVES:
	case IDC_EDIT_MASTER_SYSTEM_PROCESSORS:
	case IDC_EDIT_MASTER_BENCHMARK_NODES:
	case IDC_EDIT_MASTER_BENCHMARK_SCORE:
	case IDC_EDIT_MASTER_BENCHMARK_RUNTIME:
	case IDC_EDIT_MASTER_BENCHMARK_TESTTIME:
	case IDC_EDIT_MASTER_PLUGIN:
		hbr = static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH));
		pDC->SetBkColor(RGB(255, 255, 255));
		break;
	}

	return hbr;
}

void CMasterView::SendTextMessage()
{
	CString cs;
	m_xEditInput.GetWindowText(m_MsgString);

	if (m_MsgString.GetLength() > 0)
	{
		cs.Format(_T("Local message : (%s)\r\n>> %s"), GetNowTime(), m_MsgString);
		AddConsoleText(cs);
		GetParent()->SendMessage(WM_SEND_TEXT);
		m_xEditInput.SetWindowText(STRING_EMPTY);
	}

	m_xEditInput.SetFocus();
}

void CMasterView::OnBnClickedBtnMasterSend()
{
	SendTextMessage();
}

int CMasterView::SearchNodeListIndex(WORD wNodeID)
{
	int  nIndex = -1;
	UINT nItemCount;
	BOOL find = FALSE;

	CSingleLock sl(&m_cs, TRUE);
	nItemCount = m_xNodeList.GetItemCount();

	for (UINT i = 0; i < nItemCount; i++)
	{
		if (m_xNodeList.GetItemText(i, 0) == DwToString(wNodeID))
		{
			nIndex = i;
			break;
		}
	}

	return nIndex;
}

void CMasterView::SetNodeState(WORD wNodeID, WORD wNodeState)
{
	CString cs;
	LVITEM  lvi;
	int nIndex = SearchNodeListIndex(wNodeID);

	if (nIndex != -1)
	{
		CSingleLock sl(&m_cs, TRUE);

		lvi.mask = (LVIF_TEXT | LVIF_IMAGE);
		cs = GetNodeState(wNodeState);
		lvi.iItem	 = nIndex;
		lvi.iSubItem = 5;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);
	}
}

void CMasterView::SetNodeProcessors(WORD wNodeID, DWORD dwProcessors)
{
	CString cs;
	LVITEM  lvi;
	int nIndex = SearchNodeListIndex(wNodeID);

	if (nIndex != -1)
	{
		CSingleLock sl(&m_cs, TRUE);

		lvi.mask = (LVIF_TEXT | LVIF_IMAGE);
		cs = DwToString(dwProcessors);
		lvi.iItem	 = nIndex;
		lvi.iSubItem = 3;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);
	}
}

void CMasterView::AddNodeList(NODE_DATA nd)
{
	CString	cs;
	LVITEM  lvi;
	UINT    nListSize;
	int 	nIndex;

	nIndex = SearchNodeListIndex(nd.wNodeID);

	if (nIndex == -1)
	{
		CSingleLock sl(&m_cs, TRUE);

		lvi.mask = (LVIF_TEXT | LVIF_IMAGE);
		nListSize = m_xNodeList.GetItemCount();

		cs = DwToString(nd.wNodeID);
		lvi.iItem	 = nListSize;
		lvi.iSubItem = 0;
		lvi.pszText  = MC_CStoSTR(cs);
		m_xNodeList.InsertItem(&lvi);

		cs = DwToIPAddress(nd.dwAddress);
		lvi.iItem	 = nListSize;
		lvi.iSubItem = 1;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);

		cs = DwToString(nd.wPort);
		lvi.iItem	 = nListSize;
		lvi.iSubItem = 2;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);

		cs = DwToString(nd.dwProcessors);
		lvi.iItem	 = nListSize;
		lvi.iSubItem = 3;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);

		cs = GetNodeType(nd.wNodeType);
		lvi.iItem	 = nListSize;
		lvi.iSubItem = 4;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);

		cs = GetNodeState(nd.wNodeState);
		lvi.iItem	 = nListSize;
		lvi.iSubItem = 5;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);
	}
}

void CMasterView::RemoveNodeList(WORD wNodeID)
{
	int nIndex = SearchNodeListIndex(wNodeID);

	if (nIndex != -1)
	{
		CSingleLock sl(&m_cs, TRUE);
		m_xNodeList.DeleteItem(nIndex);
	}
}


CString CMasterView::GetNodeState(WORD wNodeState)
{
	CString cs;

	switch (wNodeState)
	{
	case WCS_STATE_WAITING:
		cs = _T("Waiting");
		break;

	case WCS_STATE_EXECUTING:
		cs = _T("Executing");
		break;

	case WCS_STATE_BENCHMARKING:
		cs = _T("Benchmarking");
		break;
	}

	return cs;
}

CString CMasterView::GetNodeType(WORD wNodeType)
{
	CString cs;

	switch (wNodeType)
	{
	case WCS_NODE_MASTER:
		cs = _T("Master");
		break;

	case WCS_NODE_SLAVE:
		cs = _T("Slave");
		break;
	}

	return cs;
}

void CMasterView::AddConsoleText(const CString &csText, BOOL fReturn)
{
	CString cs;
	BOOL	bFocus;
	int		nLastPos;

	if (csText.GetLength() < 1)
	{
		return;
	}

	cs.Format(_T("%s%s"), csText, fReturn ? STRING_RETURN : STRING_EMPTY);
	nLastPos = m_xEditConsole.GetWindowTextLength();
	bFocus   = FALSE;

	if (::GetFocus() == m_xEditConsole.m_hWnd)
	{
		bFocus = TRUE;
		GetParent()->SetFocus();
	}

	m_xEditConsole.SetSel(nLastPos, nLastPos);
	m_xEditConsole.ReplaceSel(cs);

	if (bFocus)
	{
		m_xEditConsole.SetFocus();
	}
}

void CMasterView::OnBnClickedBtnMasterPluginDistribution()
{
	GetParent()->SendMessage(WM_PLUGIN_TRANSFER);
}

void CMasterView::OnBnClickedCheckPluginLock()
{
	m_fPluginLocked = (m_xCheckLock.GetCheck() == BST_CHECKED); 
	GetParent()->SendMessage(WM_PLUGIN_LOCK, (WPARAM)m_fPluginLocked, 0);
}

void CMasterView::SetSlaves(DWORD dwCount)
{
	m_xEditSlaves.SetWindowText(DwToString(dwCount));
}

void CMasterView::SetProcessors(DWORD dwCount)
{
	m_xEditProcessors.SetWindowText(DwToString(dwCount));
}

void CMasterView::SetPluginName(const CString &cs)
{
	m_xEditPlugin.SetWindowText(cs);
}

void CMasterView::ClearConsoleText() 
{ 
	m_xEditConsole.SetWindowText(STRING_EMPTY);
}

void CMasterView::GetSendMessage(CString &cs)
{ 
	cs = m_MsgString;
}

void CMasterView::GetConsoleText(CString &cs)
{
	m_xEditConsole.GetWindowText(cs);
}

void CMasterView::SetBenchmarkNodes(DWORD dwCount)
{
	m_xEditNodes.SetWindowText(DwToString(dwCount));
}

void CMasterView::SetBenchmarkScore(double dbScore)
{
	CString cs;
	cs.Format(_T("%.4lf GFLOPS"), dbScore);
	m_xEditScore.SetWindowText(cs);
}

void CMasterView::SetBenchmarkRuntime(double dbRuntime)
{
	m_xEditRuntime.SetWindowText(DbToHMSTime(dbRuntime));
}

void CMasterView::SetBenchmarkTestTime(const CString &cs)
{
	m_xEditTestTime.SetWindowText(cs);
}

void CMasterView::ResetBenchmark()
{
	m_xEditNodes.SetWindowText(STRING_NONE);
	m_xEditScore.SetWindowText(STRING_NONE);
	m_xEditRuntime.SetWindowText(STRING_NONE);
	m_xEditTestTime.SetWindowText(STRING_NONE);
}

//////////////////////////////////////////////////////////////////////////
