#pragma once

#include "afxcmn.h"
#include "afxwin.h"

//////////////////////////////////////////////////////////////////////////

class CMasterView : public CDialog, CStringConvert
{
	DECLARE_DYNAMIC(CMasterView)

public:
	CMasterView(CWnd* pParent = NULL);
	virtual ~CMasterView();
	enum { IDD = IDD_MASTER_VIEW };

	void AddNodeList(NODE_DATA nd);
	void RemoveNodeList(WORD wNodeID);
	void SetNodeState(WORD wNodeID, WORD wNodeState);
	void SetNodeProcessors(WORD wNodeID, DWORD dwProcessors);
	void SetSlaves(DWORD dwCount);
	void SetProcessors(DWORD dwCount);
	void SetPluginName(const CString &cs);
	void SetBenchmarkNodes(DWORD dwCount);
	void SetBenchmarkScore(double dbScore);
	void SetBenchmarkRuntime(double dbRuntime);
	void SetBenchmarkTestTime(const CString &cs);
	void AddConsoleText(const CString &csText, BOOL fReturn = TRUE);
	void ClearConsoleText();
	void GetSendMessage(CString &cs);
	void GetConsoleText(CString &cs);
	void ResetBenchmark();
	BOOL IsPluginLocked() { return m_fPluginLocked; }

protected:
	DECLARE_MESSAGE_MAP()
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual BOOL OnInitDialog();
	virtual BOOL PreTranslateMessage(MSG* pMsg);

	afx_msg void OnBnClickedOk() {}
	afx_msg void OnBnClickedBtnMasterSend();
	afx_msg void OnBnClickedBtnMasterPluginDistribution();
	afx_msg void OnBnClickedCheckPluginLock();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);

	int  SearchNodeListIndex(WORD wNodeID);
	void SendTextMessage();
	CString GetNodeType(WORD wNodeType);
	CString GetNodeState(WORD wNodeState);
	
public:
	CListCtrl m_xNodeList;
	CButton	  m_xBtnTransfer;
	CButton   m_xCheckLock;
	CEdit	  m_xEditInput;
	CEdit	  m_xEditConsole;
	CEdit	  m_xEditSlaves;
	CEdit	  m_xEditProcessors;
	CEdit	  m_xEditNodes;
	CEdit	  m_xEditScore;
	CEdit	  m_xEditRuntime;
	CEdit	  m_xEditPlugin;
	CEdit	  m_xEditTestTime;

protected:
	CCriticalSection m_cs;	
	CString m_MsgString;
	BOOL	m_fPluginLocked;
};

//////////////////////////////////////////////////////////////////////////

