#include "stdafx.h"
#include "WinCS.h"
#include "SetupConfigDlg.h"

IMPLEMENT_DYNAMIC(CSetupConfigDlg, CDialog)

BEGIN_MESSAGE_MAP(CSetupConfigDlg, CDialog)
	ON_CBN_SELCHANGE(IDC_CMB_SETUPCONFIG_MODE, &CSetupConfigDlg::OnCbnSelchangeCmbSetupconfigMode)
	ON_BN_CLICKED(IDOK, &CSetupConfigDlg::OnBnClickedOk)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CSetupConfigDlg::CSetupConfigDlg(CWnd* pParent)
	: CDialog(CSetupConfigDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_SETTING);
}

CSetupConfigDlg::~CSetupConfigDlg()
{
}

void CSetupConfigDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SETUPCONFIG_IPADDRESS, m_xIPAddressMaster);
	DDX_Control(pDX, IDC_CMB_SETUPCONFIG_MODE, m_xCmbDiscovery);
}

BOOL CSetupConfigDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, FALSE);

	m_xCmbDiscovery.AddString(_T("Dynamic"));
	m_xCmbDiscovery.AddString(_T("Static"));

	if (m_wcsStatus.fDynamic)
	{
		m_xCmbDiscovery.SetCurSel(0);
		m_xIPAddressMaster.EnableWindow(FALSE);
	}
	else
	{
		m_xCmbDiscovery.SetCurSel(1);
		m_wcsStatus.dwMasterAddress = htonl(m_wcsStatus.dwMasterAddress);
		m_xIPAddressMaster.SetAddress(m_wcsStatus.dwMasterAddress);
	}

	return TRUE;
}


void CSetupConfigDlg::OnCbnSelchangeCmbSetupconfigMode()
{
	int nSelect = m_xCmbDiscovery.GetCurSel();
	m_xIPAddressMaster.EnableWindow((nSelect == 0) ? FALSE : TRUE);

	if (nSelect == 1)
	{
		m_xIPAddressMaster.SetFocus();
	}
}

void CSetupConfigDlg::OnBnClickedOk()
{
	DWORD dwAddress;

	if (m_xCmbDiscovery.GetCurSel() == 0)
	{
		// Dynamic
		m_wcsStatus.dwMasterAddress = inet_addr("255.255.255.255");
		m_wcsStatus.fDynamic = TRUE;
	}
	else
	{
		// Static
		m_xIPAddressMaster.GetAddress(dwAddress);
		m_wcsStatus.dwMasterAddress = ntohl(dwAddress);
		m_wcsStatus.fDynamic = FALSE;
	}

	OnOK();
}

//////////////////////////////////////////////////////////////////////////
