#include "stdafx.h"
#include "WinCS.h"
#include "SlaveSettingDlg.h"

IMPLEMENT_DYNAMIC(CSlaveSettingDlg, CDialog)

BEGIN_MESSAGE_MAP(CSlaveSettingDlg, CDialog)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDOK, &CSlaveSettingDlg::OnBnClickedOk)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CSlaveSettingDlg::CSlaveSettingDlg(CWnd* pParent)
	: CDialog(CSlaveSettingDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_SETTING);
}

CSlaveSettingDlg::~CSlaveSettingDlg()
{
}

void CSlaveSettingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_SLAVE_SETTING_COUNT, m_xEditCount);
	DDX_Control(pDX, IDC_SPIN_SLAVE_SETTING_PROCESSORS, m_xSpnCount);
	DDX_Control(pDX, IDC_TXT_SLAVE_SETTING_PROCESSORS, m_xTxtCount);
	DDX_Control(pDX, IDC_CHECK_SLAVE_SETTING_AUTO_DOWNLOAD, m_xCheckDownload);
}

HBRUSH CSlaveSettingDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	int nCtlID = pWnd->GetDlgCtrlID();

	switch (nCtlID)
	{
	case IDC_EDIT_SLAVE_SETTING_COUNT:
		hbr = static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH));
		pDC->SetBkColor(RGB(255, 255, 255));
		break;
	}

	return hbr;
}

BOOL CSlaveSettingDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SYSTEM_INFO si;
	CString		cs;

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);

	GetSystemInfo(&si);
	m_dwMaxProcessors = si.dwNumberOfProcessors;
	cs.Format(_T("Maximum processors: %d"), m_dwMaxProcessors);
	m_xTxtCount.SetWindowText(cs);
	m_xSpnCount.SetRange32(1, m_dwMaxProcessors);
	m_xSpnCount.SetPos32(m_SlaveSetting.nProcessors);

	if (m_SlaveSetting.fAutoDownload)
	{
		m_xCheckDownload.SetCheck(BST_CHECKED);
	}

	return TRUE;
}

void CSlaveSettingDlg::OnBnClickedOk()
{
	CString cs;
	BOOL fError;
	UINT nProcessors  = UINT_MAX;

	nProcessors = GetDlgItemInt(IDC_EDIT_SLAVE_SETTING_COUNT, &fError, TRUE);

	if (!fError || nProcessors < 1 || nProcessors > m_dwMaxProcessors)
	{
		m_xEditCount.SetFocus();
		cs.LoadString(IDS_WCS_ERROR_PROCESSOR_LIMIT);
		AfxMessageBox(cs);
		return;
	}

	m_SlaveSetting.nProcessors   = nProcessors;
	m_SlaveSetting.fAutoDownload = (m_xCheckDownload.GetCheck() == BST_CHECKED);

	OnOK();
}

//////////////////////////////////////////////////////////////////////////

