#pragma once

#include "afxwin.h"
#include "afxcmn.h"

//////////////////////////////////////////////////////////////////////////

class CSlaveView : public CDialog, CStringConvert
{
	DECLARE_DYNAMIC(CSlaveView)
public:
	CSlaveView(CWnd* pParent = NULL);
	virtual ~CSlaveView();
	enum { IDD = IDD_SLAVE_VIEW };

	void AddConsoleText(const CString &csText, BOOL fReturn = TRUE);
	void SetBenchmarkScore(double dbScore);
	void SetBenchmarkRanking(DWORD dwPosition, DWORD dwAll);
	void SetProgress(DWORD dwIndex, int nPoint);
	void InitProgress(DWORD dwProcessors);
	void EndProgress();
	void SetPluginRuntime(double dbRuntime);
	void ResetBenchmark();
	void RefreshSystemInfo();
	void PluginTimer();
	void CancelPlugin();
	void GetSendMessage(CString &cs) { cs = m_MsgString; }

	void SetPlugin(const CString &cs)
	{ m_xEditPlugin.SetWindowText(cs); }
	void SetProcessors(DWORD dwProcessors)
	{ m_xEditProcessors1.SetWindowText(DwToString(dwProcessors)); }
	void SetBenchmarkTestTime(const CString &cs)
	{ m_xEditTestTime.SetWindowText(cs); }
	void GetConsoleText(CString &cs) 
	{ m_xEditConsole.GetWindowText(cs); }
	void ClearConsoleText() 
	{ m_xEditConsole.SetWindowText(STRING_EMPTY); }
	void SetBenchmarkRuntime(double dbRuntime) 
	{ m_xEditRuntime2.SetWindowText(DbToHMSTime(dbRuntime)); }

protected:
	DECLARE_MESSAGE_MAP()
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual BOOL OnInitDialog();
	virtual BOOL PreTranslateMessage(MSG* pMsg);

	afx_msg void OnBnClickedOk() {}
	afx_msg void OnBnClickedBtnSlaveSend();
	afx_msg void OnCbnSelchangeCmbSlaveUsage();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);

	void SendTextMessage();

	static void WINAPI doRefreshSystemInfo(LPVOID pvContext, BOOLEAN fTimeout);

public:
	CProgressCtrl m_xProgress;
	CComboBox	  m_xCmbUsageMode;
	CStatic		  m_xTxtPercent;
	CEdit		  m_xEditAvailPhys;
	CEdit		  m_xEditTotalPhys;
	CEdit		  m_xEditAvailVirtual;
	CEdit		  m_xEditTotalVirtual;
	CEdit		  m_xEditUsageRate;
	CEdit		  m_xEditProcessors1;
	CEdit		  m_xEditProcessors2;
	CEdit		  m_xEditPlugin;
	CEdit		  m_xEditRuntime1;	// Plugin
	CEdit		  m_xEditScore;
	CEdit		  m_xEditRuntime2;	// Benchmark
	CEdit		  m_xEditTestTime;
	CEdit		  m_xEditRanking1;
	CEdit		  m_xEditRanking2;
	CEdit		  m_xEditConsole;
	CEdit		  m_xEditInput;
	CEdit		  m_xEditStatus;

protected:
	CCriticalSection m_cs;
	CStopwatch		 m_Stopwatch;
	DWORDList		 m_dwPrgList;
	CString			 m_MsgString;
	HANDLE			 m_hSystem;
	DWORD			 m_dwProcessors;
	int				 m_nUsageMode;	
};

//////////////////////////////////////////////////////////////////////////

