#include "stdafx.h"
#include "WinCS.h"
#include "StatusView.h"
#include "WinCSDlg.h"
#include <atlimage.h>

IMPLEMENT_DYNAMIC(CStatusView, CDialog)

BEGIN_MESSAGE_MAP(CStatusView, CDialog)
	ON_BN_CLICKED(IDOK, &CStatusView::OnBnClickedOk)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BTN_STATUS_PLUGIN_RELOAD, &CStatusView::OnBnClickedBtnStatusPluginReload)
	ON_CBN_SELCHANGE(IDC_CMB_STATUS_PLUGIN, &CStatusView::OnCbnSelchangeCmbStatusPlugin)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CStatusView::CStatusView(CWnd* pParent /*=NULL*/)
: CDialog(CStatusView::IDD, pParent)
{
	m_hTimer	= NULL;
	m_hBtnIcon  = NULL;
	m_wNodeType = WCS_NODE_UNDEFINED;
}

CStatusView::~CStatusView()
{
	if (m_hTimer != NULL)
	{
		DeleteTimerQueueTimer(NULL, m_hTimer, NULL);
	}
}

void CStatusView::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_STATUS_LOCAL_ADDRESS, m_xEditLocalAddress);
	DDX_Control(pDX, IDC_EDIT_STATUS_NODE_ID, m_xEditNodeID);
	DDX_Control(pDX, IDC_EDIT_STATUS_UDP_PORT, m_xEditUDPClientPort);
	DDX_Control(pDX, IDC_EDIT_STATUS_TCP_PORT, m_xEditTCPPort);
	DDX_Control(pDX, IDC_STATUS_IMAGE_TYPE, m_xImageType);
	DDX_Control(pDX, IDC_EDIT_STATUS_MASTER_ADDRESS, m_xEditMasterAddress);
	DDX_Control(pDX, IDC_EDIT_STATUS_NODE_STATE, m_xEditNodeState);
	DDX_Control(pDX, IDC_EDIT_STATUS_PLUGIN_DETAIL, m_xEditPluginText);
	DDX_Control(pDX, IDC_BTN_STATUS_PLUGIN_RELOAD, m_xBtnPluginReload);
	DDX_Control(pDX, IDC_CMB_STATUS_PLUGIN, m_xCmbPlugin);
	DDX_Control(pDX, IDC_EDIT_STATUS_PLUGIN_VERSION, m_xEditPluginVersion);
	DDX_Control(pDX, IDC_EDIT_STATUS_PLUGIN_TYPE, m_xEditPluginType);
	DDX_Control(pDX, IDC_EDIT_STATUS_RUNTIME, m_xEditRuntime);
}

BOOL CStatusView::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_hBtnIcon = (HICON)LoadImage(AfxGetInstanceHandle(),
						MAKEINTRESOURCE(IDI_RELOAD),
						IMAGE_ICON, 15, 15,
						LR_DEFAULTSIZE);
	m_xBtnPluginReload.SetIcon(m_hBtnIcon);

	m_Stopwatch.Start();

	if (!CreateTimerQueueTimer(&m_hTimer, NULL, doRuntimeTimer, this, 500, 500, 0))
	{
		m_hTimer = NULL;
	}

	return TRUE;
}

void WINAPI CStatusView::doRuntimeTimer(LPVOID pvContext, BOOLEAN fTimeout)
{
	((CStatusView *)pvContext)->RuntimeTimer();
}

void CStatusView::RuntimeTimer()
{
	CString cs;
	m_Stopwatch.GetHMS(cs);
	m_xEditRuntime.SetWindowText(cs);
}

HBRUSH CStatusView::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	int nCtlID = pWnd->GetDlgCtrlID();

	switch (nCtlID)
	{
	case IDC_EDIT_STATUS_LOCAL_ADDRESS:
	case IDC_EDIT_STATUS_MASTER_ADDRESS:
	case IDC_EDIT_STATUS_NODE_STATE:
	case IDC_EDIT_STATUS_NODE_ID:
	case IDC_EDIT_STATUS_UDP_PORT:
	case IDC_EDIT_STATUS_TCP_PORT:
	case IDC_EDIT_STATUS_PLUGIN_VERSION:
	case IDC_EDIT_STATUS_PLUGIN_TYPE:
	case IDC_EDIT_STATUS_PLUGIN_DETAIL:
	case IDC_EDIT_STATUS_RUNTIME:
		hbr = static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH));
		pDC->SetBkColor(RGB(255, 255, 255));
		break;
	}

	return hbr;
}

void CStatusView::SetNodeType(WORD wNodeType)
{
	DWORD dwResourceID = 0;	

	m_wNodeType = wNodeType;
	m_xImageType.UpdateWindow();

	switch (wNodeType)
	{
	case WCS_NODE_MASTER:
		dwResourceID = IDB_MASTER;
		break;

	case WCS_NODE_SLAVE:
		dwResourceID = IDB_SLAVE;
		break;
	}

	if (dwResourceID != 0)
	{
		try
		{
			CImgExResPtr pBmp = CImgExResPtr(new CImageExResource());

			if (pBmp->Load(MAKEINTRESOURCE(dwResourceID), _T("PNG")))
			{
				CRect cr;
				CClientDC dc(&m_xImageType);
				m_xImageType.GetClientRect(&cr);
				dc.FillSolidRect(&cr, GetSysColor(COLOR_BTNFACE));
				Gdiplus::Graphics graphics(dc);
				graphics.DrawImage(*pBmp, 0, 0);
			}
		}
		catch (std::bad_alloc &)
		{
			TRACE0("***** ERROR: shared_ptr(bad_alloc) *****\n");
			return;
		}
	}
}

void CStatusView::SetNodeID(WORD wNodeID)
{
	CString cs = (wNodeID != WCS_DEFAULT_NODE_ID) ? DwToString(wNodeID) : STRING_NONE;
	m_xEditNodeID.SetWindowText(cs);
}

void CStatusView::ResetNodeID()
{
	m_xEditNodeID.SetWindowText(STRING_NONE);
}

void CStatusView::SetNodeState(WORD wNodeState)
{
	switch (wNodeState)
	{
	case WCS_STATE_WAITING:
		m_xEditNodeState.SetWindowText(_T("Waiting"));
		break;

	case WCS_STATE_EXECUTING:
		m_xEditNodeState.SetWindowText(_T("Executing"));
		break;

	case WCS_STATE_BENCHMARKING:
		m_xEditNodeState.SetWindowText(_T("Benchmarking"));
		break;

	case WCS_STATE_DOWNLOADING:
		m_xEditNodeState.SetWindowText(_T("Downloading"));
		break;
	}
}

void CStatusView::SetLocalAddress(DWORD dwAddress)
{
	m_xEditLocalAddress.SetWindowText(DwToIPAddress(dwAddress));
}

void CStatusView::SetMasterAddress(DWORD dwAddress)
{
	m_xEditMasterAddress.SetWindowText(DwToIPAddress(dwAddress));
}

void CStatusView::ResetMasterAddress()
{
	m_xEditMasterAddress.SetWindowText(STRING_NONE);
}

void CStatusView::SetUDPPort(WORD wPort)
{
	m_xEditUDPClientPort.SetWindowText(DwToString(wPort));
}

void CStatusView::SetTCPPort(WORD wPort)
{
	m_xEditTCPPort.SetWindowText(DwToString(wPort));
}

void CStatusView::SetReloadBtn(BOOL fEnable)
{
	m_xBtnPluginReload.EnableWindow(fEnable);
}

void CStatusView::OnBnClickedBtnStatusPluginReload()
{
	GetParent()->SendMessage(WM_PLUGIN_RELOAD);
}

void CStatusView::SetPluginInfo(const PLUGIN_INFO &info)
{
	CString cs;
	cs.Format(_T("%d.%d"), LOBYTE(info.wVersion), HIBYTE(info.wVersion));
	m_xEditPluginVersion.SetWindowText(cs);
	m_xEditPluginText.SetWindowText(info.szText);
	cs = (info.wType == WCS_PLUGIN_TYPE_GRAPHICS) ? _T("Graphics") : _T("Console");
	m_xEditPluginType.SetWindowText(cs);
}

void CStatusView::SetPluginState(BOOL fLock)
{
	// Master function
	m_xCmbPlugin.EnableWindow(!fLock);
	m_xBtnPluginReload.EnableWindow(!fLock);
}

void CStatusView::PluginInfoClear()
{
	m_xEditPluginVersion.SetWindowText(STRING_EMPTY);
	m_xEditPluginType.SetWindowText(STRING_EMPTY);
	m_xEditPluginText.SetWindowText(STRING_EMPTY);
}

void CStatusView::DeletePluginList()
{
	m_xCmbPlugin.ResetContent();
}

void CStatusView::AddPluginList(const CString &csModule)
{
	m_xCmbPlugin.AddString(csModule);
}

void CStatusView::SelectPluginList(UINT nIndex)
{
	m_xCmbPlugin.SetCurSel(nIndex);
}

void CStatusView::OnCbnSelchangeCmbStatusPlugin()
{
	int nIndex = m_xCmbPlugin.GetCurSel();
	GetParent()->SendMessage(WM_PLUGIN_CHANGE, (WPARAM)nIndex, 0);
}

//////////////////////////////////////////////////////////////////////////

