#pragma once

//////////////////////////////////////////////////////////////////////////

class CTaskManager
{
public:
	CTaskManager();
	virtual ~CTaskManager();

	void InitDataQueue();
	void CallBackPolling();
	BOOL DataEnqueue(const CByteArray &data);
	BOOL DataDequeue(CByteArray &data);
	int  GetQueueSize();

	void SetPluginInitList(const NodeInitList &list) { m_PlgInitList.Copy(list); }
	void GetPluginInitList(NodeInitList &list) { list.Copy(m_PlgInitList); }

protected:
	typedef struct _DataQueue
	{
		CCriticalSection cs;
		CByteArray		 Queue[WCS_QUEUE_SIZE];
		int				 nCount;
		int				 nIndex;
		int				 nPoint;
	}
	DataQueue, *LPDataQueue;

	NodeInitList m_PlgInitList;
	DataQueue	   m_DataQueue;
	HANDLE		   m_hTimer;
};

//////////////////////////////////////////////////////////////////////////
