#include "stdafx.h"
#include "WinCS.h"
#include "WinCSDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

BEGIN_MESSAGE_MAP(CWinCSApp, CWinApp)
	ON_COMMAND(ID_HELP, &CWinApp::OnHelp)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CWinCSApp::CWinCSApp()
{
}

CWinCSApp theApp;

BOOL CWinCSApp::InitInstance()
{
	INITCOMMONCONTROLSEX InitCtrls;
	InitCtrls.dwSize = sizeof(InitCtrls);
	InitCtrls.dwICC = ICC_WIN95_CLASSES;
	InitCommonControlsEx(&InitCtrls);

	// Double start prevention
	if (!SingleStartup())
	{
		return FALSE;
	}

	// Set profile path
	if (!SetProfilePath())
	{
		return FALSE;
	}

	// Initialize winsock(2.2)
	if (!SocketXInitialize())
	{
		return FALSE;
	}

	CWinApp::InitInstance();

	AfxEnableControlContainer();

	CWinCSDlg dlg;
	m_pMainWnd = &dlg;
	dlg.DoModal();

	return FALSE;
}

BOOL CWinCSApp::SetProfilePath()
{
	TCHAR szModulePath[_MAX_PATH];
	TCHAR szDrive[_MAX_DRIVE];
	TCHAR szDir[_MAX_DIR];
	TCHAR szFileName[_MAX_FNAME];
	TCHAR szExt[_MAX_EXT];
	int   nRet;

	nRet = ::GetModuleFileName(AfxGetInstanceHandle(), szModulePath, _MAX_PATH);

	if (nRet == 0)
	{
		return FALSE;
	}

	if (m_pszProfileName != NULL)
	{
		free((void *)m_pszProfileName);
	}

	_tsplitpath_s(szModulePath,
		szDrive, _MAX_DRIVE, 
		szDir, _MAX_DIR,
		szFileName, _MAX_FNAME,
		szExt, _MAX_EXT);

	_tmakepath_s(szModulePath, _MAX_PATH,
		szDrive, szDir, szFileName, _T("ini"));

	m_pszProfileName = _tcsdup(szModulePath);

	if (m_pszProfileName == NULL)
	{
		return FALSE;
	}

	return TRUE;
}

BOOL CWinCSApp::SingleStartup()
{
	CString str;
	str.LoadString(IDS_CONFIG_APPNAME);
	return m_Startup.SingleStartup(str);
}

//////////////////////////////////////////////////////////////////////////
