#pragma once

#include "stdafx.h"
#include "afxext.h"
#include "StatusView.h"
#include "MasterView.h"
#include "SlaveView.h"
#include "WinCSSetupDlg.h"
#include "BMSingleDlg.h"
#include "BMSystemDlg.h"
#include "PluginTransferDlg.h"
#include "APIGraphicsWindow.h"
#include "APIConsoleDlg.h"
#include "TaskManager.h"

//////////////////////////////////////////////////////////////////////////

class CWinCSDlg : public 
	CDialog,
	CStringConvert,
	CWcsAPI,
	ISocketMessage
{
public:
	CWinCSDlg(CWnd* pParent = NULL);
	~CWinCSDlg();
	enum { IDD = IDD_WINCS_DIALOG };

	// Socket message
	virtual void OnSocketSendMessage(DWORD dwSocketID);
	virtual void OnSocketReceiveMessage(DWORD dwSocketID, NETADDR NetAddr, const CByteArray &data);
	virtual void OnSocketReceiveFromMessage(DWORD dwSocketID, NETADDR NetAddr, const CByteArray &data);
	virtual void OnSocketAcceptMessage(DWORD dwSocketID, NETADDR NetAddr);
	virtual void OnSocketConnectMessage(DWORD dwSocketID);
	virtual void OnSocketCloseMessage(DWORD dwSocketID, NETADDR NetAddr);

	// WinCS API
	virtual BOOL API_StartPlugin(WORD wPluginID, const CByteArray &arg);
	virtual BOOL API_StopPlugin(double dbRuntime);
	virtual BOOL API_StopPlugin(const CalcReportList &list);
	virtual BOOL API_Broadcast(const CByteArray &data);
	virtual BOOL API_SendToMaster(const CByteArray &data);
	virtual BOOL API_CreateGraphWindow(const CString &csName, int cx, int cy, BOOL bFront);
	virtual BOOL API_SetPixel(int x, int y, COLORREF color);
	virtual BOOL API_SetXLine(int y, int cx, LPCOLORREF lpColor);
	virtual BOOL API_SetYLine(int x, int cy, LPCOLORREF lpColor);
	virtual BOOL API_SetTaskSchedule(const NodeInitList &list);
	virtual void API_SetProgress(DWORD dwIndex, int nPoint);
	virtual void API_InitProgress(DWORD dwProcessors);
	virtual void API_SetGraphWindowSize(int cx, int cy, int x = 0, int y = 0);
	virtual void API_SetCenterWindow();
	virtual void API_ResetWindow();
	virtual void API_StartTimer();
	virtual void API_StopTimer();

	void AutoExitTimer();
	
protected:
	DECLARE_MESSAGE_MAP()
	virtual BOOL OnInitDialog();
	virtual void DoDataExchange(CDataExchange* pDX);

	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg void OnBnClickedOk() {}
	afx_msg void OnToolRestart();
	afx_msg void OnToolStop();
	afx_msg void OnToolExecute();
	afx_msg void OnToolBenchmark();
	afx_msg void OnToolSetting();
	afx_msg void OnToolTransfer();
	afx_msg void OnToolFreePlugin();
	afx_msg void OnToolRefreshNodeList();
	afx_msg void OnFileLogoutput();
	afx_msg void OnFileExit();
	afx_msg void OnFileConsoleClear();
	afx_msg void OnHelpVersion();
	afx_msg void OnClose();
	afx_msg BOOL OnToolBarEvent(UINT nID);
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg LRESULT OnPluginReload(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnPluginChange(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnPluginTransfer(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnPluginSending(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnPluginLock(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSetForeground(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnShown(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSendText(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnBenchmarkProgress(WPARAM wParam, LPARAM lParam);

	// Event function
	void  OnRestart();
	void  OnExit();
	void  OnSaveLog();
	void  OnBenchmark();
	void  OnSetting();
	void  OnStop();
	void  OnHelp();
	void  OnTransfer();
	void  OnFreePlugin();
	void  OnRefreshNodeList();
	void  OnMasterExecute();
	BOOL  OnSlaveExecute(WORD wPluginID, const CByteArray &arg);

	// Profile
	BOOL  SaveSettings(CString csName, int nValue);
	UINT  LoadSettings(CString csName, int nDefault);

	// Socket message transaction
	void  ClientPeerMsgTransaction(const UDP_DATA &uData, NETADDR NetAddr);
	void  ClientReceiveMsgTransaction(const TCP_DATA &tData, NETADDR NetAddr);
	void  ClientCloseMsgTransaction();
	void  ServerPeerMsgTransaction(const UDP_DATA &uData, NETADDR NetAddr);
	void  ServerReceiveMsgTransaction(const TCP_DATA &tData, NETADDR NetAddr);	
	void  ServerAcceptMsgTransaction(NETADDR NetAddr);
	void  ServerCloseMsgTransaction(NETADDR NetAddr);

	UINT  GetNodeCount();
	void  AddNodeList(NODE_DATA nd);
	BOOL  RemoveNodeList(WORD wNodeID);
	void  RemoveAllNodeList();
	WORD  SearchNodeID(DWORD dwAddress, WORD wPort);
	int   SearchNodeListIndex(WORD wNodeID);

	DWORD GetSAddrBySockAddr(const LPSOCKADDR lpSockAddr);
	WORD  GetPortBySockAddr(const LPSOCKADDR lpSockAddr);

	int   SearchPluginIndex(WORD wPluginID);
	void  SetWcsStatus();
	void  LoadWcsSettings();
	void  SaveWcsSettings();
	void  OutputNodeData();
	void  EnableToolBarBtn(int nCtlID, BOOL fEnable);
	void  MakeSockAddr(LPSOCKADDR lpSockAddr, DWORD dwAddress, WORD wPort, int nAF = AF_INET);
	void  MakeINetAddr(LPDWORD lpAddress, LPWORD lpPort, const LPSOCKADDR lpSockAddr);
	void  FreePlugin(BOOL fRefresh = TRUE);
	BOOL  LoadPlugin();
	BOOL  LoadExcutionPlugin(const CString &csFilePath);
	BOOL  PluginTransfer(UINT nIndex);
	BOOL  CreateWcsDirectory();
	BOOL  ClientPeerSocketInitialize();
	BOOL  ServerPeerSocketInitialize();
	BOOL  StartMaster();
	BOOL  StartSlave();
	BOOL  SearchMaster(LPSOCKADDR lpSockAddr, int *lpSockAddrLen);
	BOOL  ConnectMaster(const LPSOCKADDR lpMasterAddr);
	BOOL  CreateToolBar(LPTBITEM lpTbItem, SIZE size, UINT nBtnNum);
	BOOL  SendAckToMaster(WORD wMsg, DWORD dwOption = 0);
	BOOL  SendAckToSlave(WORD wNodeID, WORD wMsg, DWORD dwOption = 0);
	BOOL  SaveBenchmarkReport(CString &csLogPath);
	DWORD MakeBcastAddress(DWORD dwAddress, DWORD dwNetMask);

	static void WINAPI doAutoExitTimer(LPVOID pvContext, BOOLEAN fTimeout);

protected:
	typedef std::tr1::shared_ptr<CWinCSSetupDlg> CWinCSSetupDlgPtr;
	typedef std::tr1::shared_ptr<CBMSystemDlg>	 CBMSystemDlgPtr;
	typedef std::tr1::shared_ptr<CBMSingleDlg>	 CBMSingleDlgPtr;

	typedef struct _AtmNodeList
	{
		CCriticalSection cs;
		NodeDataList	 list;
	}
	AtmNodeList, *LPAtmNodeList;

	typedef struct _AtmPluginList
	{
		CCriticalSection cs;
		PluginList		 list;
		CStopwatch		 sw;
		BOOL			 fSystem;
		BOOL			 fRunning;
		int			     nSelect;
	}
	AtmPluginList, *LPAtmPluginList;

	typedef struct _SYSTEM_STATUS
	{
		ATM_WORD  wNodeIndex;
		ATM_DWORD dwSlaves;
		ATM_DWORD dwProcessors;
	}
	SYSTEM_STATUS, *LPSYSTEM_STATUS;

	typedef struct _BM_SYSTEMTEST
	{		
		CCriticalSection cs;
		CBMSystemDlgPtr  dlg;
		CStopwatch		 sw;
		ATM_DOUBLE		 dbScore;
		ATM_DWORD		 dwProgPoint;
		ATM_DWORD		 dwTestCompleted;
		IntList			 ResultIndexList;
		CString			 csTestTime;
		double			 dbRuntime;
		DWORD			 dwProgMax;
		DWORD			 dwTestCount;
	}
	BM_SYSTEMTEST, *LPBM_SYSTEMTEST;

	typedef struct _BM_SINGLETEST
	{
		CBMSingleDlgPtr	 dlg;
		BM_DATA			 bm;
	}
	BM_SINGLETEST, *LPBM_SINGLETEST;

	typedef struct _APIWINDOW
	{
		CAPIGraphicsWindow Graphics;
		CAPIConsoleDlg	   Console;
		UINT			   nType;
	}
	APIWINDOW, *LPAPIWINDOW;

protected:
	CPluginTransferDlg m_dlgTransfer;
	APIWINDOW		   m_APIWnd;

	CServerSocketPtr m_pServerSocket;
	CClientSocketPtr m_pClientSocket;
	CBcastSocketPtr	 m_pClientBcastSocket;
	CPeerSocketPtr	 m_pServerPeerSocket;

	AtmNodeList		 m_NodeList;
	AtmPluginList	 m_PluginList;
	BMRankList		 m_bmRankList;

	SYSTEM_STATUS	 m_sysStatus;
	BM_SYSTEMTEST	 m_bmSystem;
	BM_SINGLETEST	 m_bmSingle;
	MASTER_SETTING	 m_MasterSetting;
	SLAVE_SETTING	 m_SlaveSetting;

	CMasterView		 m_wndMasterView;	// MasterView
	CSlaveView		 m_wndSlaveView;	// SlaveView
	CStatusView		 m_wndStatusView;	// StatusView
	CToolBar		 m_wndToolBar;		// ToolBar
	CStatusBar		 m_wndStatusBar;	// StatusBar

	CCriticalSection m_NetLock;
	CTaskManager	 m_TaskManager;		// For system mode
	WCS_STATUS		 m_wcsStatus;
	ULONG_PTR		 m_ulpGdiToken;		// For GDI+ Initialization
	HANDLE			 m_hSlaveExit;
	HICON			 m_hIcon;
	BOOL			 m_fInit;
};

//////////////////////////////////////////////////////////////////////////
