#include "stdafx.h"
#include "WinCS.h"
#include "WinCSSetupDlg.h"
#include "SetupConfigDlg.h"

IMPLEMENT_DYNAMIC(CWinCSSetupDlg, CDialog)

BEGIN_MESSAGE_MAP(CWinCSSetupDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CWinCSSetupDlg::OnBnClickedOk)
	ON_CBN_SELCHANGE(IDC_CMB_SETUP_OPERATION, &CWinCSSetupDlg::OnCbnSelchangeCmbSetupOperation)
	ON_BN_CLICKED(IDC_BTN_SETUP_CONNECTION, &CWinCSSetupDlg::OnBnClickedBtnSetupOption)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CWinCSSetupDlg::CWinCSSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWinCSSetupDlg::IDD, pParent),
	m_nSelectInterface(0),
	m_nSelectOperation(0)
{
	m_hIcon	= AfxGetApp()->LoadIcon(IDI_NETWORK);
}

CWinCSSetupDlg::~CWinCSSetupDlg()
{
}

void CWinCSSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CMB_SETUP_INTERFACE, m_xCmbInterface);
	DDX_Control(pDX, IDC_CMB_SETUP_OPERATION, m_xCmbOperation);
	DDX_Control(pDX, IDC_EDIT_SETUP_CONNECTION, m_xEditConnection);
	DDX_Control(pDX, IDC_BTN_SETUP_CONNECTION, m_xBtnOperation);
	DDX_Control(pDX, IDC_EDIT_SETUP_UDP_CLIENT_PORT, m_xEditUDPClientPort);
	DDX_Control(pDX, IDC_EDIT_SETUP_UDP_SERVER_PORT, m_xEditUDPServerPort);
	DDX_Control(pDX, IDC_EDIT_SETUP_TCP_PORT, m_xEditTCPPort);
	DDX_Control(pDX, IDC_EDIT_SETUP_RETRY, m_xEditRetry);
	DDX_Control(pDX, IDC_EDIT_SETUP_TIMEOUT, m_xEditTimeout);
}

BOOL CWinCSSetupDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CString csAddr, csMask, cs;

	SetIcon(m_hIcon, FALSE);
	SetIcon(m_hIcon, TRUE);
	SetWindowPos(&wndTopMost, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_NOACTIVATE);

	for (UINT i = 0; i < m_dwListSize; i++)
	{
		csAddr = DwToIPAddress(m_IPv4List[i].dwAddress);
		csMask = DwToIPAddress(m_IPv4List[i].dwNetMask);
		m_xCmbInterface.AddString(csAddr + _T(" / ") + csMask);
	}

	m_xCmbOperation.AddString(_T("Slave"));
	m_xCmbOperation.AddString(_T("Master"));
	m_xCmbInterface.SetCurSel(m_nSelectInterface);
	m_xCmbOperation.SetCurSel(m_nSelectOperation);
	OutputSettingsData();
	
	return TRUE;
}

void CWinCSSetupDlg::OutputSettingsData()
{
	CString cs;
	
	cs.Format(_T("%d"), m_wcsStatus.wTCPPort);
	m_xEditTCPPort.SetWindowText(cs);
	cs.Format(_T("%d"), m_wcsStatus.wUDPClientPort);
	m_xEditUDPClientPort.SetWindowText(cs);
	cs.Format(_T("%d"), m_wcsStatus.wUDPServerPort);
	m_xEditUDPServerPort.SetWindowText(cs);
	cs.Format(_T("%d"), m_wcsStatus.dwTimeout);
	m_xEditTimeout.SetWindowText(cs);
	cs.Format(_T("%d"), m_wcsStatus.wRetry);
	m_xEditRetry.SetWindowText(cs);

	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
	{
		// Master
		m_xBtnOperation.EnableWindow(FALSE);
		m_xEditConnection.SetWindowText(STRING_NONE);
	}
	else
	{
		// Slave
		m_xBtnOperation.EnableWindow(TRUE);
		m_xEditConnection.SetWindowText(m_wcsStatus.fDynamic ? _T("Dynamic") : _T("Static"));
	}
}

void CWinCSSetupDlg::OnBnClickedOk()
{
	SYSTEM_INFO si;
	int nSelMode, nSelNet;

	if (!CheckFormat())
	{
		return;
	}

	GetSystemInfo(&si);

	nSelNet	 = m_xCmbInterface.GetCurSel();
	nSelMode = m_xCmbOperation.GetCurSel();
	m_nSelectInterface = nSelNet;
	m_nSelectOperation = nSelMode;
	m_wcsStatus.wNodeType	   = (nSelMode == 0) ? WCS_NODE_SLAVE : WCS_NODE_MASTER;
	m_wcsStatus.wTCPPort   	   = static_cast<WORD>(GetDlgItemInt(IDC_EDIT_SETUP_TCP_PORT));
	m_wcsStatus.wUDPClientPort = static_cast<WORD>(GetDlgItemInt(IDC_EDIT_SETUP_UDP_CLIENT_PORT));
	m_wcsStatus.wUDPServerPort = static_cast<WORD>(GetDlgItemInt(IDC_EDIT_SETUP_UDP_SERVER_PORT));
	m_wcsStatus.wRetry		   = static_cast<WORD>(GetDlgItemInt(IDC_EDIT_SETUP_RETRY));
	m_wcsStatus.dwTimeout	   = static_cast<WORD>(GetDlgItemInt(IDC_EDIT_SETUP_TIMEOUT));
	m_wcsStatus.dwLocalAddress = m_IPv4List[nSelNet].dwAddress;
	m_wcsStatus.dwMaskAddress  = m_IPv4List[nSelNet].dwNetMask;
	m_wcsStatus.dwBcastAddress = m_IPv4List[nSelNet].dwBcastAddress;
	m_wcsStatus.dwProcessors   = si.dwNumberOfProcessors;

	OnOK();
}

BOOL CWinCSSetupDlg::CheckFormat()
{
	CString cs;
	BOOL fError;
	UINT nTCP, uUDPClient, nUDPServer, nTimeout, nRetry;

	// Port check
	nTCP = GetDlgItemInt(IDC_EDIT_SETUP_TCP_PORT, &fError, TRUE);

	cs.LoadString(IDS_WCS_ERROR_INVALID_VALUE);

	if (!fError || (nTCP > 65535))
	{
		m_xEditTCPPort.SetFocus();
		AfxMessageBox(cs);
		return FALSE;
	}

	uUDPClient = GetDlgItemInt(IDC_EDIT_SETUP_UDP_CLIENT_PORT, &fError, TRUE);

	if (!fError || (uUDPClient > 65535))
	{
		m_xEditUDPClientPort.SetFocus();
		AfxMessageBox(cs);
		return FALSE;
	}

	nUDPServer = GetDlgItemInt(IDC_EDIT_SETUP_UDP_SERVER_PORT, &fError, TRUE);

	if (!fError || (nUDPServer > 65535))
	{
		m_xEditUDPServerPort.SetFocus();
		AfxMessageBox(cs);
		return FALSE;
	}

	if ((nTCP == uUDPClient) || (nTCP == nUDPServer) || (uUDPClient == nUDPServer))
	{
		AfxMessageBox(cs);
		return FALSE;
	}


	// Timeout check
	nTimeout = GetDlgItemInt(IDC_EDIT_SETUP_TIMEOUT, &fError, TRUE);

	if (!fError || (nTimeout < 100 || nTimeout > 10000))
	{
		m_xEditTimeout.SetFocus();
		AfxMessageBox(cs);
		return FALSE;
	}

	
	// Retry check
	nRetry = GetDlgItemInt(IDC_EDIT_SETUP_RETRY, &fError, TRUE);

	if (!fError || (nRetry > 10))
	{
		m_xEditRetry.SetFocus();
		AfxMessageBox(cs);
		return FALSE;
	}

	return TRUE;
}

void CWinCSSetupDlg::OnCbnSelchangeCmbSetupOperation()
{
	int nSelect = m_xCmbOperation.GetCurSel();

	if (nSelect == 0)
	{
		// Slave
		m_xBtnOperation.EnableWindow(TRUE);
		m_xEditConnection.SetWindowText(m_wcsStatus.fDynamic ? _T("Dynamic") : _T("Static"));
	}
	else
	{
		// Master
		m_xBtnOperation.EnableWindow(FALSE);
		m_xEditConnection.SetWindowText(STRING_NONE);
	}
}

void CWinCSSetupDlg::OnBnClickedBtnSetupOption()
{
	CSetupConfigDlg dlg;
	INT_PTR nRet;

	dlg.SetWcsStatus(m_wcsStatus);
	nRet = dlg.DoModal();

	if (nRet == IDOK)
	{
		dlg.GetWcsStatus(m_wcsStatus);
		m_xEditConnection.SetWindowText(m_wcsStatus.fDynamic ? _T("Dynamic") : _T("Static"));
	}
}

//////////////////////////////////////////////////////////////////////////