/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.common.util;

import com.jmatio.types.MLArray;
import com.jmatio.types.MLCell;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLNumericArray;
import com.jmatio.types.MLObject;
import com.jmatio.types.MLStructure;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MLArrayQuery {
    private String queryString;
    private static final String regexp = "([a-zA-Z0-9]+)(\\(([0-9]+|:)(,([0-9:]+|:))?\\))?\\.?";
    private static final Pattern pat = Pattern.compile("([a-zA-Z0-9]+)(\\(([0-9]+|:)(,([0-9:]+|:))?\\))?\\.?");

    public MLArrayQuery(String queryString) {
        if (!Pattern.matches("^(([a-zA-Z0-9]+)(\\(([0-9]+|:)(,([0-9:]+|:))?\\))?\\.?)+$", queryString)) {
            throw new IllegalArgumentException();
        }
        this.queryString = queryString;
    }

    public static Object q(MLArray array, String query) {
        MLArrayQuery q = new MLArrayQuery(query);
        return q.query(array);
    }

    public Object query(MLArray array) {
        Matcher mat = pat.matcher(this.queryString);
        MLArray current = null;
        int prevM = 0;
        int prevN = 0;
        while (mat.find()) {
            int n;
            String name = mat.group(1);
            String rangeM = mat.group(3);
            String rangeN = mat.group(5);
            int m3 = rangeM != null ? Integer.parseInt(rangeM) - 1 : -1;
            int n2 = n = rangeN != null ? Integer.parseInt(rangeN) - 1 : -1;
            if (current == null) {
                current = array;
                if (!current.getName().equals(name) && !current.getName().equals("@")) {
                    throw new RuntimeException("No such array or field <" + name + "> in <" + (current != null ? current.getName() : "/") + ">");
                }
                prevM = m3;
                prevN = n;
                continue;
            }
            int type = current.getType();
            switch (type) {
                case 3: {
                    MLObject object = (MLObject)current;
                    MLArray field = object.getObject().getField(name, prevM, prevN);
                    if (field == null) {
                        throw new RuntimeException("no such field: " + name);
                    }
                    current = field;
                    break;
                }
                case 2: {
                    MLStructure struct = (MLStructure)current;
                    MLArray field = struct.getField(name, prevM > 0 ? prevM : 0, prevN > 0 ? prevN : 0);
                    if (field == null) {
                        throw new RuntimeException("no such field: " + name);
                    }
                    current = field;
                    break;
                }
                case 1: {
                    MLCell mlcell = (MLCell)current;
                    if (m3 > -1 && n > -1) {
                        current = mlcell.get(m3, n);
                        break;
                    }
                    if (m3 > -1) {
                        current = mlcell.get(m3);
                        break;
                    }
                    throw new RuntimeException();
                }
            }
            prevM = m3;
            prevN = n;
        }
        return this.getContent(current, prevM, prevN);
    }

    public Object getContent(MLArray array, int m3, int n) {
        int type = array.getType();
        Object result = null;
        switch (type) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                MLNumericArray numeric = (MLNumericArray)array;
                if (m3 > -1 && n > -1) {
                    result = numeric.get(m3, n);
                    break;
                }
                if (m3 > -1) {
                    result = numeric.get(m3);
                    break;
                }
                result = array;
                break;
            }
            case 4: {
                MLChar mlchar = (MLChar)array;
                if (m3 > -1 && n > -1) {
                    result = mlchar.getChar(m3, n);
                    break;
                }
                if (m3 > -1) {
                    result = mlchar.getString(m3);
                    break;
                }
                result = mlchar;
                break;
            }
            case 1: {
                MLCell mlcell = (MLCell)array;
                if (m3 > -1 && n > -1) {
                    result = this.getContent(mlcell.get(m3, n), 0, -1);
                    break;
                }
                if (m3 > -1) {
                    result = this.getContent(mlcell.get(m3), 0, -1);
                    break;
                }
                result = this.getContent(mlcell.get(0), -1, -1);
                break;
            }
            default: {
                result = array;
            }
        }
        return result;
    }
}

