/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dwg;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DWGReadFormatRemover {
    private static final String underlineStrikeThrough = "((?:\\\\\\\\)+|\\\\[LlOoKk])";
    private static final String endMarks = "((?:\\\\\\\\)+|\\\\(?:A|H|pi|pxt|pxi|pt|X|Q|f|F|W|C|T)[^;]{0,100};)";
    private static final String newLine = "((?:\\\\\\\\)+|\\\\P)";
    private static final String stackFrac = "(\\\\\\\\)+|\\\\S([^/^#]{1,20})[/^#]([^;]{1,20});";
    private static final String curlyBraces = "(\\\\)+[{}]|([{}])";
    private static final String escapeChars = "(?<!\\\\)(\\\\)(?!\\\\)";

    public String cleanupDwgString(String dwgString) {
        String cleanString = dwgString;
        StringBuffer sb = new StringBuffer();
        Matcher m3 = Pattern.compile(underlineStrikeThrough).matcher(cleanString);
        while (m3.find()) {
            if (m3.group(1).endsWith("\\")) continue;
            m3.appendReplacement(sb, "");
        }
        m3.appendTail(sb);
        cleanString = sb.toString();
        m3 = Pattern.compile(endMarks).matcher(cleanString);
        sb.setLength(0);
        while (m3.find()) {
            if (m3.group(1).endsWith("\\")) continue;
            m3.appendReplacement(sb, "");
        }
        m3.appendTail(sb);
        cleanString = sb.toString();
        m3 = Pattern.compile(newLine).matcher(cleanString);
        sb.setLength(0);
        while (m3.find()) {
            if (!m3.group(1).endsWith("P")) continue;
            m3.appendReplacement(sb, "\n");
        }
        m3.appendTail(sb);
        cleanString = sb.toString();
        m3 = Pattern.compile(stackFrac).matcher(cleanString);
        sb.setLength(0);
        while (m3.find()) {
            if (m3.group(1) != null) continue;
            m3.appendReplacement(sb, m3.group(2) + "/" + m3.group(3));
        }
        m3.appendTail(sb);
        cleanString = sb.toString();
        m3 = Pattern.compile(curlyBraces).matcher(cleanString);
        sb.setLength(0);
        while (m3.find()) {
            if (m3.group(1) != null) continue;
            m3.appendReplacement(sb, "");
        }
        m3.appendTail(sb);
        cleanString = sb.toString();
        cleanString = cleanString.replaceAll(escapeChars, "");
        cleanString = cleanString.replaceAll("(\\\\\\\\)", "\\\\");
        return cleanString;
    }
}

