/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.epub;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.FilenameUtils;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.epub.EpubContentParser;
import org.apache.tika.parser.xml.DcXMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.ParserUtils;
import org.apache.tika.utils.XMLReaderUtils;
import org.apache.tika.zip.utils.ZipSalvager;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EpubParser
extends AbstractParser {
    private static final long serialVersionUID = 215176772484050550L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("epub+zip"), MediaType.application("x-ibooks+zip"))));
    @Field
    boolean streaming = false;
    private Parser meta = new DcXMLParser();
    private Parser content = new EpubContentParser();

    public Parser getMetaParser() {
        return this.meta;
    }

    public void setMetaParser(Parser meta) {
        this.meta = meta;
    }

    public Parser getContentParser() {
        return this.content;
    }

    public void setContentParser(Parser content) {
        this.content = content;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        IOException caughtException = null;
        EmbeddedContentHandler childHandler = new EmbeddedContentHandler(new BodyContentHandler(xhtml));
        if (this.streaming) {
            try {
                this.streamingParse(stream, childHandler, metadata, context);
            }
            catch (IOException e) {
                caughtException = e;
            }
        } else {
            try {
                this.bufferedParse(stream, childHandler, xhtml, metadata, context);
            }
            catch (IOException e) {
                caughtException = e;
            }
        }
        xhtml.endDocument();
        if (caughtException != null) {
            throw caughtException;
        }
    }

    private void streamingParse(InputStream stream, ContentHandler bodyHandler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        ZipArchiveInputStream zip = new ZipArchiveInputStream(stream);
        ZipArchiveEntry entry = zip.getNextZipEntry();
        while (entry != null) {
            if (entry.getName().equals("mimetype")) {
                this.updateMimeType(zip, metadata);
            } else if (entry.getName().equals("metadata.xml")) {
                this.meta.parse(zip, new DefaultHandler(), metadata, context);
            } else if (entry.getName().endsWith(".opf")) {
                this.meta.parse(zip, new DefaultHandler(), metadata, context);
            } else if (entry.getName().endsWith(".htm") || entry.getName().endsWith(".html") || entry.getName().endsWith(".xhtml") || entry.getName().endsWith(".xml")) {
                this.content.parse(zip, bodyHandler, metadata, context);
            }
            entry = zip.getNextZipEntry();
        }
    }

    private void updateMimeType(InputStream is, Metadata metadata) throws IOException {
        String type = IOUtils.toString(is, StandardCharsets.UTF_8);
        if (type != null) {
            type = type.trim();
        }
        metadata.set("Content-Type", type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bufferedParse(InputStream stream, ContentHandler bodyHandler, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        TikaInputStream tis;
        TemporaryResources temporaryResources = null;
        if (TikaInputStream.isTikaInputStream(stream)) {
            tis = TikaInputStream.cast(stream);
            if (tis.getOpenContainer() instanceof ZipFile) {
                this.bufferedParseZipFile((ZipFile)tis.getOpenContainer(), bodyHandler, xhtml, metadata, context, true);
                return;
            }
        } else {
            temporaryResources = new TemporaryResources();
            tis = TikaInputStream.get(new CloseShieldInputStream(stream), temporaryResources, metadata);
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(tis.getPath().toFile());
        }
        catch (IOException e) {
            ParserUtils.recordParserFailure(this, e, metadata);
            this.trySalvage(tis.getPath(), bodyHandler, xhtml, metadata, context);
            return;
        }
        finally {
            if (temporaryResources != null) {
                tis.close();
            }
        }
        try {
            this.bufferedParseZipFile(zipFile, bodyHandler, xhtml, metadata, context, true);
        }
        finally {
            zipFile.close();
        }
    }

    private void trySalvage(Path brokenZip, ContentHandler bodyHandler, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        block37: {
            try (TemporaryResources resources = new TemporaryResources();){
                Path salvaged = resources.createTempFile(FilenameUtils.getSuffixFromPath(brokenZip.getFileName().toString()));
                ZipSalvager.salvageCopy(brokenZip.toFile(), salvaged.toFile());
                boolean success = false;
                try (ZipFile zipFile = new ZipFile(salvaged.toFile());){
                    success = this.bufferedParseZipFile(zipFile, bodyHandler, xhtml, metadata, context, false);
                }
                if (success) break block37;
                var11_13 = null;
                try (TikaInputStream is = TikaInputStream.get(salvaged);){
                    this.streamingParse(is, xhtml, metadata, context);
                }
                catch (Throwable throwable) {
                    var11_13 = throwable;
                    throw throwable;
                }
            }
        }
    }

    private boolean bufferedParseZipFile(ZipFile zipFile, ContentHandler bodyHandler, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context, boolean isStrict) throws IOException, TikaException, SAXException {
        HRefMediaPair hRefMediaPair;
        String rootOPF = this.getRoot(zipFile, context);
        if (rootOPF == null) {
            return false;
        }
        ZipArchiveEntry zae = zipFile.getEntry(rootOPF);
        if (zae == null || !zipFile.canReadEntryData(zae)) {
            return false;
        }
        this.meta.parse(zipFile.getInputStream(zae), new DefaultHandler(), metadata, context);
        ContentOrderScraper contentOrderScraper = new ContentOrderScraper();
        try (InputStream is = zipFile.getInputStream(zae);){
            XMLReaderUtils.parseSAX(is, (ContentHandler)contentOrderScraper, context);
        }
        if (contentOrderScraper.contentItems.size() == 0) {
            return false;
        }
        String relativePath = "";
        if (rootOPF.lastIndexOf("/") > -1) {
            relativePath = rootOPF.substring(0, rootOPF.lastIndexOf("/") + 1);
        }
        if (isStrict) {
            int found = 0;
            for (String id : contentOrderScraper.contentItems) {
                hRefMediaPair = contentOrderScraper.locationMap.get(id);
                if (hRefMediaPair == null || hRefMediaPair.href == null || (zae = zipFile.getEntry(relativePath + hRefMediaPair.href)) == null || !zipFile.canReadEntryData(zae)) continue;
                ++found;
            }
            if (found != contentOrderScraper.contentItems.size()) {
                return false;
            }
        }
        this.extractMetadata(zipFile, metadata, context);
        HashSet<String> processed = new HashSet<String>();
        for (String id : contentOrderScraper.contentItems) {
            hRefMediaPair = contentOrderScraper.locationMap.get(id);
            if (hRefMediaPair == null || hRefMediaPair.href == null) continue;
            boolean shouldParse = false;
            String href = hRefMediaPair.href.toLowerCase(Locale.US);
            if (hRefMediaPair.media != null) {
                String mediaType = hRefMediaPair.media.toLowerCase(Locale.US);
                if (mediaType.contains("html")) {
                    shouldParse = true;
                }
            } else if (href.endsWith("htm") || href.endsWith("html") || href.endsWith(".xml")) {
                shouldParse = true;
            }
            if (!shouldParse || (zae = zipFile.getEntry(relativePath + hRefMediaPair.href)) == null) continue;
            InputStream is = zipFile.getInputStream(zae);
            Throwable throwable = null;
            try {
                this.content.parse(is, bodyHandler, metadata, context);
                processed.add(id);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        EmbeddedDocumentExtractor embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
        for (String id : contentOrderScraper.locationMap.keySet()) {
            HRefMediaPair hRefMediaPair2;
            if (processed.contains(id) || !this.shouldHandleEmbedded((hRefMediaPair2 = contentOrderScraper.locationMap.get(id)).media)) continue;
            this.handleEmbedded(zipFile, relativePath, hRefMediaPair2, embeddedDocumentExtractor, xhtml, metadata);
        }
        return true;
    }

    private boolean shouldHandleEmbedded(String media) {
        if (media == null) {
            return true;
        }
        String lc = media.toLowerCase(Locale.US);
        if (lc.contains("css")) {
            return false;
        }
        if (lc.contains("svg")) {
            return false;
        }
        if (lc.endsWith("/xml")) {
            return false;
        }
        if (lc.contains("x-ibooks")) {
            return false;
        }
        return !lc.equals("application/x-dtbncx+xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEmbedded(ZipFile zipFile, String relativePath, HRefMediaPair hRefMediaPair, EmbeddedDocumentExtractor embeddedDocumentExtractor, XHTMLContentHandler xhtml, Metadata parentMetadata) throws IOException, SAXException {
        if (hRefMediaPair.href == null) {
            return;
        }
        String fullPath = relativePath + hRefMediaPair.href;
        ZipArchiveEntry ze = zipFile.getEntry(fullPath);
        if (ze == null || !zipFile.canReadEntryData(ze)) {
            return;
        }
        Metadata embeddedMetadata = new Metadata();
        if (!StringUtils.isBlank(hRefMediaPair.media)) {
            embeddedMetadata.set("Content-Type", hRefMediaPair.media);
        }
        if (!embeddedDocumentExtractor.shouldParseEmbedded(embeddedMetadata)) {
            return;
        }
        TikaInputStream stream = null;
        try {
            stream = TikaInputStream.get(zipFile.getInputStream(ze));
        }
        catch (IOException e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException(e, parentMetadata);
            return;
        }
        xhtml.startElement("div", "class", "embedded");
        try {
            embeddedDocumentExtractor.parseEmbedded(stream, new EmbeddedContentHandler(xhtml), embeddedMetadata, true);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
        xhtml.endElement("div");
    }

    private void extractMetadata(ZipFile zipFile, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        Throwable throwable;
        InputStream is;
        ZipArchiveEntry zae = zipFile.getEntry("mimetype");
        if (zae != null && zipFile.canReadEntryData(zae)) {
            is = zipFile.getInputStream(zae);
            throwable = null;
            try {
                this.updateMimeType(is, metadata);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        if ((zae = zipFile.getEntry("metadata.xml")) != null && zipFile.canReadEntryData(zae)) {
            is = zipFile.getInputStream(zae);
            throwable = null;
            try {
                this.meta.parse(is, new DefaultHandler(), metadata, context);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
    }

    private String getRoot(ZipFile zipFile, ParseContext context) throws IOException, TikaException, SAXException {
        ZipArchiveEntry container = zipFile.getEntry("META-INF/container.xml");
        if (container != null) {
            RootFinder rootFinder = new RootFinder();
            try (InputStream is = zipFile.getInputStream(container);){
                XMLReaderUtils.parseSAX(is, (ContentHandler)rootFinder, context);
            }
            return rootFinder.root;
        }
        Enumeration<ZipArchiveEntry> entryEnum = zipFile.getEntries();
        while (entryEnum.hasMoreElements()) {
            ZipArchiveEntry ze = entryEnum.nextElement();
            if (!ze.getName().toLowerCase(Locale.US).endsWith(".opf") || !zipFile.canReadEntryData(ze)) continue;
            return ze.getName();
        }
        return null;
    }

    private static class HRefMediaPair {
        private final String href;
        private final String media;

        HRefMediaPair(String href, String media) {
            this.href = href;
            this.media = media;
        }

        public String toString() {
            return "HRefMediaPair{href='" + this.href + '\'' + ", media='" + this.media + '\'' + '}';
        }
    }

    private static class ContentOrderScraper
    extends DefaultHandler {
        Map<String, HRefMediaPair> locationMap = new HashMap<String, HRefMediaPair>();
        List<String> contentItems = new ArrayList<String>();
        boolean inManifest = false;
        boolean inSpine = false;

        private ContentOrderScraper() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            String id;
            if ("manifest".equalsIgnoreCase(localName)) {
                this.inManifest = true;
            } else if ("spine".equalsIgnoreCase(localName)) {
                this.inSpine = true;
            }
            if (this.inManifest && "item".equalsIgnoreCase(localName)) {
                id = XMLReaderUtils.getAttrValue("id", atts);
                String href = XMLReaderUtils.getAttrValue("href", atts);
                String mime = XMLReaderUtils.getAttrValue("media-type", atts);
                if (id != null && href != null) {
                    try {
                        href = URLDecoder.decode(href, StandardCharsets.UTF_8.name());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.locationMap.put(id, new HRefMediaPair(href, mime));
                }
            }
            if (this.inSpine && "itemRef".equalsIgnoreCase(localName) && (id = XMLReaderUtils.getAttrValue("idref", atts)) != null) {
                this.contentItems.add(id);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if ("manifest".equalsIgnoreCase(localName)) {
                this.inManifest = false;
            } else if ("spine".equalsIgnoreCase(localName)) {
                this.inSpine = false;
            }
        }
    }

    private static class RootFinder
    extends DefaultHandler {
        String root = null;

        private RootFinder() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            if ("rootfile".equalsIgnoreCase(localName)) {
                this.root = XMLReaderUtils.getAttrValue("full-path", atts);
            }
        }
    }
}

