/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mif;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.detect.AutoDetectReader;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractEncodingDetectorParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.mif.MIFContentHandler;
import org.apache.tika.parser.mif.MIFExtractor;
import org.apache.tika.sax.EndDocumentShieldingContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MIFParser
extends AbstractEncodingDetectorParser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("vnd.mif"), MediaType.application("x-maker"), MediaType.application("x-mif"))));

    public MIFParser() {
    }

    public MIFParser(EncodingDetector encodingDetector) {
        super(encodingDetector);
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        try (AutoDetectReader reader = new AutoDetectReader((InputStream)new CloseShieldInputStream(stream), metadata, this.getEncodingDetector(context));){
            Charset charset = reader.getCharset();
            metadata.set("Content-Encoding", charset.name());
            Optional firstElement = SUPPORTED_TYPES.stream().findFirst();
            metadata.set("Content-Type", ((MediaType)firstElement.get()).toString());
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            EndDocumentShieldingContentHandler parseHandler = new EndDocumentShieldingContentHandler(xhtml);
            MIFExtractor.parse(reader, this.getContentHandler(parseHandler, metadata));
            xhtml.endDocument();
            if (parseHandler.isEndDocumentWasCalled()) {
                parseHandler.reallyEndDocument();
            }
        }
    }

    public ContentHandler getContentHandler(ContentHandler handler, Metadata metadata) {
        return new MIFContentHandler(handler, metadata);
    }
}

