/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.UnsupportedFormatException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pkg.PackageParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RarParser
extends AbstractParser {
    private static final long serialVersionUID = 6157727985054451501L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application("x-rar-compressed"));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext arg0) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        EmbeddedDocumentExtractor extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
        String mediaType = metadata.get("Content-Type");
        if (mediaType != null && mediaType.contains("version=5")) {
            throw new UnsupportedFormatException("Tika does not yet support rar version 5.");
        }
        try (Archive rar = null;
             TemporaryResources tmp = new TemporaryResources();){
            TikaInputStream tis = TikaInputStream.get(stream, tmp, metadata);
            rar = new Archive(tis.getFile());
            if (rar.isEncrypted()) {
                throw new EncryptedDocumentException();
            }
            xhtml.element("div", " ");
            FileHeader header = rar.nextFileHeader();
            while (header != null && !Thread.currentThread().isInterrupted()) {
                if (!header.isDirectory()) {
                    Metadata entrydata = PackageParser.handleEntryMetadata(header.getFileName(), header.getCTime(), header.getMTime(), header.getFullUnpackSize(), xhtml);
                    try (InputStream subFile = rar.getInputStream(header);){
                        if (extractor.shouldParseEmbedded(entrydata)) {
                            extractor.parseEmbedded(subFile, handler, entrydata, true);
                        }
                    }
                }
                header = rar.nextFileHeader();
            }
        }
        xhtml.endDocument();
    }
}

