/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.WarcCompression;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.WarcWriter;
import org.netpreserve.jwarc.Warcinfo;
import org.netpreserve.jwarc.tools.Utils;

public class SavebackTool {
    private final List<String> passthroughHeaders = Arrays.asList("Content-Type", "Content-Disposition", "Content-Range");
    private boolean warcinfo = false;
    private boolean warcitHeaders = true;
    private static final Pattern originalLinkPattern = Pattern.compile("<([^>]+)>;\\s*rel=\"original\".*");

    public static void main(String[] args) throws IOException {
        WarcCompression compression = WarcCompression.NONE;
        SavebackTool saveback = new SavebackTool();
        ArrayList<String> waybackUrls = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) {
                switch (arg) {
                    case "--gzip": {
                        compression = WarcCompression.GZIP;
                        break;
                    }
                    case "--no-warcit-headers": {
                        saveback.warcitHeaders = false;
                        break;
                    }
                    case "--warcinfo": {
                        saveback.warcinfo = true;
                        break;
                    }
                    default: {
                        SavebackTool.usage();
                        return;
                    }
                }
                continue;
            }
            waybackUrls.add(arg);
        }
        if (waybackUrls.isEmpty()) {
            SavebackTool.usage();
            return;
        }
        saveback.run(waybackUrls, new WarcWriter(Channels.newChannel(System.out), compression));
    }

    private static void usage() {
        System.err.println("Usage: jwarc saveback wayback-url ...");
        System.err.println("Reconstructs WARC records from wayback or pywb replayed pages");
        System.err.println("Intended to be used with the id_ option: .../wayback/20060101010000id_/http://example.org/");
        System.err.println();
        System.err.println("Options:");
        System.err.println("  --gzip               Emit GZIP-compressed records");
        System.err.println("  --no-warcit-headers  Don't emit the non-standard WARC-Source-URI and WARC-Creation-Date headers");
        System.err.println("  --warcinfo           Emit a warcinfo record");
        System.exit(1);
    }

    private void run(List<String> waybackUrls, WarcWriter warcWriter) throws IOException {
        if (this.warcinfo) {
            String version = Utils.getJwarcVersion();
            HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
            metadata.put("software", Collections.singletonList((version == null ? "jwarc" : "jwarc/" + version) + " saveback"));
            warcWriter.write(new Warcinfo.Builder().fields(metadata).build());
        }
        for (String waybackUrl : waybackUrls) {
            this.process(waybackUrl, warcWriter);
        }
    }

    private void process(String waybackUrl, WarcWriter warcWriter) throws IOException {
        Path temp = Files.createTempFile("jwarc-saveback", ".tmp", new FileAttribute[0]);
        Instant now = Instant.now();
        HttpURLConnection connection = (HttpURLConnection)new URL(waybackUrl).openConnection();
        try (InputStream bodyStream = connection.getInputStream();
             SeekableByteChannel channel = Files.newByteChannel(temp, StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.TRUNCATE_EXISTING);){
            String value;
            IOUtils.copy(bodyStream, Channels.newOutputStream(channel));
            channel.position(0L);
            long bodyLength = channel.size();
            String originalUrl = SavebackTool.getOriginalUrl(connection.getHeaderField("Link"));
            Instant timestamp = DateTimeFormatter.RFC_1123_DATE_TIME.parse((CharSequence)connection.getHeaderField("memento-datetime"), Instant::from);
            ArrayList<String> sourceUris = new ArrayList<String>();
            sourceUris.add(waybackUrl);
            String xArchiveSrc = connection.getHeaderField("x-archive-src");
            if (waybackUrl.startsWith("https://web.archive.org/") && !xArchiveSrc.startsWith("https://") && !xArchiveSrc.startsWith("http://")) {
                xArchiveSrc = "https://archive.org/download/" + xArchiveSrc;
            }
            HttpResponse.Builder httpBuilder = new HttpResponse.Builder(connection.getResponseCode(), connection.getResponseMessage());
            int i = 1;
            while (connection.getHeaderFieldKey(i) != null) {
                String name;
                String lowercaseName;
                String string = connection.getHeaderFieldKey(i);
                value = connection.getHeaderField(i);
                if (string.toLowerCase(Locale.ROOT).startsWith("x-archive-orig-") && !(lowercaseName = (name = string.substring("x-archive-orig-".length())).toLowerCase(Locale.ROOT)).equals("content-encoding") && !lowercaseName.equals("content-length")) {
                    httpBuilder.addHeader(name, value);
                }
                ++i;
            }
            for (String string : this.passthroughHeaders) {
                value = connection.getHeaderField(string);
                if (value == null || connection.getHeaderField("x-archive-orig-" + string) != null) continue;
                httpBuilder.setHeader(string, value);
            }
            httpBuilder.body(null, channel, bodyLength);
            WarcResponse.Builder warcBuilder = new WarcResponse.Builder(URI.create(originalUrl));
            if (this.warcitHeaders) {
                warcBuilder.addHeader("WARC-Creation-Date", now.truncatedTo(ChronoUnit.SECONDS).toString());
                for (String sourceUri : sourceUris) {
                    warcBuilder.addHeader("WARC-Source-URI", sourceUri);
                }
                if (xArchiveSrc != null) {
                    warcBuilder.addHeader("WARC-Source-URI", xArchiveSrc);
                }
            }
            WarcResponse warcResponse = ((WarcResponse.Builder)warcBuilder.date(timestamp)).body(httpBuilder.build()).build();
            warcWriter.write(warcResponse);
        }
    }

    private static String getOriginalUrl(String linkHeader) {
        Matcher m3 = originalLinkPattern.matcher(linkHeader);
        if (m3.matches()) {
            return m3.group(1);
        }
        throw new RuntimeException("Unable to parse original url from Link header");
    }
}

