/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.utils.Direction;

public class FloatingNote
extends AbstractTextBlock
implements Stencil,
TextBlock {
    private final Opale opale;

    private FloatingNote(Display note, ISkinParam skinParam, SName sname, boolean withLink) {
        Style style = StyleSignatureBasic.of(SName.root, SName.element, sname, SName.note).getMergedStyle(skinParam.getCurrentStyleBuilder());
        LineBreakStrategy wrapWidth = style.wrapWidth();
        FontConfiguration fc = FontConfiguration.create(skinParam, style);
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
        HColor borderColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        UStroke stroke = style.getStroke();
        double shadowing = style.value(PName.Shadowing).asDouble();
        Sheet sheet = skinParam.sheet(fc, skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), CreoleMode.FULL).createSheet(note);
        SheetBlock2 sheetBlock2 = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), this, stroke);
        this.opale = new Opale(shadowing, borderColor, noteBackgroundColor, sheetBlock2, withLink, stroke);
    }

    public static FloatingNote create(Display note, ISkinParam skinParam, SName sname) {
        return new FloatingNote(note, skinParam, sname, false);
    }

    public static FloatingNote createOpale(Display note, ISkinParam skinParam, SName sname) {
        return new FloatingNote(note, skinParam, sname, true);
    }

    public void setOpale(Direction strategy, XPoint2D pp1, XPoint2D pp2) {
        this.opale.setOpale(strategy, pp1, pp2);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.opale.drawU(ug);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.opale.calculateDimension(stringBounder);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return -this.opale.getMarginX1();
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.opale.calculateDimension(stringBounder).getWidth() - (double)this.opale.getMarginX1();
    }
}

