/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.anim;

import java.awt.geom.AffineTransform;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.ugraphic.MinMax;

public class AffineTransformation {
    private static final Pattern rotate = Pattern.compile("rotate\\s+(-?\\d+\\.?\\d*)");
    private static final Pattern shear = Pattern.compile("shear\\s+(-?\\d+\\.?\\d*)\\s+(-?\\d+\\.?\\d*)");
    private static final Pattern translate = Pattern.compile("translate\\s+(-?\\d+\\.?\\d*)\\s+(-?\\d+\\.?\\d*)");
    private static final Pattern scale = Pattern.compile("scale\\s+(-?\\d+\\.?\\d*)\\s+(-?\\d+\\.?\\d*)");
    private static final Pattern color = Pattern.compile("color\\s+.*");
    private final AffineTransform affineTransform;
    private XDimension2D dimension;

    private AffineTransformation(AffineTransform affineTransform) {
        this.affineTransform = Objects.requireNonNull(affineTransform);
    }

    private AffineTransformation compose(AffineTransformation other) {
        AffineTransform tmp = new AffineTransform(this.affineTransform);
        tmp.concatenate(other.affineTransform);
        return new AffineTransformation(tmp);
    }

    public static AffineTransformation from(AffineTransform affineTransform) {
        return new AffineTransformation(affineTransform);
    }

    static AffineTransformation create(String value) {
        StringTokenizer st = new StringTokenizer(value, "|");
        AffineTransformation result = null;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            AffineTransformation tmp = AffineTransformation.createSimple(s);
            if (tmp == null) continue;
            if (result == null) {
                result = tmp;
                continue;
            }
            result = result.compose(tmp);
        }
        return result;
    }

    private static AffineTransformation createSimple(String value) {
        Matcher m = rotate.matcher(StringUtils.trin(value));
        if (m.find()) {
            double angle = Double.parseDouble(m.group(1));
            return new AffineTransformation(AffineTransform.getRotateInstance(angle * Math.PI / 180.0));
        }
        m = shear.matcher(value);
        if (m.find()) {
            double shx = Double.parseDouble(m.group(1));
            double shy = Double.parseDouble(m.group(2));
            return new AffineTransformation(AffineTransform.getShearInstance(shx, shy));
        }
        m = translate.matcher(value);
        if (m.find()) {
            double tx = Double.parseDouble(m.group(1));
            double ty = Double.parseDouble(m.group(2));
            return new AffineTransformation(AffineTransform.getTranslateInstance(tx, ty));
        }
        m = scale.matcher(value);
        if (m.find()) {
            double scalex = Double.parseDouble(m.group(1));
            double scaley = Double.parseDouble(m.group(2));
            return new AffineTransformation(AffineTransform.getScaleInstance(scalex, scaley));
        }
        m = color.matcher(value);
        if (m.find()) {
            return new AffineTransformation(new AffineTransform());
        }
        return null;
    }

    public final AffineTransform getAffineTransform() {
        return this.getAffineTransform(this.dimension);
    }

    private AffineTransform getAffineTransform(XDimension2D dimension) {
        if (dimension == null) {
            throw new IllegalStateException();
        }
        AffineTransform at = AffineTransform.getTranslateInstance(dimension.getWidth() / 2.0, dimension.getHeight() / 2.0);
        at.concatenate(this.affineTransform);
        at.translate(-dimension.getWidth() / 2.0, -dimension.getHeight() / 2.0);
        return at;
    }

    public void setDimension(XDimension2D dim) {
        this.dimension = dim;
    }

    public MinMax getMinMax(XDimension2D rect) {
        MinMax result = MinMax.getEmpty(false);
        AffineTransform tmp = this.getAffineTransform(rect);
        result = result.addPoint(new XPoint2D(0.0, 0.0).transform(tmp));
        result = result.addPoint(new XPoint2D(0.0, rect.getHeight()).transform(tmp));
        result = result.addPoint(new XPoint2D(rect.getWidth(), 0.0).transform(tmp));
        result = result.addPoint(new XPoint2D(rect.getWidth(), rect.getHeight()).transform(tmp));
        return result;
    }
}

