/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArg;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.utils.LineLocation;

public final class CommandLinkLollipop
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    public CommandLinkLollipop(UmlDiagramType umlDiagramType) {
        super(CommandLinkLollipop.getRegexConcat(umlDiagramType));
    }

    static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return RegexConcat.build(CommandLinkLollipop.class.getName() + (Object)((Object)umlDiagramType), RegexLeaf.start(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("HEADER", "@([\\d.]+)"), RegexLeaf.spaceOneOrMore())), new RegexLeaf("ENT1", "(?:" + CommandLinkLollipop.optionalKeywords(umlDiagramType) + "[%s]+)?(\\.?[%pLN_]+(?:\\.[%pLN_]+)*|[%g][^%g]+[%g])[%s]*(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("FIRST_LABEL", "[%g]([^%g]+)[%g]")), RegexLeaf.spaceZeroOrMore(), new RegexOr(new RegexLeaf("LOL_THEN_ENT", "([()]\\))([-=.]+)"), new RegexLeaf("ENT_THEN_LOL", "([-=.]+)(\\([()])")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("SECOND_LABEL", "[%g]([^%g]+)[%g]")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("ENT2", "(?:" + CommandLinkLollipop.optionalKeywords(umlDiagramType) + "[%s]+)?(\\.?[%pLN_]+(?:\\.[%pLN_]+)*|[%g][^%g]+[%g])[%s]*(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("LABEL_LINK", "(.+)"))), RegexLeaf.end());
    }

    private static String optionalKeywords(UmlDiagramType type) {
        if (type == UmlDiagramType.CLASS) {
            return "(interface|enum|annotation|abstract[%s]+class|abstract|class|entity|protocol|struct|exception|metaclass|stereotype)";
        }
        if (type == UmlDiagramType.OBJECT) {
            return "(object)";
        }
        throw new IllegalArgumentException();
    }

    private LeafType getType(String desc) {
        if (desc.charAt(0) == desc.charAt(1)) {
            return LeafType.LOLLIPOP_HALF;
        }
        return LeafType.LOLLIPOP_FULL;
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractClassOrObjectDiagram diagram, LineLocation location, RegexResult arg) {
        IEntity normalEntity;
        IEntity cl2;
        Ident idNewLong;
        IEntity cl1;
        String ent1 = arg.get("ENT1", 1);
        String ent2 = arg.get("ENT2", 1);
        String suffix = "lol" + diagram.getUniqueSequence();
        if (arg.get("LOL_THEN_ENT", 1) == null) {
            assert (arg.get("ENT_THEN_LOL", 0) != null);
            Ident ident1 = diagram.buildLeafIdent(ent1);
            Ident ent1code = diagram.V1972() ? ident1 : diagram.buildCode(ent1);
            cl1 = this.getFoo1(diagram, ent1code, ident1);
            idNewLong = diagram.buildLeafIdent(ent1 + suffix);
            cl2 = diagram.createLeaf(idNewLong, idNewLong.toCode(diagram), Display.getWithNewlines(ent2), this.getType(arg.get("ENT_THEN_LOL", 1)), null);
            normalEntity = cl1;
        } else {
            Ident ident2 = diagram.buildLeafIdent(ent2);
            Ident ent2code = diagram.V1972() ? ident2 : diagram.buildCode(ent2);
            cl2 = this.getFoo1(diagram, ent2code, ident2);
            idNewLong = diagram.buildLeafIdent(ent2 + suffix);
            cl1 = diagram.createLeaf(idNewLong, idNewLong.toCode(diagram), Display.getWithNewlines(ent1), this.getType(arg.get("LOL_THEN_ENT", 0)), null);
            normalEntity = cl2;
        }
        LinkType linkType = this.getLinkType(arg);
        String queue = this.getQueue(arg);
        int length = queue.length();
        if (length == 1 && diagram.getNbOfHozizontalLollipop(normalEntity) > 1) {
            ++length;
        }
        String firstLabel = arg.get("FIRST_LABEL", 0);
        String secondLabel = arg.get("SECOND_LABEL", 0);
        String labelLink = null;
        if (arg.get("LABEL_LINK", 0) != null) {
            labelLink = arg.get("LABEL_LINK", 0);
            if (firstLabel == null && secondLabel == null) {
                Pattern2 p1 = MyPattern.cmpile("^\"([^\"]+)\"([^\"]+)\"([^\"]+)\"$");
                Matcher2 m1 = p1.matcher(labelLink);
                if (m1.matches()) {
                    firstLabel = m1.group(1);
                    labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m1.group(2))));
                    secondLabel = m1.group(3);
                } else {
                    Pattern2 p2 = MyPattern.cmpile("^\"([^\"]+)\"([^\"]+)$");
                    Matcher2 m2 = p2.matcher(labelLink);
                    if (m2.matches()) {
                        firstLabel = m2.group(1);
                        labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m2.group(2))));
                        secondLabel = null;
                    } else {
                        Pattern2 p3 = MyPattern.cmpile("^([^\"]+)\"([^\"]+)\"$");
                        Matcher2 m3 = p3.matcher(labelLink);
                        if (m3.matches()) {
                            firstLabel = null;
                            labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m3.group(1))));
                            secondLabel = m3.group(2);
                        }
                    }
                }
            }
            labelLink = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(labelLink);
        }
        LinkArg linkArg = LinkArg.build(Display.getWithNewlines(labelLink), length, diagram.getSkinParam().classAttributeIconSize() > 0);
        Link link = new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), cl1, cl2, linkType, linkArg.withQuantifier(firstLabel, secondLabel).withDistanceAngle(diagram.getLabeldistance(), diagram.getLabelangle()));
        diagram.resetPragmaLabel();
        this.addLink(diagram, link, arg.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private IEntity getFoo1(AbstractClassOrObjectDiagram diagram, Code code, Ident ident) {
        if (diagram.V1972()) {
            ILeaf result;
            ILeaf iLeaf = result = ident.size() == 1 ? diagram.getLeafVerySmart(ident) : diagram.getLeafStrict(ident);
            if (result != null) {
                return result;
            }
        }
        return diagram.getOrCreateLeaf(ident, code, null, null);
    }

    private void addLink(AbstractClassOrObjectDiagram diagram, Link link, String weight) {
        diagram.addLink(link);
        if (weight != null) {
            link.setWeight(Double.parseDouble(weight));
        }
    }

    private LinkType getLinkType(RegexResult arg) {
        return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
    }

    private String getQueue(RegexResult arg) {
        if (arg.get("LOL_THEN_ENT", 1) != null) {
            return StringUtils.trin(arg.get("LOL_THEN_ENT", 1));
        }
        if (arg.get("ENT_THEN_LOL", 0) != null) {
            return StringUtils.trin(arg.get("ENT_THEN_LOL", 0));
        }
        throw new IllegalArgumentException();
    }
}

