/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.parser.StyleParser;
import net.sourceforge.plantuml.style.parser.StyleParsingException;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.StringLocated;

public class StyleExtractor {
    private final List<String> list = new ArrayList<String>();
    private final List<StringLocated> style = new ArrayList<StringLocated>();
    private String title = null;
    private boolean handwritten = false;
    private double scale = 1.0;

    public StyleExtractor(Iterator<StringLocated> data) {
        block2: while (data.hasNext()) {
            StringLocated line = data.next();
            String s = line.getString().trim();
            if (s.length() == 0) continue;
            if (this.startStyle(s)) {
                while (data.hasNext()) {
                    this.style.add(line);
                    if (this.endStyle(line)) continue block2;
                    line = data.next();
                }
                continue;
            }
            if (this.list.size() >= 1 && s.startsWith("!assume ") || this.list.size() >= 1 && s.startsWith("!pragma ") || this.list.size() >= 1 && s.startsWith("hide ")) continue;
            if (this.list.size() >= 1 && s.startsWith("scale ")) {
                try {
                    double v = Double.parseDouble(s.replaceAll("\\D", ""));
                    if (!(v > 0.0)) continue;
                    this.scale = v;
                }
                catch (Exception exception) {}
                continue;
            }
            if (this.list.size() >= 1 && s.startsWith("title ")) {
                this.title = s.substring("title ".length()).trim();
                continue;
            }
            if (this.list.size() >= 1 && s.startsWith("skinparam ")) {
                if (s.contains("handwritten") && s.contains("true")) {
                    this.handwritten = true;
                }
                if (!s.contains("{")) continue;
                while (data.hasNext() && !line.getString().trim().equals("}")) {
                    line = data.next();
                }
                continue;
            }
            this.list.add(line.getString());
        }
    }

    private boolean startStyle(String line) {
        return line.equals("<style>");
    }

    private boolean endStyle(StringLocated line) {
        return line.getString().trim().equals("</style>");
    }

    public void applyStyles(ISkinParam skinParam) throws StyleParsingException {
        if (this.style.size() > 0) {
            StyleBuilder styleBuilder = skinParam.getCurrentStyleBuilder();
            BlocLines blocLines = BlocLines.from(this.style);
            for (Style modifiedStyle : StyleParser.parse(blocLines.subExtract(1, 1), styleBuilder)) {
                skinParam.muteStyle(modifiedStyle);
            }
        }
    }

    public Iterator<String> getIterator() {
        return this.list.iterator();
    }

    public String getTitle() {
        return this.title;
    }

    public final boolean isHandwritten() {
        return this.handwritten;
    }

    public double getScale() {
        return this.scale;
    }
}

