/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.IEntityImageBlock;
import net.sourceforge.plantuml.posimo.Positionable;

public class MargedBlock {
    private final Block block;
    private final IEntityImageBlock imageBlock;
    private final double marginDecorator;
    private final XDimension2D imageDimension;
    private static int uid = 1;

    public MargedBlock(StringBounder stringBounder, IEntityImageBlock imageBlock, double marginDecorator, Cluster parent) {
        this.imageBlock = imageBlock;
        this.marginDecorator = marginDecorator;
        this.imageDimension = imageBlock.getDimension(stringBounder);
        this.block = new Block(uid++, this.imageDimension.getWidth() + 2.0 * marginDecorator, this.imageDimension.getHeight() + 2.0 * marginDecorator, parent);
    }

    public Block getBlock() {
        return this.block;
    }

    public double getMarginDecorator() {
        return this.marginDecorator;
    }

    public IEntityImageBlock getImageBlock() {
        return this.imageBlock;
    }

    public Positionable getImagePosition() {
        return new Positionable(){

            @Override
            public XDimension2D getSize() {
                return MargedBlock.this.imageDimension;
            }

            @Override
            public XPoint2D getPosition() {
                XPoint2D pos = MargedBlock.this.block.getPosition();
                return new XPoint2D(pos.getX() + MargedBlock.this.marginDecorator, pos.getY() + MargedBlock.this.marginDecorator);
            }

            @Override
            public void moveSvek(double deltaX, double deltaY) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

