/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.util.Objects;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class ComponentRoseGroupingHeader
extends AbstractTextualComponent {
    private final int cornersize = 10;
    private final int commentMargin = 0;
    private final TextBlock commentTextBlock;
    private final HColor background;
    private final SymbolContext symbolContext;
    private final SymbolContext symbolContextCorner;
    private final double roundCorner;

    public ComponentRoseGroupingHeader(boolean teoz, Style style, Style styleHeader, Display strings, ISkinSimple spriteContainer) {
        super(styleHeader, LineBreakStrategy.NONE, 15, 30, 1, spriteContainer, strings.get(0));
        this.roundCorner = style.value(PName.RoundCorner).asInt(false);
        this.background = teoz ? HColors.transparent() : style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
        this.symbolContext = style.getSymbolContext(this.getIHtmlColorSet());
        this.symbolContextCorner = styleHeader.getSymbolContext(this.getIHtmlColorSet());
        FontConfiguration smallFont2 = style.getFontConfiguration(this.getIHtmlColorSet());
        if (strings.size() == 1 || strings.get(1) == null) {
            this.commentTextBlock = null;
        } else {
            Display display = Display.getWithNewlines("[" + strings.get(1) + "]");
            this.commentTextBlock = display.create(smallFont2, HorizontalAlignment.LEFT, spriteContainer);
        }
        Objects.requireNonNull(this.background);
    }

    private double getSuppHeightForComment(StringBounder stringBounder) {
        if (this.commentTextBlock == null) {
            return 0.0;
        }
        double height = this.commentTextBlock.calculateDimension(stringBounder).getHeight();
        if (height > 15.0) {
            return height - 15.0;
        }
        return 0.0;
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double sup;
        if (this.commentTextBlock == null) {
            sup = 0.0;
        } else {
            XDimension2D size = this.commentTextBlock.calculateDimension(stringBounder);
            sup = (double)(this.getMarginX1() + 0) + size.getWidth();
        }
        return this.getTextWidth(stringBounder) + sup;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY() + this.getSuppHeightForComment(stringBounder);
    }

    @Override
    protected void drawBackgroundInternalU(UGraphic ug, Area area) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        ug = this.symbolContext.applyStroke(ug).apply(this.symbolContext.getForeColor());
        URectangle rect = new URectangle(dimensionToUse.getWidth(), dimensionToUse.getHeight()).rounded(this.roundCorner);
        rect.setDeltaShadow(this.symbolContext.getDeltaShadow());
        ug.apply(this.background.bg()).draw(rect);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        StringBounder stringBounder = ug.getStringBounder();
        double textWidth = this.getTextWidth(stringBounder);
        double textHeight = this.getTextHeight(stringBounder);
        this.symbolContextCorner.apply(ug).draw(this.getCorner(textWidth, textHeight));
        ug = this.symbolContext.applyStroke(ug).apply(this.symbolContext.getForeColor());
        URectangle rect = new URectangle(dimensionToUse.getWidth(), dimensionToUse.getHeight()).rounded(this.roundCorner);
        ug.draw(rect);
        ug = ug.apply(new UStroke());
        this.getTextBlock().drawU(ug.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
        if (this.commentTextBlock != null) {
            double x1 = (double)this.getMarginX1() + textWidth;
            double y2 = this.getMarginY() + 1;
            this.commentTextBlock.drawU(ug.apply(new UTranslate(x1 + 0.0, y2)));
        }
    }

    private UPath getCorner(double width, double height) {
        UPath polygon = new UPath();
        if (this.roundCorner == 0.0) {
            polygon.moveTo(0.0, 0.0);
            polygon.lineTo(width, 0.0);
            polygon.lineTo(width, height - 10.0);
            polygon.lineTo(width - 10.0, height);
            polygon.lineTo(0.0, height);
            polygon.lineTo(0.0, 0.0);
        } else {
            polygon.moveTo(this.roundCorner / 2.0, 0.0);
            polygon.lineTo(width, 0.0);
            polygon.lineTo(width, height - 10.0);
            polygon.lineTo(width - 10.0, height);
            polygon.lineTo(0.0, height);
            polygon.lineTo(0.0, this.roundCorner / 2.0);
            polygon.arcTo(this.roundCorner / 2.0, this.roundCorner / 2.0, 0.0, 0.0, 1.0, this.roundCorner / 2.0, 0.0);
        }
        return polygon;
    }
}

