/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleScheme;
import net.sourceforge.plantuml.style.ValueImpl;
import net.sourceforge.plantuml.style.parser.Context;
import net.sourceforge.plantuml.style.parser.CssVariables;
import net.sourceforge.plantuml.style.parser.StyleParsingException;
import net.sourceforge.plantuml.style.parser.StyleToken;
import net.sourceforge.plantuml.style.parser.StyleTokenType;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.CharInspector;
import net.sourceforge.plantuml.utils.Inspector;
import net.sourceforge.plantuml.utils.InspectorUtils;

public class StyleParser {
    public static Collection<Style> parse(BlocLines lines, AutomaticCounter counter) throws StyleParsingException {
        if (lines.size() == 0) {
            return Collections.emptyList();
        }
        List<StyleToken> tokens = StyleParser.parse(lines.inspectorWithNewlines());
        ArrayList<Style> result = new ArrayList<Style>();
        CssVariables variables = new CssVariables();
        StyleScheme scheme = StyleScheme.REGULAR;
        Context context = new Context();
        Inspector<StyleToken> ins = InspectorUtils.inspector(tokens);
        while (ins.peek(0) != null) {
            Object full;
            StyleToken token = ins.peek(0);
            ins.jump();
            if (token.getType() == StyleTokenType.NEWLINE || token.getType() == StyleTokenType.SEMICOLON) continue;
            if (ins.peek(0).getType() == StyleTokenType.COMMA) {
                full = token.getData() + StyleParser.readWithComma(ins);
                StyleParser.skipNewLines(ins);
                if (ins.peek(0).getType() == StyleTokenType.OPEN_BRACKET) {
                    context = context.push((String)full);
                    ins.jump();
                    continue;
                }
                throw new IllegalStateException();
            }
            if (token.getType() == StyleTokenType.STRING) {
                full = token.getData();
                if (ins.peek(0).getType() == StyleTokenType.STAR) {
                    ins.jump();
                    full = (String)full + "*";
                }
                StyleParser.skipNewLines(ins);
                if (ins.peek(0).getType() == StyleTokenType.OPEN_BRACKET) {
                    context = context.push((String)full);
                    ins.jump();
                    continue;
                }
                StyleParser.skipColon(ins);
                if (token.getData().startsWith("--")) {
                    variables.learn(token.getData(), StyleParser.readValue(ins));
                    continue;
                }
                if (ins.peek(0).getType() == StyleTokenType.STRING) {
                    String valueString = variables.value(StyleParser.readValue(ins));
                    String keyString = token.getData();
                    PName key = PName.getFromName(keyString, scheme);
                    if (key == null) continue;
                    ValueImpl value = scheme == StyleScheme.REGULAR ? ValueImpl.regular(valueString, counter) : ValueImpl.dark(valueString, counter);
                    context.putInContext(key, value);
                    continue;
                }
                throw new StyleParsingException("parsing");
            }
            if (token.getType() == StyleTokenType.CLOSE_BRACKET) {
                for (Style st : context.toStyles()) {
                    result.add(st);
                }
                if (context.size() <= 0) continue;
                context = context.pop();
                continue;
            }
            if (token.getType() == StyleTokenType.AROBASE_MEDIA) {
                scheme = StyleScheme.DARK;
                continue;
            }
            if (token.getType() == StyleTokenType.COLON && ins.peek(0).getType() == StyleTokenType.STRING && ins.peek(1).getType() == StyleTokenType.OPEN_BRACKET) {
                full = token.getData() + ins.peek(0).getData();
                context = context.push((String)full);
                ins.jump();
                ins.jump();
                continue;
            }
            if (token.getType() == StyleTokenType.COLON && ins.peek(0).getType() == StyleTokenType.STRING && ins.peek(1).getType() == StyleTokenType.STAR && ins.peek(2).getType() == StyleTokenType.OPEN_BRACKET) {
                full = token.getData() + ins.peek(0).getData() + ins.peek(1).getData();
                context = context.push((String)full);
                ins.jump();
                ins.jump();
                ins.jump();
                continue;
            }
            if (token.getType() == StyleTokenType.OPEN_BRACKET) {
                throw new StyleParsingException("Invalid open bracket");
            }
            throw new IllegalStateException(token.toString());
        }
        return Collections.unmodifiableList(result);
    }

    private static String readWithComma(Inspector<StyleToken> ins) {
        StringBuilder result = new StringBuilder();
        while (ins.peek(0) != null) {
            StyleToken current = ins.peek(0);
            if (current.getType() != StyleTokenType.STRING && current.getType() != StyleTokenType.COMMA) {
                return result.toString();
            }
            result.append(current.getData());
            ins.jump();
        }
        return result.toString();
    }

    private static String readValue(Inspector<StyleToken> ins) throws StyleParsingException {
        StringBuilder result = new StringBuilder();
        while (ins.peek(0) != null) {
            StyleToken current = ins.peek(0);
            if (current.getType() == StyleTokenType.NEWLINE || current.getType() == StyleTokenType.SEMICOLON || current.getType() == StyleTokenType.CLOSE_BRACKET) {
                return result.toString();
            }
            if (current.getType() == StyleTokenType.STRING) {
                if (result.length() > 0) {
                    result.append(' ');
                }
                result.append(current.getData());
                ins.jump();
                continue;
            }
            if (current.getType() == StyleTokenType.COLON) {
                result.append(current.getData());
                ins.jump();
                if (ins.peek(0).getType() == StyleTokenType.STRING) {
                    result.append(ins.peek(0).getData());
                    ins.jump();
                    continue;
                }
                throw new StyleParsingException("bad definition");
            }
            throw new StyleParsingException("bad definition");
        }
        return result.toString();
    }

    private static void skipNewLines(Inspector<StyleToken> ins) {
        StyleToken token;
        while ((token = ins.peek(0)) != null && token.getType() == StyleTokenType.NEWLINE) {
            ins.jump();
        }
        return;
    }

    private static void skipColon(Inspector<StyleToken> ins) {
        StyleToken token;
        while ((token = ins.peek(0)) != null && token.getType() == StyleTokenType.COLON) {
            ins.jump();
        }
        return;
    }

    private static List<StyleToken> parse(CharInspector ins) throws StyleParsingException {
        char current;
        ArrayList<StyleToken> result = new ArrayList<StyleToken>();
        while ((current = ins.peek(0)) != '\u0000') {
            if (current == ' ' || current == '\t') {
                ins.jump();
                continue;
            }
            if (current == '/' && ins.peek(1) == '/') {
                StyleParser.jumpUntil(ins, '\n');
                continue;
            }
            if (current == '/' && ins.peek(1) == '\'') {
                StyleParser.jumpUntil(ins, '\'', '/');
                continue;
            }
            if (current == '/' && ins.peek(1) == '*') {
                StyleParser.jumpUntil(ins, '*', '/');
                continue;
            }
            if (current == ',') {
                result.add(new StyleToken(StyleTokenType.COMMA, ","));
                ins.jump();
                continue;
            }
            if (current == ';') {
                result.add(new StyleToken(StyleTokenType.SEMICOLON, ";"));
                ins.jump();
                continue;
            }
            if (current == '\n' || current == '\r') {
                result.add(new StyleToken(StyleTokenType.NEWLINE, "NEWLINE"));
                ins.jump();
                continue;
            }
            if (current == '*') {
                result.add(new StyleToken(StyleTokenType.STAR, "*"));
                ins.jump();
                continue;
            }
            if (current == ':') {
                result.add(new StyleToken(StyleTokenType.COLON, ":"));
                ins.jump();
                continue;
            }
            if (current == '{') {
                result.add(new StyleToken(StyleTokenType.OPEN_BRACKET, "{"));
                ins.jump();
                continue;
            }
            if (current == '}') {
                result.add(new StyleToken(StyleTokenType.CLOSE_BRACKET, "}"));
                ins.jump();
                continue;
            }
            if (current == '@') {
                result.add(new StyleToken(StyleTokenType.AROBASE_MEDIA, StyleParser.readArobaseMedia(ins)));
                continue;
            }
            String s = StyleParser.readString(ins);
            if (s.startsWith("<")) {
                throw new StyleParsingException("Cannot understand <");
            }
            result.add(new StyleToken(StyleTokenType.STRING, s));
        }
        return result;
    }

    private static void jumpUntil(CharInspector ins, char ch1) {
        while (ins.peek(0) != '\u0000') {
            if (ins.peek(0) == ch1) {
                ins.jump();
                return;
            }
            ins.jump();
        }
    }

    private static void jumpUntil(CharInspector ins, char ch1, char ch2) {
        while (ins.peek(0) != '\u0000') {
            if (ins.peek(0) == ch1 && ins.peek(1) == ch2) {
                ins.jump();
                ins.jump();
                return;
            }
            ins.jump();
        }
    }

    private static String readArobaseMedia(CharInspector ins) {
        char current0 = ins.peek(0);
        if (current0 != '@') {
            throw new IllegalStateException();
        }
        ins.jump();
        StringBuilder result = new StringBuilder();
        while (ins.peek(0) != '\u0000') {
            char ch = ins.peek(0);
            ins.jump();
            if (ch == '{' || ch == '}' || ch == ';') break;
            result.append(ch);
        }
        return result.toString();
    }

    private static String readString(CharInspector ins) {
        char ch;
        StringBuilder result = new StringBuilder();
        while (ins.peek(0) != '\u0000' && (ch = ins.peek(0)) != '\n' && ch != '\r' && (ch != ' ' || result.charAt(0) == '.') && ch != '{' && ch != '}' && ch != ';' && ch != ',' && ch != ':' && ch != '\t') {
            ins.jump();
            result.append(ch);
        }
        if (result.charAt(0) == '.') {
            return result.toString().trim();
        }
        return result.toString();
    }
}

