/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.utils.Direction;

public class TimeConstraint {
    private final TimeTick tick1;
    private final TimeTick tick2;
    private final Display label;
    private final ISkinParam skinParam;
    private final StyleBuilder styleBuilder;
    private final ArrowConfiguration config;
    private final double marginx;

    public TimeConstraint(double marginx, TimeTick tick1, TimeTick tick2, String label, ISkinParam skinParam, ArrowConfiguration config) {
        this.marginx = marginx;
        this.tick1 = Objects.requireNonNull(tick1);
        this.tick2 = Objects.requireNonNull(tick2);
        this.label = Display.getWithNewlines(label);
        this.skinParam = skinParam;
        this.styleBuilder = skinParam.getCurrentStyleBuilder();
        this.config = config;
    }

    public final boolean containsStrict(TimeTick other) {
        return this.tick1.compareTo(other) < 0 && this.tick2.compareTo(other) > 0;
    }

    public final TimeTick getTick1() {
        return this.tick1;
    }

    public final TimeTick getTick2() {
        return this.tick2;
    }

    public final Display getLabel() {
        return this.label;
    }

    private TextBlock getTextBlock(Display display) {
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    private FontConfiguration getFontConfiguration() {
        return this.getStyle().getFontConfiguration(this.skinParam.getIHtmlColorSet());
    }

    public void drawU(UGraphic ug, TimingRuler ruler) {
        HColor arrowColor = this.getArrowColor();
        ug = ug.apply(arrowColor).apply(arrowColor.bg());
        double x1 = ruler.getPosInPixel(this.tick1) + this.marginx;
        double x2 = ruler.getPosInPixel(this.tick2) - this.marginx;
        ug = ug.apply(UTranslate.dx(x1));
        double len = x2 - x1;
        ug.apply(this.getUStroke()).draw(ULine.hline(len));
        if (len > 10.0) {
            ug.draw(this.getPolygon(Direction.LEFT, new XPoint2D(0.0, 0.0)));
            ug.draw(this.getPolygon(Direction.RIGHT, new XPoint2D(len, 0.0)));
        } else {
            ug.draw(this.getPolygon(Direction.RIGHT, new XPoint2D(0.0, 0.0)));
            ug.draw(this.getPolygon(Direction.LEFT, new XPoint2D(len, 0.0)));
        }
        TextBlock text = this.getTextBlock(this.label);
        XDimension2D dimText = text.calculateDimension(ug.getStringBounder());
        double x = (len - dimText.getWidth()) / 2.0;
        text.drawU(ug.apply(new UTranslate(x, -this.getConstraintHeight(ug.getStringBounder()))));
    }

    private HColor getArrowColor() {
        HColor configColor = this.config.getColor();
        if (configColor != null) {
            return configColor;
        }
        return this.getStyle().value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.styleBuilder);
    }

    private UStroke getUStroke() {
        return this.getStyle().getStroke();
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.constraintArrow);
    }

    public double getConstraintHeight(StringBounder stringBounder) {
        TextBlock text = this.getTextBlock(this.label);
        XDimension2D dimText = text.calculateDimension(stringBounder);
        return dimText.getHeight() + TimeConstraint.getTopMargin();
    }

    public static double getTopMargin() {
        return 5.0;
    }

    private UPolygon getPolygon(Direction dir, XPoint2D end) {
        XPoint2D pt2;
        XPoint2D pt1;
        double dx = 8.0;
        double dy = 4.0;
        if (dir == Direction.RIGHT) {
            pt1 = end.move(-8.0, 4.0);
            pt2 = end.move(-8.0, -4.0);
        } else {
            pt1 = end.move(8.0, 4.0);
            pt2 = end.move(8.0, -4.0);
        }
        UPolygon polygon = new UPolygon();
        polygon.addPoint(pt1);
        polygon.addPoint(pt2);
        polygon.addPoint(end);
        return polygon;
    }

    public static double getHeightForConstraints(StringBounder stringBounder, List<TimeConstraint> constraints) {
        if (constraints.size() == 0) {
            return 0.0;
        }
        double result = 0.0;
        for (TimeConstraint constraint : constraints) {
            result = Math.max(result, constraint.getConstraintHeight(stringBounder));
        }
        return result;
    }
}

