/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.xmi.XmiSequenceDiagram;
import net.sourceforge.plantuml.xmi.XmiSequenceDiagramArgo;
import net.sourceforge.plantuml.xmi.XmiSequenceDiagramStandard;
import net.sourceforge.plantuml.xml.XmlFactories;
import org.w3c.dom.Document;

public final class SequenceDiagramXmiMaker
implements FileMaker {
    private final SequenceDiagram diagram;
    private final FileFormat fileFormat;

    public SequenceDiagramXmiMaker(SequenceDiagram sequenceDiagram, FileFormat fileFormat) {
        this.diagram = sequenceDiagram;
        this.fileFormat = fileFormat;
    }

    @Override
    public ImageData createOne(OutputStream os, int index, boolean isWithMetadata) throws IOException {
        DocumentBuilder builder;
        ImageDataSimple imageData = new ImageDataSimple(0, 0);
        try {
            builder = XmlFactories.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logme.error(e);
            return imageData;
        }
        Document document = builder.newDocument();
        document.setXmlVersion("1.0");
        document.setXmlStandalone(true);
        XmiSequenceDiagram xmi = this.fileFormat == FileFormat.XMI_ARGO ? new XmiSequenceDiagramArgo(this.diagram, document) : new XmiSequenceDiagramStandard(this.diagram, document);
        xmi.build();
        try {
            this.writeDocument(document, os);
        }
        catch (ParserConfigurationException | TransformerException e) {
            Logme.error(e);
        }
        return imageData;
    }

    @Override
    public int getNbPages() {
        return 1;
    }

    private void writeDocument(Document document, OutputStream os) throws TransformerException, ParserConfigurationException {
        DOMSource source = new DOMSource(document);
        StreamResult resultat = new StreamResult(os);
        Transformer transformer = XmlFactories.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.transform(source, resultat);
    }
}

