/**
 *  @file PathContext.h
 *
 *  @brief Declarations of PathInfo and PathContext
 */
// RCS ID line follows -- this is updated by CVS
// $Id: PathContext.h 2762 2005-11-28 18:12:54Z kimmov $


#ifndef _PATH_CONTEXT_H_
#define _PATH_CONTEXT_H_

/**
 * @brief Information for one path.
 *
 * Path is stored in normalized format (no trailing slash).
 */
class PathInfo
{
public:
	PathInfo() {}
	PathInfo(const PathInfo &pi);

	CString GetPath(BOOL bNormalized = TRUE) const;
	CString& GetRef();
	void SetPath(CString path);
	void NormalizePath();

private:
	CString m_sPath;  /**< Directory / file path */
};

/**
 * @brief Holds path information of compared files/directories.
 */
class PathContext
{
public:
	PathContext();
	PathContext(CString sLeft);
	PathContext(CString sLeft, CString sRight);
	PathContext(CString sLeft, CString sMiddle, CString sRight);
	PathContext(CStringArray &sFiles);
	PathContext(const PathContext &paths);

	CString GetAt(int nIndex) const;
	CString& GetElement(int nIndex);
	void SetAt(int nIndex, const CString& newElement);
	CString operator[](int nIndex) const;
	CString& operator[](int nIndex);

	CString GetLeft(BOOL bNormalized = TRUE) const;
	CString GetRight(BOOL bNormalized = TRUE) const;
	CString GetMiddle(BOOL bNormalized = TRUE) const;
	CString GetPath(int index, BOOL bNormalized = TRUE) const;
	void SetLeft(LPCTSTR path);
	void SetRight(LPCTSTR path);
	void SetMiddle(LPCTSTR path);
	void SetPath(int index, LPCTSTR path);
	void SetSize(int nFiles);
	int GetSize() const;
	void RemoveAll();

private:
	int m_nFiles;
	PathInfo m_path[3]; /**< First, second, third path (left path at start) */
};

/**
 * @brief Temp files for compared files
 */
class TempFileContext : public PathContext
{
public:
	~TempFileContext();
	BOOL CreateFiles(const PathContext &paths);
	BOOL FilesExist();
	void DeleteFiles();
	const CString & GetTempPath() const { return m_sTempPath; }

private:
	CString m_sTempPath;
};

#endif  // _PATH_CONTEXT_H_
