---
title: 変更履歴(2014～2017年)
---

### 2017/12/29 2.14.0-jp-143

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/ja/file/d9ad89da391d71f8cf856dcb531b788020687256ed188cc915f0f5cfe1b401e6/analysis/1514524874/),
  [64bitインストーラ](https://www.virustotal.com/ja/file/eaf701433981837c63f42f5578428dc793c13194fc1b86db26ee0abe8d7661e2/analysis/1514524896/),
  [32bit-zip](https://www.virustotal.com/ja/file/19933e439711c1b6c406a147aa3b5cd1f24319b2cc26a663ea74feb6586adcf8/analysis/1514524991/),
  [64bit-zip](https://www.virustotal.com/ja/file/dc61838e15c0b225488dead3a190fe187a98dec4f1c49cacf1f56dc641c0c6cf/analysis/1514524947/)
* ご連絡いただいた以下の問題を修正
    * ファイル比較: [ファイルエンコーディング]メニュー等からファイルを再読み込みした後に置換を行うと異常終了することがある
    * ファイル比較: VHDLのシンタックスハイライト機能を追加。([PullRequest](https://bitbucket.org/sdottaka/winmerge-v2/commits/39f5a42f9b9b)ありがとうございます)
* ファイル比較: ファイルの再読み込み後、マーカダイアログを表示すると[検索文字列]に現在カーソル位置の単語が表示されない問題を修正
* オプションダイアログ表示の高速化。([言語]コンボボックスのリスト部の非同期読込みによる高速化)
* 実験的機能: コマンド引数によりレポート作成できるようにしてみた。  
  * フォルダ比較レポート作成例) 
  ~~~
  WinMergeU.exe 左側フォルダパス 右側フォルダパス -minimize -noninteractive -noprefs -cfg Settings/DirViewExpandSubdirs=1 -cfg ReportFiles/ReportType=2 -cfg ReportFiles/IncludeFileCmpReport=1 -r -u -or レポートファイルパス
  ~~~
    * -minimize: ウインドウを最小化してWinMergeを起動
    * -noninteractive: 比較・レポート生成後、WinMergeを終了する 
    * -noprefs: レジストリから設定情報を読み書きしない(デフォルト値を使用)※一部の設定項目は対象外
    * -cfg Settings/DirViewExpandSubdirs=: 1:比較後フォルダツリーを展開する 0:しない
    * -cfg ReportFiles/ReportType=: 2:HTML形式レポートを生成
    * -cfg ReportFiles/IncludeFileCmpReport=: 1:フォルダ比較レポートにファイル比較レポートを含める 0:含めない
    * -or レポートファイルパス

### 2017/10/29 2.14.0-jp-142

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/ja/file/d4d8db33e2105b1b4894bea7284a1b0db12e9104e0a5d538f1cca9654705696c/analysis/1509206186/),
  [64bitインストーラ](https://www.virustotal.com/ja/file/48b8561e974aa8ea43dc0870f91b67db81e628c0923d546ee5b259aeca1e895e/analysis/1509206192/),
  [32bit-zip](https://www.virustotal.com/ja/file/86bb5f5301534f66bdca1eb19a54541693f6f8dbd6a77a501d370b6ad0f7d84a/analysis/1509206199/),
  [64bit-zip](https://www.virustotal.com/ja/file/f20a75db00e789b401f4643f24819358cf70a999ad84c75e4becbc0b2dcfa247/analysis/1509206212/)
  **eGambit の結果が Unsafe.AI_Score_94% となっています。**
* ご連絡いただいた以下の問題を修正
    * HTMLレポートを作成しようとすると異常終了する
* ファイル比較: 検索結果がハイライトされないことがある問題を修正

### 2017/09/29 2.14.0-jp-141

* VirusTotal チェック結果: 
    						[32bitインストーラ](https://www.virustotal.com/ja/file/f507aecba349f46157ac6441a532e5e1fc2ee6128c6eeb7cc1a09a14617996be/analysis/1506270578/),
    						[64bitインストーラ(2019/9/29 22:00 リンクが間違っていました。ご連絡ありがとうございます。)](https://www.virustotal.com/ja/file/e72483021d6b7b65645e2c2674f609e03eb317d3e6131a018e6bca1e600db5e6/analysis/1506687088/),
    						[32bit-zip](https://www.virustotal.com/ja/file/facf4048c974bddbc19ee0bb66c3c95b39e5577e49e5c3a0d4b583f0b5f24f40/analysis/1506355682/),
    						[64bit-zip](https://www.virustotal.com/ja/file/d9e790e58f32d51095c8114cf9cc29110f952d5fcac21da1c988f11cb850f2a2/analysis/1506355713/)
* ご連絡いただいた以下の問題を修正
    * ファイル比較: マーカ機能を追加してほしい。([編集]メニュー→[マーカ]で指定した文字列が色付けされるようになります)
    * バイナリ比較: オプションウインドウで設定したカスタムカラーが反映されない。
    * フォルダ比較: [左/右ファイルバージョン]列が正常にソートされない。
    * フォルダ比較: 同一ファイルと判定されたファイルをドラッグして別のアプリケーションにコピーすると左側のパスしかコピーされない。[Bitbucket#77](https://bitbucket.org/winmerge/winmerge/issues/77/)
* ファイル比較: [行を右端で折り返す]を選択すると差異が正しくハイライトされないことがある問題を修正
* ファイル比較: 検索文字列をマーカ機能で色付けするようにした
* フォルダ比較: 右クリックメニュー「選択項目を再比較する」を実行すると異常終了することがある問題を修正

### 2017/07/29 2.14.0-jp-137

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/ja/file/a4cde38df2c0e66f53219b57f0dbce8514481296f749ec4fda3e7acf39861009/analysis/1501324118/),
  [64bitインストーラ](https://www.virustotal.com/ja/file/5139c5a6875ef9bd29dafa2691bd087811a5a2503c27b3738c187f7514b847e3/analysis/1501324189/),
  [32bit-zip](https://www.virustotal.com/ja/file/925310d3c4bef7080c0bf6ab526ed9e0c1e6bb399ba6405646c546f0a8c20f05/analysis/1501324275/),
  [64bit-zip](https://www.virustotal.com/ja/file/746632c697f1a2779d8792fb80d4af2c277d97b319ce3bc837a968b7d4ddb9b8/analysis/1501324373/)
  **patch.exe(GnuWin32のもの) を含んだ今回と過去のバージョンすべてで Cylance が「Unsafe」と判定してしまっているようです... かなり昔のバージョンのpatchなので脆弱性があるとみなされたのでしょうか...  
  2017/08/10: この件について、Cylance Japan様よりご回答いただきました。CylancePROTECT製品版では、「Safe」とみなされているそうです。では、なぜVirusTotalで検出されてしまうのかは、調査中とのことですが、VirusTotalに提供しているエンジンが製品版と違うものであり、判定に差が出る可能性があるとのことでした。**
* ご連絡いただいた以下の問題を修正
    * フォルダ比較: フォルダ比較ウインドウから開いたファイルで「右/左にコピーして次に進む」メニューを実行すると異常終了することがある。
* フォルダ比較: フォルダ比較結果HTMLレポートファイルの文字コードをUTF-8に変更しました。(これでHTMLレポートをExcelに張り付けるときに文字化けしないようになっています)
* ファイル比較: Go言語、Rust言語のシンタックスハイライト機能を追加。C++11のキーワードを追加
* プラグイン: 設定ウインドウ→[コードページ]カテゴリ→[カスタムコードページ]で65001(UTF-8)が選択されている場合、プラグインで展開された結果が文字化けする問題を修正
* Visual Studio Community 2017 でビルドするようにしました。

### 2017/05/29 2.14.0-jp-135

* VirusTotal チェック結果: 
    						[32bitインストーラ](https://www.virustotal.com/ja/file/bd14d1f4c316c2541d373aae6af56905d5cec196787c7c7939fd9320b59d51e9/analysis/1495985484/),
    						[64bitインストーラ](https://www.virustotal.com/ja/file/2699a89930120d8d70791c07266796824073a705b7bbb8bd9a8dfbf5a073ff70/analysis/1495985510/),
    						[32bit-zip](https://www.virustotal.com/ja/file/aa461a7ea6c0e9e3bdbc7ea508bb2f22e65f0976a97017102bde16492460565f/analysis/1495985531/),
    						[64bit-zip](https://www.virustotal.com/ja/file/074beb44783889b8332fb724f664f52d7b405a11c316e6717995657fb88bb157/analysis/1495985565/)
* ご連絡いただいた以下の問題を修正
    * 設定ウインドウ: 設定ファイルをインポートしても[色/テキスト]、[色/シンタックス]の色に反映されない。
    * フォルダ比較: ファイル比較ウインドウから選択したファイルまたはフォルダの親フォルダを開けるようにしてほしい。[\#60](https://bitbucket.org/winmerge/winmerge/issues/60/) [例](https://twitter.com/winmerge_jp/status/838793292682702848)のようにメニューを追加しました。
    * フォルダ比較: 3つのフォルダを比較するとき、フォルダ内のバイナリファイルの比較結果が常に差異ありとなる。[github#23](https://github.com/winmerge/winmerge/pull/23) パッチをいただきました。
    * フォルダ比較: フォルダ比較ウインドウで[表示]→[デフォルトフォントを使用]メニューを選択したとき、デフォルトのフォントではないフォントになる。[github#24](https://github.com/winmerge/winmerge/pull/24) パッチをいただきました。
    * フォルダ比較: 日付列の`*`がついていない日付の位置調整。[github#25](https://github.com/winmerge/winmerge/pull/25) パッチをいただきました。
    * フォルダ比較: ツリーモード表示時、「左/右のみ存在する項目の表示」にチェックが入っているにもかかわらず、「差異項目の表示」にチェックを外した場合、サブフォルダ内の片方のみに存在するファイルやフォルダが表示されない。[\#64](https://bitbucket.org/winmerge/winmerge/issues/64/)
    * ファイル比較: diff3形式のコンフリクトファイルを開けるようにしてほしい。[\#61](https://bitbucket.org/winmerge/winmerge/issues/61/)
    * ファイル比較: ショートカットキーで外部エディタを起動できるようにしてほしい。(Ctrl+Alt+E に割り付けました)
    * Excel比較プラグイン: Excel2007,Excel2010の環境によっては画像化が機能しない。パッチをいただきました。
    * Excel比較プラグイン: 横幅が大きいシートで画像化に失敗する。パッチをいただきました。
    * Excel比較プラグイン: シート数が多いとエラーが発生する。パッチをいただきました。
    * 翻訳: 中国語(簡体字)表示時のインストーラで文字化けが発生する。[\#63](https://bitbucket.org/winmerge/winmerge/issues/63/)
    * 翻訳: 韓国語の更新。パッチをいただきました。
    * シェルエクステンション: Windows7でWindowsキーを押し、"cmd"を入力し、Ctrl+Shift+Enterキーを押してcmd.exeを管理者権限で起動しようとするとエクスプローラが異常終了してしまう。
* フォルダ比較ウインドウとファイル比較ウインドウが両方表示されている時、フォントを変更すると異常終了する問題を修正
* ハイコントラストモード時、メッセージボックスのメッセージが表示されない問題を修正
* ファイル比較: 灰色の行(削除行)を含めて削除する操作をRedoすると異常終了したり結果がおかしくなる問題を修正
* フォルダ比較: フォルダ比較中の進捗状況表示が実際の進捗状態とあっていない問題を修正
* シェルエクステンション: ハイコントラストモード時のアイコン表示の改善
* シェルエクステンション: zip版付属のRegister.batをWindows10上で実行するとシェルエクステンションの登録に失敗する問題を修正

### 2017/03/01 2.14.0-jp-129

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/en/file/e08be0ae94167b56f6ad7ea55023e8d73d1cbd42ad62b1e8940e4d3497a364da/analysis/1488211541/),
  [64bitインストーラ](https://www.virustotal.com/en/file/3e3c9b426aa80cf2b79bce099da67f005373ac1ba5e8c5292f301a00e1a10607/analysis/1488211620/),
  [32bit-zip](https://www.virustotal.com/en/file/f2d18b08de8293fe3b75fd0abb7c77e258727922fbec1f9166902286ba653dec/analysis/1488211718/),
  [64bit-zip](https://www.virustotal.com/en/file/4ae7bf58ae0dcfb210ed2936f151fa771faf6ebef8f688edb887b00b980c8c3e/analysis/1488211849/)
* ご連絡いただいた以下の問題を修正
    * フォルダ比較: 3フォルダ比較結果ウインドウのEOL列とエンコーディング列が空欄となる。[\#58](https://bitbucket.org/winmerge/winmerge/issues/58/)
    * 画像比較: 不正な画像ファイルを比較するとクラッシュする
    * ファイル比較: 行番号の背景色(マージン領域)の色を変更したい。([設定]ウインドウ→[色/テキスト]でマージンの色を変更できるようにしました)
* ハイコントラストモード時の表示を改善
* 画像比較: PageUp/PageDownキーでスクロールできるようにした。
* 画像比較: [画像]メニュー→[ドラッグモード]メニューを追加。[ドラッグモード]メニューの[オフセット調整]を選択すると、画像をドラッグして比較位置を調整できるようになります。

### 2017/01/29 2.14.0-jp-127

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/ja/file/7f9bf724e2487c13a6622a9962d939dae4c43c5f2b9602e140f09223b410b3b2/analysis/1485659437/),
  [64bitインストーラ](https://www.virustotal.com/ja/file/1e2b061c473daf66e39eb2957411b35542516a6e36c55ee4e84a829eafa1fa16/analysis/1485659447/),
  [32bit-zip](https://www.virustotal.com/ja/file/3b0aff16f5a0b1cf850cef23f59d12811169f0c2ffe645aa9392421c08494d24/analysis/1485659931/),
  [64bit-zip](https://www.virustotal.com/ja/file/0e05a8f4f51dded22098faa95ded37342602e862a8f3e521e4823045a7f113c4/analysis/1485659946/)
* ご連絡いただいた以下の問題を修正
    * CPUコア数が16を超えるコンピュータ上でフォルダ比較が進まない。
    * 「空行を無視する」の設定にしているにもかかわらず、空行のみで行数が異なるファイルを比較すると、差異ありと判定される。[\#57](https://bitbucket.org/winmerge/winmerge/issues/57/)
    * UTF-8のファイルだが先頭64KB以内がすべてASCII範囲内の場合にUTF-8とみなされない
* フォルダ比較ウインドウからファイル比較ウインドウを開いた場合、Alt+Downキー等で最後の差異から次の差異があるファイルに移動できるようにした。[例](https://twitter.com/winmerge_jp/status/818825205262925825) (以前と同じ動作に戻したい場合は、「次のファイルに移動しますか?」メッセージボックスで[再びこの質問をしない]チェックボックスにチェックを入れ、[いいえ]を選択してください。メッセージボックスが表示されるように戻したい場合は、[編集]メニュー→[設定]メニュー→[一般]カテゴリの[リセット]ボタンを押してください。)
* [編集]メニュー→[設定]→[比較/フォルダ]カテゴリに[比較スレッドの数]を追加。
* 画像比較: アニメ表示にした時のちらつきを少なくした。

### 2016/11/29 2.14.0-jp-121

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/ja/file/6624bfc9ca9334e0a17bbabc6e25eab8f5fa6272ddb02e58b98cea7aa583d112/analysis/1480342166/),
  [64bitインストーラ](https://www.virustotal.com/ja/file/05781b4d337592bced9d0863abf3a759b83d2aba641086646a792908b75d7994/analysis/1480342198/),
  [32bit-zip](https://www.virustotal.com/ja/file/5e4628f76cb96a258ae0145c2cc699158400065d3af8fdc5b98c1c174ae2ed64/analysis/1480342720/),
  [64bit-zip](https://www.virustotal.com/ja/file/77d2684ab9ef2625236e405556b471a47c2630598808bad44e394fec25d70331/analysis/1480342721/)
* ご連絡いただいた以下の問題を修正
    * ファイル比較: 3ファイル比較時、右側ペインの幅を変更してもヘッダ部の幅がそれに同期しない
* 画像比較: (1)差異部分の点滅表示と(2)2つの画像を交互に切り替えるアニメーション表示ができるようになった。[例](https://twitter.com/winmerge_jp/status/799012703767404544)
* 7-zip plugin をバージョン 16.04 に更新

### 2016/10/29 2.14.0-jp-119

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/en/file/5a93ea1c68363c17359ff79b970f8fb6f21cb258bfdeae5aaaf9ee2c93752272/analysis/1477727101/),
  [64bitインストーラ](https://www.virustotal.com/en/file/b65906ee59d540a3a37c4a9d3aa7c5abc574576dbfa7b7292b55e68c3b608f79/analysis/1477729721/),
  [32bit-zip](https://www.virustotal.com/en/file/096810951d972628e37d198fdf9e9e55cf16e7725a8a1cebcc292ed0ea41ca05/analysis/1477728895/),
  [64bit-zip](https://www.virustotal.com/en/file/be76b29bef38bc7f68993112e946ec1a5176a6bc141cfd447a81e55528413556/analysis/1477729837/)
* ご連絡いただいた以下の問題を修正
    * ファイル比較: Ctrl+Dキーで Diffコンテキストの全行表示と0～9行表示を交互に切り替えられるようにしてほしい[\#54](https://bitbucket.org/winmerge/winmerge/issues/54)
* 画像比較: ファイルの内容が変更されたり、ドラッグドロップで別ファイルに切り替えたりしてもタブバーのアイコンやファイル名が変更されない問題を修正

### 2016/09/29 2.14.0-jp-118

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/en/file/54f9037a0e954aac01566a4f7c230ee7c52898dc7d426c7f7fbe3956c32fb202/analysis/1474814666/),
  [64bitインストーラ](https://www.virustotal.com/en/file/add41cf77deeab9dbb348914d47770966e39d82b619452eb6ce37274a6c51f64/analysis/1474814989/),
  [32bit-zip](https://www.virustotal.com/en/file/e906ccba2ff42208b192fe6fb9e25b36a9fce5e2c85cdbcb4ec6d2767158bbd2/analysis/1474814977/),
  [64bit-zip](https://www.virustotal.com/en/file/add41cf77deeab9dbb348914d47770966e39d82b619452eb6ce37274a6c51f64/analysis/1474814989/)
* ご連絡いただいた以下の問題を修正
    * ファイル比較: 左右のペインにファイルをドラッグ＆ドロップできるようにしてほしい。
    * CompareMSExcelFiles.sct プラグイン: 外部参照(リンク)を含むExcelファイルを比較するとき「このブックには、ほかのデータ ソースヘのリンクが含まれています。」というメッセージボックスが表示されないようにしてほしい。
    * フォルダ比較: 左/右EOL列の結果が表示されない[\#53](https://bitbucket.org/winmerge/winmerge/issues/53)
* インストーラ: プラグインのインストールをデフォルトに変更
* フォルダ比較: ツリー表示をデフォルトに変更

### 2016/08/29 2.14.0-jp-116

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/en/file/2145660d97ae9f96bfc60b58a52c8a0ed0574be43e7d367df6d5e84ff5514a2e/analysis/1472383739/),
  [64bitインストーラ](https://www.virustotal.com/en/file/9c72187e26006efa9e14c962830273a3c300ba674f1f4bcb63be3f0dcacd6764/analysis/1472383065/),
  [32bit-zip](https://www.virustotal.com/en/file/a76174ab3671482d1535937c441e19ec6a02099f9f8d88a044fb4bd2564b1c81/analysis/1472383273/),
  [64bit-zip](https://www.virustotal.com/en/file/e42453a067d2b5eb930c802b065201349ceecca14d1fa2a295ce5d2bcbcfa80d/analysis/1472383780/)
* ご連絡いただいた以下の問題を修正
    * 「類似行をマッチさせる」をチェックした状態で比較し、左右を入れ替えると差異の表示結果が異なることがある[\#49](https://bitbucket.org/winmerge/winmerge/issues/49)
    * 履歴の16番目より後ろの項目を選択しても実行されない[\#50](https://bitbucket.org/winmerge/winmerge/issues/50)
* バイナリファイル、画像ファイル比較時に内容が一致している場合は、テキストファイル比較時と同様に「選択されたファイルは同一です」のメッセージボックスを表示するようにした
* CompareMSExcelFiles.sct プラグイン: ワークシートを画像化するとき、行数が多ければ画像ファイルを分割するようにした。
* 画像比較: 設定した背景色がWinMerge再起動時後に別の色になっていた問題を修正
* 画像比較: ヘッダーバーのテキストが選択できない問題を修正

### 2016/07/29 2.14.0-jp-113

* VirusTotal チェック結果: 
    						[32bitインストーラ](https://www.virustotal.com/ja/file/d9e014106ceb9ebe7caa6d18be9765915e0c6430fe102935084ad6f0c1b20520/analysis/1469367602/),
    						[64bitインストーラ](https://www.virustotal.com/ja/file/5cbc59eb8e76b3025d9a2b13a48798f15eef758968a8c5f9e0bd069c39bba1e7/analysis/1469367616/),
    						[32bit-zip](https://www.virustotal.com/ja/file/646aa67ca5568abbaca39431da085da6a4d85c7120013074279c0343b6155c66/analysis/1469368666/),
    						[64bit-zip](https://www.virustotal.com/ja/file/ac9e3f37fdbb23a53d4a7d383425e5d0070bf2d7e9acbb81b73a9eb360d8cd64/analysis/1469368788/)
* 「ファイルまたはフォルダの選択」ウインドウで、参照ボタンを押すと「このプログラムを使用してこの場所を開けません。別の場所を試してください。」というメッセージが表示されることがある問題を修正
* Excelプラグイン等を使用して比較しようとするとWinMergeが異常終了することがある問題を修正
* Windows Vista や 7 でメニューセパレータが描画されなくなった問題を修正
* メッセージボックスで表示する文字のフォントや色をTaskDialog的な表示に変更

### 2016/06/29 2.14.0-jp-110

* VirusTotal チェック結果: 
    						[32bitインストーラ](https://www.virustotal.com/en/file/0d776e2fdbaf2f3d610a52ccde204136a4650214685cd68ee06cbafde79b82e2/analysis/1466913791/),
    						[64bitインストーラ](https://www.virustotal.com/en/file/c78905a420322738aa1b5c10e048c4766e8ba4f7b7f5603623ca67838bd9824f/analysis/1466913805/),
    						[32bit-zip](https://www.virustotal.com/en/file/b263d1f2b8a04586bfb958a27398c437ae1b32414c2c06650249d26ac4fd681f/analysis/1466915225/),
    						[64bit-zip](https://www.virustotal.com/en/file/971b51ad668c6c891d43726c19c3f5953d1c4a4a07432940f09ad749fe58a8a2/analysis/1466915244/)
* ご連絡いただいた以下の問題を修正
    * フィルタで無視されるフォルダが片側しかない場合に一覧に表示されてしまう。
    * [ファイル]-[開く...] のダイアログの比較するファイルまたはフォルダのパスコンボボックスで、同じフォルダパスでも後ろに\があるものとないものがダブって登録される。[\#48](https://bitbucket.org/winmerge/winmerge/issues/48/)
    * [ヘルプ]→[更新を確認]を無効化したい。(レジストリキー `HKEY_CURRENT_USER\SOFTWARE\Thingamahoochie\WinMerge\CheckForUpdates\CurrentVersionURL` の値を空文字列にしたとき、「更新を確認」メニューを無効にするようにしました。)
    * 高DPI環境では、ツールバーのアイコンが小さすぎる。([表示]→[ツールバー]→[特大]を追加しました)
* WindowsXP上で比較できない問題を修正。(https://connect.microsoft.com/VisualStudio/feedback/details/1600505/stat-not-working-on-windows-xp-using-v14-xp-platform-toolset-vs2015 の問題だったため、VisualStudio2013でビルドするように戻しました。)
* メニューを Theme API を使用して描画するようにした。
* リストビューの列幅等がDPIに影響されないようにした。
* CompareMSPowerPointFiles.sct プラグイン: 設定ダイアログのタイトルが間違っていたのを修正。

### 2016/05/29 2.14.0-jp-106

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/ja/file/45e6f1f349fd7028bd5277556e1a81582b300fdabe84ea823c343c0a59410c91/analysis/1464520429/),
  [64bitインストーラ](https://www.virustotal.com/ja/file/3e6033e6c04e5450a3a79164da4c85db69ec3fd385e40f3e177c075c285a3d26/analysis/1464520516/),
  [32bit-zip](https://www.virustotal.com/ja/file/fbcff56e4063abb67ead8e27c231da7b275d2323c561c561a9aae229b8ee3c5b/analysis/1464521433/),
  [64bit-zip](https://www.virustotal.com/ja/file/cb39253e3a988f151ad8886ea695a2f021d2e2f27b4a50b21274547215be099e/analysis/1464521443/)
* ご連絡いただいた以下の問題を修正
    * フォルダ比較: 「リパースポイントを無視する」にチェックを入れてもリパースポイントが無視されたフォルダにならず、同一フォルダとなる
    * フォルダ比較: フォルダ比較ウインドウからファイル比較ウインドウを開き、ファイル比較ウインドウを閉じないまま、フォルダ比較ウインドウで別フォルダに移動するとクラッシュする。
    * ファイル比較: UTF-8 と認識してほしいファイルがShiftJISと認識される。(UTF-8検出を優先するようにしました)
    * 「コメントの差異を無視する」の機能で無視されないことがあるケースがある。 [\#41](https://bitbucket.org/winmerge/winmerge/issue/41)
    * エンコードのみ異なるファイルを検知できるようしてほしい。([設定]メニュー→[一般]カテゴリに[コードページの違いを無視する]チェックボックスを追加しました。)[\#43](https://bitbucket.org/winmerge/winmerge/issue/43)
    * 複数の同期ポイントを追加した後に、 「元に戻す」をすると同期ポイントの位置がおかしくなることがある。[\#45](https://bitbucket.org/winmerge/winmerge/issue/45)
    * レジストリキー `HKEY_CURRENT_USER\SOFTWARE\Thingamahoochie\WinMerge\Settings\MRU_Max` で最近使用したプロジェクトファイルと最近使用したファイルまたはフォルダの履歴の数を増やせるようにした。ただし、最近使用したファイルまたはフォルダの履歴の数を増やすには合わせて、ジャンプリストの最大数 `HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Advanced\JumpListItems_Maximum` も変更する必要があります。[\#46](https://bitbucket.org/winmerge/winmerge/issue/46)
    * CompareMSExcelFiles.sct プラグイン: xltx, xltm 拡張子のファイルがプラグインで比較されない。
    * パワーポイント比較用プラグインを追加してほしい。(CompareMSPowerPointFiles.sct を追加しました)
    * フォルダ比較: ツリー表示時に選択したフォルダ以下を別タブで比較したい。(フォルダを選択し、Ctrlキーを押しながら右クリックメニューの[比較]を選択すると、別タブにてフォルダ比較されるようにしました。)
* Visual Studio Community 2015 でビルドするようにした。
* アーカイブサポートで使用する7-zipのバージョンを9.20から16.02に更新
* NUL文字を含むファイルを比較するとNUL文字を改行とみなしてしまうことがある問題を修正。
* CompareMSExcelFiles.sct: 数式比較の高速化
* CompareMSExcelFiles.sct, CompareMSWordFiles.sct プラグイン: グループ化した図形内のテキストが比較されない問題を修正。
* 「ファイルまたはフォルダの選択」ウインドウに「読み取り専用」チェックボックスを追加
* [設定]メニュー→[フォルダ]カテゴリに[サブフォルダを含む]を追加(ファイルまたはフォルダの選択画面の[サブフォルダを含む]と同じです)

### 2016/01/29 2.14.0-jp-99

* VirusTotal チェック結果: 
    						[32bitインストーラ](https://www.virustotal.com/ja/file/22d7445be6f4c0a3b58cb6a42af33b4232ae925f130ad1790c8da1eb76143f60/analysis/1454077518/),
    						[64bitインストーラ](https://www.virustotal.com/ja/file/8ea9d64ae84f90c5f9941d3d3f4f10f9d141afcbe3e69969d4f3a96f2e6680a0/analysis/1454077532/),
    						[32bit-zip](https://www.virustotal.com/ja/file/7c797af03c8e2e89657044618a98e218320a3166a7fbb23c415c2c809fb23c96/analysis/1454078091/),
    						[64bit-zip](https://www.virustotal.com/ja/file/5863ef12f2293729991462e5e458ac06f3209aef19b7648382b64194b8b4572b/analysis/1454078098/)
* ご連絡いただいた以下の問題を修正
    * フォルダ比較: ファイル比較と同様に左右を入れ替えられるようにしてほしい。([表示]メニュー→[ペインの交換]メニューを追加しました)
    * フォルダ比較: １つのファイルのみを含むフォルダを比較するとハングアップする。
    * フォルダ比較: ファイルを削除すると動作が不安定になる。
    * シェルエクステンション: WindowsXP上ではエクスプローラの右クリックメニューが日本語化されない。
* 一部のアイコンで高DPI環境用を用意した。(ツールバーのアイコンが小さい場合は、[表示]メニュー→[ツールバー]→[大]を選択してください)

### 2015/12/30 2.14.0-jp-95

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/ja/file/23b9c615138365ccb4d39aca81a6dd7874e7441d14bcc53ffaa0ff05214931ee/analysis/1451428509/),
  [64bitインストーラ](https://www.virustotal.com/ja/file/9e959b317f4690ab8b1612ce8f9056f7609970c8bed48ebfae7b336e8a4f9457/analysis/1451428529/),
  [32bit-zip](https://www.virustotal.com/ja/file/b1ddc622ee6e7287b51b5f988b22f7c5f6f11b688c0bcac125ce658ec361d713/analysis/1451403482/),
  [64bit-zip](https://www.virustotal.com/ja/file/da21f6ab6c6586db58c12e9bbd89c9877670a014e265798d6e85d18dc355bc90/analysis/1451403485/)
* ご連絡いただいた以下の問題を修正
    * [ツール]→[パッチの生成]メニューで生成されるパッチのHTMLスタイル出力で sans-serif の変わりに monospace フォントを使用してほしい。
    * フォルダ比較ウインドウ: 右クリックメニュー→[コピー]→[左を...]または[右を...]でファイルをコピーするとき、フォルダ構造そのままにコピーされなくなった。
    * フォルダ比較ウインドウ: 片方しか存在しないファイルの名前が変更できなくなっている。
* エクスプローラの右クリックメニューのWinMergeのアイコンを高DPI環境でもきれいに表示されるようにした。 

### 2015/11/29 2.14.0-jp-92

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/ja/file/63c61e6e964480bdd16227fafda9d10d941ac2500ab212eeacd49771e1911fdd/analysis/1448759504/),
  [64bitインストーラ](https://www.virustotal.com/ja/file/f9b038895704b356ad75f6763c6157b092400a86a7e7983c2aaacbe538338aed/analysis/1448759513/),
  [32bit-zip](https://www.virustotal.com/ja/file/1badf45893f92fdc85ed9b01a800ae187cb527badcc2480ee4eff6aacfad0ede/analysis/1448760236/),
  [64bit-zip](https://www.virustotal.com/ja/file/e3967e37036de7f33ffb362165017a008c01e9af08985828627e87a8faa74d38/analysis/1448761449/)
* ご連絡いただいた以下の問題を修正
    * ファイル比較レポートを含むフォルダ比較HTMLレポートが正常に生成されない。(～.filesフォルダ内に"C"等の空のファイルが作成され、このからファイルの代替データストリームにHTMLレポートが書き込まれていました。)
    * フォルダ比較ウインドウの[簡易結果表示]列の内容が間違っている。
* ファイル比較ウインドウ表示中に設定ウインドウでOKボタンをクリックすると異常終了する問題を修正

### 2015/10/29 2.14.0-jp-88

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/ja/file/c7c86fc339fcd30aedd721b946f630dde92f2a6c5b83df47cebc485997cc1ca4/analysis/1445890801/),
  [64bitインストーラ](https://www.virustotal.com/ja/file/2a6f2f457a2f37cbac906cde0cebaa5d0b164d05ab60fa14122cce108530df7e/analysis/1445891372/),
  [32bit-zip](https://www.virustotal.com/ja/file/d058f3f61cc7744ae4b7c33bda067f67a4561fafd1c0deb357fb93d7c844272d/analysis/1445890840/),
  [64bit-zip](https://www.virustotal.com/ja/file/a35582a233a940d64816b531f89105f4e72c2bae52539bd014ae26dad9ba2b27/analysis/1445891394/)
* ご連絡いただいた以下の問題を修正
    * 画像比較: 64bit版で画像を比較するとvcomp120.dllが存在しない環境ではエラーが発生する。(OpenMPのDLL vcomp120.dll を同梱するようにしました)
    * 3フォルダ比較時のコンテキストメニューに中央フォルダ・ファイル関連のメニューを追加してほしい。
    * WindowsのDPIを変更しても、マージウインドウのフォントの見た目のサイズが変わらず、ポイントサイズが変化してしまう。

* 画像比較: 右端または下端に差異があるとクラッシュすることがある。
* ツールバーの設定アイコンのドロップダウンメニューに「サブディレクトリを含む」を追加。このメニューの設定の変更は比較後でもF5キーで反映できます。  
* WindowsXPでWinMergeを実行する場合、パスバーにマウスポインタを移動すると、ファイルパスの表示が消えてしまう問題を修正。

### 2015/08/29 2.14.0-jp-84

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/ja/file/a315a52ebd0bebe2c263ab5afe056511faa436df3e6340dda4c4e87c4102e11d/analysis/1440775773/),
  [64bitインストーラ](https://www.virustotal.com/ja/file/91891c4f810e4eac409b833c132ddb927c7314b20c7572851847f58396eee4e0/analysis/1440775783/),
  [32bit-zip](https://www.virustotal.com/ja/file/676885fb15c21365d34f1ca476e6ca85b21afb78be5b36f9ed8b2ba9861e3bf0/analysis/1440814353/),
  [64bit-zip](https://www.virustotal.com/ja/file/e4cd8d92fe7b9553a7962930620f7d1507be9c7751054fb56010012b7eb2524d/analysis/1440814368/)
* ご連絡いただいた以下の問題を修正
    * PentiumIIIのマシンで動作しない。(32bit版ではSSE2の命令セットを使用しないようにしました。
        <s>PentiumIIIのマシンを持っていないので動作は確認できていませんがおそらく動作するのではないかと思います。</s>動作したとのご連絡をいただきました。)
* EXEやDLLにデジタル署名をするようにした。(ウィルススキャンソフトのfalse positive 判定を減らす目的で導入してみましたが...。なお、EVの付かないコードサイニング証明書なのでWindows8のスマートスクリーンには効果がないようです)
* 画像比較: [画像]メニュー→[前のページ]を選択すると画像が消えてしまう問題を修正
* 画像比較: ロケーションペインを追加
* Excelプラグイン: 一行目や、一列目のセルに値が存在しないシートでは一部のセルがテキスト化されなかった問題を修正
* Excelプラグイン: シートの画像化でセルの入力範囲によっては画像化されない図形要素があった問題を修正
* パッチ適用プラグイン: 実験的なパッチ適用プラグインを追加。このプラグインを使用するには、[プラグイン]メニュー→[自動展開]メニューをチェックし、拡張子が.diffか.patchのパッチファイルとパッチを適用するフォルダまたはファイルを比較します。(パッチの適用は実際には指定したフォルダに対して直接行われず、指定したフォルダ内のパッチ適用先ファイルを一時フォルダにコピーし、この一時フォルダに対して行われます。)
* プラグインの設定ウインドウでプラグイン個別に有効無効を指定できるようにした。
* [設定]メニュー→[システム]カテゴリ→[テンポラリファイルフォルダ]の｢カスタムフォルダ」で "%TEMP%\WinMerge" のように環境変数を指定できるようにした。
* [設定]メニュー→[シェル統合]カテゴリ→[「サブフォルダを含む」をデフォルトとする」チェックボックスを削除。
    						  エクスプローラのコンテキストメニューから再帰的にフォルダを比較したい場合は、[ファイル]メニュー→[開く]メニューで表示されるウインドウの「サブフォルダを含む」をチェックするようにしてください。
* Windows7でダイアログ上の文字のフォントサイズが大きすぎた問題がまだ改善していなかったのを修正。

### 2015/04/29 2.14.0-jp-80

<div style="color:red">
    <p>2015/04/29 またもや、バージョン 2.14.0+-jp-80 の64bit版インストーラが Norton360 で「SAPE.BitCoinMiner.3」が検出されるとご連絡があり、ダウンロードできないようにしています。(2014/04/26時点では問題なかったのですが...)。お騒がせして申し訳ございません。現在 False Positive Submission をしているところです。</p>
    <p>2015/05/02 パターンファイルを最新にしてもらえれば、検出されないようになったため、再度ダウンロードできるようにしています。</p>
</div>

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/en/file/9e54860696d39213c7caeb039070a5810617beb16cda0a413cb61cd0e695932d/analysis/1430049780/),
  [64bitインストーラ](https://www.virustotal.com/en/file/6995deff7f69062981b0ff1bb25b69b58559673e8c716650f9f51c1a67932d83/analysis/1430049794/),
  [32bit-zip](https://www.virustotal.com/en/file/3544a8d65337ecbb1205c98db9b2464c4be70b1cf601f656554c37860f1a8ace/analysis/1430228116/),
  [64bit-zip](https://www.virustotal.com/en/file/5f3f945da19a17d79dcbedce482c2906d0f660047b832d191c4911acc44c16fc/analysis/1430228120/)
* ご連絡いただいた以下の問題を修正
    * 正規表現を有効にして検索・置換を行う際に閉じられていない括弧など不正な正規表現を用いるとクラッシュする。
    * Windowsの画面設定によっては[設定]ウインドウ等でメッセージのいたるところがはみ出ることがある。
* フォルダ比較時、比較中のファイル名を表示するようにした。
* [編集]→[設定]→[シェル統合]カテゴリでエクスプローラの右クリックメニューにWinMergeを登録/登録解除できるようにした。(Zip版用)
* タブバーをフラット化
* 行フィルタに空行が設定されていた場合、全ての行にマッチしてしまうため、空行は無視するようにした。
* [ファイルまたはフォルダの選択]ウインドウで Ctrl+A によるテキスト全選択ができるようにした。
* 非再帰的にフォルダ比較後、フォルダ比較ウインドウ内のサブフォルダを再比較するとクラッシュする問題を修正。
* [編集]→[設定]→[一般]カテゴリの[複数の比較ウインドウを有効]を削除。(常に複数の比較ウインドウが有効)

### 2015/03/29 2.14.0-jp-77

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/en/file/702c3a24620821bd2b5077bfe66687ae08daa4b639520de1bd607b6f11291543/analysis/1427624863/),
  [64bitインストーラ](https://www.virustotal.com/en/file/4aa281ebb9df684de6fa091dddb69bdc0491e73d643c60d2de474c9e8a7ab82b/analysis/1427624872/),
  [32bit-zip](https://www.virustotal.com/en/file/57207b809cd3b28568e34e5a8a24fcf2bab19042aa5708f2341514178c46f781/analysis/1427625375/),
  [64bit-zip](https://www.virustotal.com/en/file/7a6af79638e8c9b1a99748c825e9ff10c0e194f1ce7c0c10ad1b472b78ead476/analysis/1427625380/)
* ご連絡いただいた以下の問題を修正
    * 「アーカイブサポートが無効」ウインドウでプラグインダウンロードのリンクをクリックするとWinMerge1.7インストーラがダウンロードされる。→ 7-zip のDLLを同梱し、「アーカイブサポートが無効」ウインドウそのものを不要にしました。
* 検索ダイアログを表示したまま、ファイル比較ウインドウを閉じるとクラッシュする問題を修正
* 64bit版でたまにメニューの幅が狭くなることがある問題を修正
* アーカイブサポート用の 7-zip のDLLを同梱するようにした
* [ヘルプ]→[更新を確認]メニューを追加。最新版が存在するか確認できるようにした。(http://www.geocities.co.jp/SiliconValley-SanJose/8165/winmerge-jp_current_version.txt にアクセスしています)
* ダイアログウインドウのフォントとして Vista以上ならば メイリオフォントが使用されるようにした
* メニューの描画スタイルを変更
* メッセージボックスの描画スタイルをVista的なものに変更
* ステータスバーに表示されるメニュー項目の説明テキストを廃止し、配布サイズを削減した。(7-zipのDLLを同梱したので配布サイズは前のバージョンと比べて増えています。)

### 2015/02/28 2.14.0-jp-74

* VirusTotal チェック結果: 
  [32bitインストーラ](https://www.virustotal.com/ja/file/483cbda22ab869c367809ae99abfd814204a4b002a0d87e0e60cb9d68c278afd/analysis/1425049077/),
  [64bitインストーラ](https://www.virustotal.com/ja/file/89097942a900aa867f4448c76a6ace1558ce3e9173cce96f72e52624eba64fb1/analysis/1425049093/),
  [32bit-zip](https://www.virustotal.com/ja/file/e3c4342150c116b764f847d9dd4281f6df3e9e27d4ece14268aafe80ff1abe7e/analysis/1425075509/),
  [64bit-zip](https://www.virustotal.com/ja/file/e3b6694720c78f514af5bca0517f10459b3ad0d63ffe33525ec29d0707015690/analysis/1425049147/)
* ご連絡いただいた以下の問題を修正
    * フォルダ比較: 不安定なネットワークのサーバー上のフォルダを比較するとWinMergeがクラッシュすることがある。(こちらでは再現できていないため、効果があるかわかりませんが、対策を施してみています)
    * フォルダ比較: フォルダ比較後、一部のサブフォルダだけ再比較できるようにしてほしい。(右クリックメニューの「選択項目を再比較」で再比較できるようにしました)
    * プラグイン: 7-zipがインストールされていない場合、[展開プラグインで開く]メニュー等でプラグインを指定してもファイルを開くことができない。
* ドラッグ＆ドロップ: エクスプローラのZipフォルダ、Thunderbird, Firefox, Chrome, WinSCP, TortoiseSVNのリポジトリブラウザ 等からWinMergeへファイルやフォルダをドロップできるようになった。
* フォルダ比較: [編集]→[設定]→[シェル統合]カテゴリの「シェルメニューをコンテキストメニューに追加」チェックボックスを削除し、右クリックコンテキストメニューに「左側/右側シェルメニュー」が常に表示されるようにした。ただし、初回のコンテキストメニューの表示が遅くならないようにするため、クリックしたらシェルメニューを表示するようにした。(以前は、コンテキストメニューのサブメニューとして表示されていた)
* 使用頻度が低いと思われるため[表示]→[言語]メニューを廃止し、オプション画面の[一般]カテゴリで表示言語を選択できるようにした。
* バイナリエディタウインドウ: Undo＆Redoを実装
* バイナリエディタウインドウ: バイナリファイルとして指定した拡張子のファイルを比較したとき、直接バイナリエディタウインドウでファイルが開かれるようにした。
* バイナリエディタウインドウ: [編集]→[設定]メニュー→[比較/バイナリ]カテゴリでバイナリエディタウインドウ関連の設定ができるようにした。
* バイナリエディタウインドウ: メニューを日本語化
* バイナリエディタの単独実行版 frhed.exe, 画像比較 WinIMerge.exe をインストーラやZipから除外した。(WinMergeからは使用されていない)

### 2015/01/29 2.14.0-jp-68

* リリース前に(https://www.virustotal.com)のような複数のウィルス対策ソフトでチェックできるサービスを使用させていただくことにしました。

    <s>現在、残念ながら32bitZip版がQihoo 360という中国？のウィルス対策ソフトにのみ嫌われてしまっています(数日前までは問題なかったのですが...)。ダメもとで False Positive Submission をしてみています。</s>受け付けていただきました。検出状況: 
  [32bitインストーラ](https://www.virustotal.com/ja/file/786233636cfbe953aec2a489f6978fe2c03fa45e0328db10fdbb09ee6318b735/analysis/1422423401/),
  [64bitインストーラ](https://www.virustotal.com/ja/file/d0de8b4f89710ba11e6fca2f6a44c339450e7db55d7bec57f2a005dd39400a1d/analysis/1422423412/),
  [32bit-zip](https://www.virustotal.com/ja/file/71f9cd0e2b8cd7cb4f931ed40f1b13833d9b0d81341ba74b5dac956e94630afa/analysis/1422580833/),
  [64bit-zip](https://www.virustotal.com/ja/file/e96ea07ff5b6da28c58b29afae219aad8f5fa2c18ab5cafc122d7078ee3f90f2/analysis/1422422732/)

* ご連絡いただいた以下の問題を修正
    * フォルダ比較: フォルダ比較ウインドウ内でサブフォルダを選択して比較したとき、読み取り専用の指定が引き継がれない。
* フォルダ比較: 「大文字と小文字の違いを区別しない」等の比較オプションを一切無視して単純にファイルの内容を比較する「バイナリコンテンツ」比較方法を追加。バックアップしたフォルダとの比較を行う場合はこちらのほうが確実で高速です。(例えば、改行コードの違いを無視する設定でバイナリファイル内の0x0d(CR)が何らかの原因で0x0a(LF)に変わっていても差異なしとみなされることが防げます。)

    #### 参考: 各種フォルダ比較方法の違い

    比較方法             | ファイルの内容を比較 | ファイルのサイズを差異判定に使用 | ファイルの更新日付を差異判定に使用 | 差異数検出 | テキスト/バイナリ判定 | 文字コード検出/文字コードの違いを無視 | 大文字小文字の違い無視 | 空白の違い無視 | 改行コード検出/改行コードの違いを無視 | コメントの差異を無視 | 行フィルタ適用 | プラグイン適用 | 速度
    ---------------- | ------------------------- | ---------------------------------------- | -------------------------------------------- | ----------- | ----------------------- | ---------------------------------------------- | -------------------------- | ---------------- | ---------------------------------------------- | ------------------------- | ---------------- | ---------------- | --
    フルコンテンツ(default) | ○ | -  | -  | ○ | ○ | ○ | ○ | ○ | ○ | ○ | ○ | ○ | 低
    クイックコンテンツ      | ○ | -  | -  | -  | ○ | ○ | ○ | ○ | ○ | -  | -  | ○ | 低 
    _バイナリコンテンツ_    | ○ | ○ | -  | -  | -  | -  | -  | -  | -  | -  | -  | -  | 中 
    更新日時                | -  | -  | ○ | -  | -  | -  | -  | -  | -  | -  | -  | -  | 高 
    更新日時とサイズ        | -  | ○ | ○ | -  | -  | -  | -  | -  | -  | -  | -  | -  | 高 
    サイズ                  | -  | ○ | -  | -  | -  | -  | -  | -  | -  | -  | -  | -  | 高 

* フォルダ比較: 「更新日時」、「更新日時とサイズ」、「サイズ」の比較方法が3フォルダ比較に対応していなかったのを修正。
* フォルダ比較: ファイルの比較でエラーが発生したとき、そのファイルが比較結果の一覧に表示されないようになっていたのを修正。
* 画像比較: 画像比較用ライブラリ WinIMergeLib.dll が各社ウィルス対策ソフトに嫌われている状況を改善するため、内部で使用している [FreeImage library](http://freeimage.sourceforge.net/) をまだ未リリースの最新に更新。
* 画像比較: 片方が存在しない画像ファイルを開くと異常終了する問題を修正。
* Excel,Word プラグイン(`CompareMS*Files.sct`): VBScript内にファイルへの書き込み処理と WScript.Shell#Run によるプログラムの実行を行う処理の両方が記述されていると、あるウィルス対策ソフトがそのスクリプトを無慈悲にウィルスだと決めつけてしまうことが分かり、Excel, Wordプラグインが該当していたため、ごまかしの処理を追加。(WScript.Shell#Run は 設定画面をmshtaで表示するために使用しています)
* Excel,Word プラグイン(`CompareMS*Files.sct`): 設定ウインドウで「～複数に展開する」チェックボックスにチェックが入っていなくても、「ワークシートを画像化して比較する」等のチェックボックスにチェックが入れられるようにした。

### 2014/12/29 2.14.0-jp-65

* 2014/12/31 バージョン 2.14.0+-jp-65 の64bit版インストーラ(http://www.geocities.co.jp/SiliconValley-SanJose/8165/WinMerge-2.14.0-jp-65-x64-Setup.exe.zip) が Norton360 で「SAPE.BitCoinMiner.3」が検出されるとご連絡があり、現在、64bit版インストーラを `http://www.geocities.co.jp/SiliconValley-SanJose/8165/_WinMerge-2.14.0-jp-65-x64-Setup.exe.zip` にリネームしています。
  * こちらでは、
    * インストーラを作成しなおしても検出される
    * インストーラそのものを作成するソフトInnoSetup 5.5.4を再ダウンロード＆インストールしなおし、インストーラを生成しなおしても検出される
    * 実行ファイルWinMergeU.exe等インストールされるものには問題ない
    * インストーラスクリプト自体は前のバージョンと変わらない
    * 他社製ウィルススキャンソフトでは検出されないことから、誤検出と考えていますが、既にインストールされた方は、念のためお手数ですがウィルスチェックをお願いいたします。現在Symantec社に調査を依頼しています。

  * 2015/1/1 Kaspersky でも64bit版 WinIMergeLib.dll で「not-a-virus:Monitor.Win32.WebWatcher.bhh]が検出されるとご連絡いただきました。これも Kaspersky に問い合わせを行っています。

  * 2015/1/3 Nortonサポートに指示されたURL (https://submit.symantec.com/false_positive/) に問題のファイルを提出し、確認していただいた結果、現在ライブアップデートをしていだければ Norton で検出されないようになりました。

  * 2015/1/22 Kasperskyサポートより誤検出だというご連絡があり、現在 Kaspersky では 検出されなくなっています。
    しかし、検出情報が各社で共有されているのか、それともなにか嫌われやすいなんらかの要素が含まれているのかわかりませんが、
    [Virus Total](https://www.virustotal.com/ja/file/8a29ff491e83e33e8aa57ef006e398452838872029ea3c89739c754bda3f4f54/analysis/1421758245/)
    をみると McAfee や TrendMicro 等 5者からも嫌われており、かなり酷い状況で泣きそうです。
    このため、64bit版はこのままリネームした状態としておきます。
    どうしてもダウンロードしたい方は以下のURLからダウンロードしてください。

    * [\_WinMerge-2.14.0-jp-65-x64-Setup.exe.zip](http://www.geocities.co.jp/SiliconValley-SanJose/8165/_WinMerge-2.14.0-jp-65-x64-Setup.exe.zip)
    * [\_winmerge-2.14.0-jp-65-x64-exe.zip](http://www.geocities.co.jp/SiliconValley-SanJose/8165/_winmerge-2.14.0-jp-65-x64-exe.zip)

* ご連絡いただいた以下の問題を修正
    * 3つのファイルをHEX表示している状態で水平スクロールバーを操作すると異常終了する
* スプラッシュ画面を廃止
* 単語単位で置換しているにもかかわらず、単語ではないものも置換することがあった問題を修正
* ドキュメントの最後尾を置換すると異常終了することがあった問題を修正
* 3フォルダ比較でバイナリファイルとみなされているファイルに差異があるにも関わらず、同一と表示されてしまうことがある問題を修正
* 画像比較: Shift+カーソルキーまたは、Shift+Ctrl+カーソルキー で比較位置を調整できるようにした。(Ctrlキーを押した場合は8ピクセル単位で位置調整)

### 2014/11/29 2.14.0-jp-63

* ご連絡いただいた以下の問題を修正
    * UTF-8のファイルの先頭に同期ポイントを設置すると異常終了することがある。 [\#35](https://bitbucket.org/winmerge/winmerge/issue/35)
* Visual Studio Community 2013 でビルドするようにした。
* 実行ファイルのサイズを2MB程削減(VS2013によるMFCスタティックリンクサイズの改善、アイコンの圧縮、使用ライブラリ(Poco)の最適化ビルドによるもの)
* 展開プラグインの種類として"`FILE_FOLDER_PACK_UNPACK`"(ファイルを複数のファイルに展開)を追加
* 各プラグインの更新。プラグイン毎に設定画面を表示できるようにした。([プラグイン]メニュー→[プラグインの設定])


    ##### 設定が可能になったプラグイン

    プラグイン                   | 説明                                                                                  
    ----------------------- | ------------------------------------------------------------------------------------
    CompareMSExcelFiles.sct | Excelブック比較用プラグイン。図形要素内のテキストを比較するかどうか、VBAマクロを比較するかどうか、シートを画像化して比較するかどうか等が指定できるようになった。
    CompareMSWordFiles.sct  | Word文書比較用プラグイン。VBAマクロを比較するかどうか、ドキュメントをHTMLファイル化して画像も含めて比較するかどうか等が指定できるようになった。       
    IgnoreColumns.dll       | 指定した桁範囲の違いを無視するプラグイン。今まではファイル名に無視したい桁範囲を指定していたが設定ウインドウで指定できるようになった。                 
    IgnoreFieldsComma.dll   | CSV形式のファイルで指定した列範囲の違いを無視するプラグイン。上記と同様に設定可能                                          
    IgnoreFieldsTab.dll     | TSV形式(タブ区切り)のファイルで指定した列範囲の違いを無視するプラグイン。上記と同様に設定可能                                   

    Excelシートを画像化して比較したい場合は、比較する前に[プラグイン]メニュー→[プラグインの設定]→[CompareMSExcelFiles.sct]の行をダブルクリックして設定画面を表示、以下のように「ワークブックの情報を複数ファイルに展開する」と「ワークシートを画像化して比較する」にチェックを入れてください。(ただし、画像化して比較すると処理時間がかなりかかります)

### 2014/10/29 2.14.0-jp-59

* ご連絡いただいた以下の問題を修正
    * ファイル比較後にウインドウを最小化し、その後比較したファイルを別アプリケーションで更新した場合、WinMergeをアクティブにしようとすると、ファイルを読み込みなおすかを問うメッセージボックスが表示されるが、ボタンを押してもメインウインドウがアクティブにならない。
    * フォルダ比較ウインドウでフォルダを選択してCtrlキーを押しながら比較した場合、別タブで比較してほしい。
* 画像をマージ後ファイルを保存すると、保存はされるが表示上保存されたように見えない問題を修正。
* Windows 10 Technical Preview 上で実行すると、ウインドウの右側に余分なスペースが表示されてしまう問題を対策。
* フォルダ比較レポート生成中に異常終了することがあった問題を修正。
* ファイル比較のHTMLレポートのファイルサイズを削減。
* ファイル比較のHTMLレポートをブラウザで表示したとき、TABキーで差異行に移動できるようアンカーを設置。
* フォルダ比較のHTMLレポートにアイコンが表示されるようにした。(※IE8未満ではアイコンは表示されません)
* 画像比較のHTMLレポートがChromeで正しく表示されない問題を修正。

### 2014/09/29 2.14.0-jp-56
* ご連絡いただいた以下の問題を修正
    * タブバーのタブをドラッグして移動できるようにしてほしい
* 起動速度を若干改善
* Hexビューで[ファイル]メニュー→[再読込み]が使えるようにした。
* Ctrl+0 キー に拡大縮小率を元に戻す機能を割り当てた。
* 簡易的な画像比較・マージ機能を実装

### 2014/08/29 2.14.0-jp-51

* ご連絡いただいた以下の問題を修正
    * [オプション]ダイアログ→[色/シンタックス]カテゴリの[デフォルト]ボタンの一部が欠けて表示されることがある。
* 外観を少しフラットな感じにした。

### 2014/07/29 2.14.0-jp-49

* ご連絡いただいた以下の問題を修正
    * タブバーのタブ数が多くなった時、タブ幅を自動的に狭くするのはやめてほしい。(タブの右クリックメニューに[タブ幅の自動調整を有効にする]を追加し、無効にできるようにしました。)
    * HEXモードで再表示できるメニューを追加してほしい。([ファイル]メニュー→[形式を比較して再比較]を追加) [\#33](https://bitbucket.org/winmerge/winmerge/issue/33)
    * 3つのファイルをHEXモードで表示するとヘッダーバーが正しく表示されない等問題がある。 [\#34](https://bitbucket.org/winmerge/winmerge/issue/34)
* Vista以上?(Windows7?)であれば、7-zipがインストールされていなくても、Windowsの機能を使用して .zipファイルを比較できるようにした。この修正により、c:\tmp\file.zip\folder のように .zip ファイル内のフォルダを直接指定しても比較できるようになった。更に、Windows8以上?であれば、 ftp://username:password@hostname/dir の形式でFTPサーバー上のフォルダも比較できるようになった。
* NUL文字を含むファイルを保存すると、NUL文字が失われてしまう問題を修正。
* コードページダイアログに1200(UNICODE)を追加。

### 2014/06/29 2.14.0-jp-45

* 付属のMS-Word比較プラグインをフォルダ比較時に並列動作させるとテキスト化されるドキュメントプロパティ関連情報が不安定になってしまうため、
    						同じ内容でも差異が現れてしまう事があった問題を修正。(ドキュメントプロパティ情報のテキスト化を断念しています)
* タブバー上のアイコンがぼやけていたのを修正(なぜかアイコンを24bitから32bit colorにすることで解決)
* タブバー上にマウスカーソルを移動した時、クローズボタンを表示するようにした。

### 2014/05/29 2.14.0-jp-43

* ご連絡いただいた以下の問題の修正
    * [編集]メニュー→[設定]→[色/シンタックス]カテゴリの[太文字]をチェックしても、次回起動時にチェックが外れてしまう
    * 展開プラグインを有効にしてフォルダを比較するとエラーダイアログが表示されることがある
    * ファイル比較ウインドウで正規表現の検索文字列「`(.*)`」を指定して置換すると想定通りの結果とならない
    * 3バイト以下のファイルを比較前処理プラグインを使用して比較するとクラッシュすることがある
* タブと全角文字を含む行をクリックすと想定外の位置にカレットが移動してしまうことがある問題を修正
* 行内差異の中の文字もシンタックスハイライトを有効にできるようにチェックボックスを[編集]メニュー→[設定]→[色/差異]カテゴリに追加
* アイコンの変更

### 2014/04/29 2.14.0-jp-38

* ご連絡いただいた以下の問題の修正
    * Mac OS X Mavericksのファイル共有 (SMB)機能で公開されたフォルダの中に32個以上のファイルが存在する場合、
* フォルダ比較後、「大文字と小文字を区別する」等の比較オプションを変更し、F5キー等で再比較したとき、比較結果にオプションの変更が反映されていない問題を修正
* フォルダ比較(サイズ、更新日付・サイズ、更新日付比較方法)の高速化

### 2014/03/29 2.14.0-jp-37

* 空白の比較方法を「変更を無視する」としていた場合、差異がない行を差異があると表示してしまうことがあった問題を修正。(2.13.22+-jp-1から発生してしまったバグで1年以上気付かなかったのは申し訳ないです...)
* ご連絡いただいた以下のご要望を実装
    * タブバーの各タブに比較結果がわかるようにアイコンで表示してほしい
    * [ファイル]メニューに最近使用したファイルやフォルダを表示してほしい(Windows7のジャンプリストの履歴から情報を取得しているため、XPでは履歴は表示されません)
    * ファイル比較ウインドウで検索するとき、検索ダイアログを閉じなくできるようにしてほしい
    * フォルダ比較を実行する際は、一方しか無いファイルよりも両方存在するファイルを優先的に比較してほしい
      (まだ現段階ではサブフォルダがある場合はサブフォルダ内の比較を優先してしまうため、サブフォルダがない場合に効果あり)
* ツールバーの[オプション]アイコンにドロップダウンメニューを追加し、フォルダ比較方法や空白の比較方法等を選択できるようにした(ご要望の変形)
* タブバーのタブ数が多くなった場合、自動的にタブ幅を小さくするようにした(ご要望の変形)
* フォルダ比較時に表示されるステータスバーに現在の比較方法(フルコンテンツ、クイックコンテンツなど)を表示するようにした(ご要望の変形)

### 2014/02/28 2.14.0-jp-33

* ご連絡いただいた以下の問題の修正
    * 3-way merge するとき、ファイルの文字コードの変更や改行コードの変更がマージされない。[\#29](https://bitbucket.org/winmerge/winmerge/issue/29)
    * ファイル比較ウインドウで行カーソルを表示してほしい。(設定項目をあまり増やしたくなかったので、常に行カーソルが表示されますが、表示してほしくない人が現われればON/OFF可能にします。)
    * 「ファイルまたはフォルダの選択」ウインドウでAlt+Iなどのアクセスキーが機能しなくなった。
* インストーラでTortoiseSVN/GIT用の3-way mergeツールとして登録するかどうかを選択できるようにした。
* 「ファイルまたはフォルダの選択」ウインドウに左側と右側のファイル交換ボタンを追加。
* ファイル比較ウインドウでサロゲートペア文字の扱いを改善。
* 差異がある行でもシンタックスハイライトを有効にするチェックボックスを[編集]メニュー→[設定]→[色/差異]カテゴリに追加。
* BitbucketやGitHub的な色遣いに変更するボタンを[編集]メニュー→[設定]→[色/差異]カテゴリに追加。
* Ctrlキーを押しながらフォルダをWinMergeにドラッグ＆ドロップすると再帰的なフォルダ比較が実行され、
  Ctrlキーを押さなければ再帰的なフォルダ比較は行われなかったが、
  Ctrlキーを押さずにドラッグ＆ドロップした場合、前回の設定でフォルダ比較するようにした(記述忘れ 2014-03-29追記)

### 2014/01/29 2.14.0-jp-29

* ご連絡いただいた以下の問題の修正
    * 数十万単位のファイルがあるフォルダを比較するとメモリを消費しすぎる。(いままでの半分以下程度にしてみました)
* コマンドラインから相対パスで指定されたファイルを編集して保存するとバックアップファイルの作成に失敗したと表示される問題を修正
* 3つのファイル比較時、「次/前の中央のみの差異(Alt+8)」で中央のみの差異(左側と右側が一致)以外の箇所にも移動することがあった問題を修正
* Shift+F4キーで前の行内差異に移動できるようにした。
* 3つのファイル比較時、見やすさのため、左側と右側のペインでは中央のペインとの行内差異がない個所には色付けしないようにした
* 3つのファイル比較時、Location Pane でコンフリクトしている箇所が分かるようにバーの間を赤でで色付けするようにした。また、差異がある箇所で隣のペインとテキストが一致している場合は黄色、中央のみ異なる(左側と右側が一致)場合は、水色で色付けするようにした。
* 3つのファイル比較時に使用できる「次のコンフリクト」、「前のコンフリクト」、「自動マージ」メニューを追加
* 「左からコピー(Alt+Shift+Right)」、「右からコピー(Alt+Shift+Left)」を右クリックメニューに追加
* 「左から中央にコピー(Alt+4)」、「右から中央にコピー(Alt+6)」メニューを廃止。上記「左からコピー(Alt+Shift+Right)」、「右からコピー(Alt+Shift+Left)」をかわりに使用してください
* コマンドラインオプション /fl  (起動時、左側ペインにフォーカスを当てる), /fm (起動時、中央ペインにフォーカスを当てる), /fr (起動時、右側ペインにフォーカスを当てる) を追加
* コマンドラインオプション /al  (起動時、左側ペインで自動マージ), /am (起動時、中央ペインで自動マージ), /ar (起動時、右側ペインで自動マージ) を追加
