// WinTab.NET v1.2
//      Copyfight 2006 by l.p.m.11
//
// -v0.1 : first alpha release
//      programmed by l.p.m.11  : '06/01/06
// -v0.02 (file version:1.2.0)
//		                        : '06/01/07
//  v1.30 (file version:1.3.0) : first stable release
//                              : '06/01/10
//
//  *Note
//    You must compile with /unsafe option.
//
//  -wintab.h : copyright 1991-1998 by LCS/Telegraphics.
//  -thanks:
//      http://www9.plala.or.jp/herm/Pages/Localized/WinTab/
//

// Stub....
// #define WINTAB_DYNAMIC

using System;
using System.Collections;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace WinTabDotnet {
    using HCTX      =   UInt32;
    using BOOL      =   Int32;
    
    // --------------------------------------------------------------------------
    // Messages, Constants

    /// <summary>
    /// WinTabDotnetŎgpONXB
    /// </summary>
    [Serializable()]
    public class WinTabException : Exception {
        /// <summary>
        /// VWinTabONX𐶐܂B
        /// </summary>
        public WinTabException() : base("WinTab internal exception occured.") {}

        /// <summary>
        /// VWinTabONX𐶐܂B
        /// </summary>
        /// <param name="es">O̐</param>
        public WinTabException(string es) : base(es) {}
    }

    /// <summary>
    /// WinTabbvC̃NXB
    /// <remarks>
    /// WinTabg߂ɕKvȊ֐AWinTab32.DLL̊֐A萔AvpeBlSĒ`Ă܂B
    /// [ÚÃNXgpăy^ubgɊւ𓾂邱Ƃł܂B
    /// </remarks>
    /// </summary>
    public static partial class WinTab {
        public const int WT_DEFBASE         = 0x7FF0;
        public const int WT_MAXOFFSET       = 0xF;

        /// <summary>pPbg̓bZ[W</summary>
        public const int WT_PACKET          = WT_DEFBASE + 0;
        public const int WT_CTXOPEN         = WT_DEFBASE + 1;
        public const int WT_CTXCLOSE        = WT_DEFBASE + 2;
        public const int WT_CTXUPDATE       = WT_DEFBASE + 3;
        public const int WT_CTXOVERLAP      = WT_DEFBASE + 4;
        public const int WT_PROXIMITY       = WT_DEFBASE + 5;
        public const int WT_INFOCHANGE      = WT_DEFBASE + 6;
        /// <summary>J[\̒ǉbZ[W</summary>
        public const int WT_CSRCHANGE       = WT_DEFBASE + 7;
        public const int WT_MAX             = WT_DEFBASE + WT_MAXOFFSET;

        public const int LCNAMELEN          = 40;
        public const WTPKT WTPKT_ALL =
            WTPKT.CONTEXT | WTPKT.STATUS | WTPKT.TIME | WTPKT.CHANGED | WTPKT.SERIAL_NUMBER | 
            WTPKT.CURSOR | WTPKT.BUTTONS | WTPKT.X | WTPKT.Y | WTPKT.Z |
            WTPKT.NORMAL_PRESSURE | WTPKT.TANGENT_PRESSURE;
    };

    // --------------------------------------------------------------------------
    // COMMON DATA DEFS

    /// <summary>
    /// CxgpPbgɂAX̃IvVf[^ACȇ\rbgtB[hB
    /// </summary>
    [Flags]
    public enum WTPKT : uint /* DWORD */ {
        /// <summary>ReLXg̃nh</summary>
        CONTEXT				= 0x0001,
        /// <summary></summary>
        STATUS				= 0x0002,
        /// <summary>pPbg</summary>
        TIME				= 0x0004,
        /// <summary>ύXꂽpPbgACe</summary>
        CHANGED				= 0x0008,
        /// <summary>pPbg̃VAԍ</summary>
        SERIAL_NUMBER   	= 0x0010,
        /// <summary>pPbg𐶐J[\</summary>
        CURSOR				= 0x0020,
        /// <summary>{^</summary>
        BUTTONS				= 0x0040,
        /// <summary>XW</summary>
        X					= 0x0080,
        /// <summary>YW</summary>
        Y					= 0x0100,
        /// <summary>ZW</summary>
        Z					= 0x0200,
        /// <summary>M</summary>
        NORMAL_PRESSURE		= 0x0400,
        /// <summary>ږʕM</summary>
        TANGENT_PRESSURE	= 0x0800,
        /// <summary>J[\̕</summary>
        ORIENTATION			= 0x1000,
        /// <summary>J[\̊px</summary>
        ROTATION            = 0x2000
    };

    // --------------------------------------------------------------------------
    // INFO DATA DEFS

    /// <summary>f[^B</summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct AXIS {
        /// <summary>Wlf[^ACe̍ŏl</summary>
        public int      axMin;
        /// <summary>Wlf[^ACe̍ől</summary>
        public int      axMax;
        /// <summary>f[^ACe̕\̌vZɎgpꂽP</summary>
        public uint     axUnits;
        /// <summary>PʂƂɑf[^ACel킷Œ菬_</summary>
        public Int32    axResolution;
    };

    /// <summary>\B</summary>
    public enum UnitSpecifies {
        /// <summary>IȒPʂł͕\擾łȂ\</summary>
        NONE        = 0,
        /// <summary>C`Pʂ̕\擾\</summary>
        INCHES      = 1,
        /// <summary>Z`[gPʂ̕\擾\</summary>
        CENTIMETERS = 2,
        /// <summary>1]̌ʕ̕\擾\</summary>
        CIRCLE      = 3
    };

    /// <summary>}EX{^ANVB</summary>
    public enum SystemButton {
        NONE		= 0x00,
        LCLICK		= 0x01,
        LDBLCLICK	= 0x02,
        LDRAG		= 0x03,
        RCLICK		= 0x04,
        RDBLCLICK	= 0x05,
        RDRAG		= 0x06,
        MCLICK		= 0x07,
        MDBLCLICK	= 0x08,
        MDRAG		= 0x09,

        // For pen windows
        PTCLICK		= 0x10,
        PTDBLCLICK	= 0x20,
        PTDRAG		= 0x30,
        PNCLICK		= 0x40,
        PNDBLCLICK	= 0x50,
        PNDRAG		= 0x60,
        P1CLICK		= 0x70,
        P1DBLCLICK	= 0x80,
        P1DRAG		= 0x90,
        P2CLICK		= 0xA0,
        P2DBLCLICK	= 0xB0,
        P2DRAG		= 0xC0,
        P3CLICK		= 0xD0,
        P3DBLCLICK	= 0xE0,
        P3DRAG		= 0xF0
    };

    /// <summary>n[hEFA\͂\tOB</summary>
    [Flags]
    public enum HardwareCapabilities {
        /// <summary>fBXvCƃfW^CUT[tFCXL鎖</summary>
        INTEGRATED		= 0x0001,
        /// <summary>J[\Aʒu񍐂foCXƕIɐڐG邱Ƃ</summary>
        TOUCH			= 0x0002,
        /// <summary>J[\̕IȌm͈͂ɂāAߕt藣ꂽ肷Cxg𐶐鎖\ł邱Ǝ</summary>
        HARDPROX		= 0x0004,
        /// <summary>n[hEFAɂăANeBuJ[\ƂēƎɎʂ\ł邱Ǝ</summary>
        PHYSID_CURSORS	= 0x0008 /* 1.1 */
    };

    /// <summary>J[\\͂\tOB</summary>
    [Flags]
    public enum CursorCapabilities {
        /// <summary>P̂̕IȃJ[\̊e[ĥ̂ЂƂ\J[\`</summary>
        MULTIMODE	= 0x0001, /* 1.1 */
        /// <summary>\tgEFAɂĎʂ鎖łȂA̕J[\̃J[\`</summary>
        AGGREGATE	= 0x0002, /* 1.1 */
        /// <summary>]̕J[\\J[\`</summary>
        INVERT		= 0x0004  /* 1.1 */
    };

    /// <summary>
    /// JeSAWT_InfoĂяoɎgpB
    /// </summary>
    public enum InfoCategory : uint {
        /// <summary>WinTabgp\`FbNꍇɗp</summary>
        NONE        = 0,
        /// <summary>O[oC^tF[Xʎqє\͏</summary>
        INTERFACE   = 1,
        /// <summary>C^tF[X\[X̎gpv</summary>
        STATUS      = 2,
        /// <summary>ftHgfW^CÛ߂̘_ReNXg</summary>
        DEFCONTEXT  = 3,
        /// <summary>WIȃVXe_ReNXg</summary>
        DEFSYSCTX   = 4,
        /// <summary>foCX̔\͂ԏ</summary>
        DEVICES     = 100,
        /// <summary>J[\`̋@\ԏ</summary>
        CURSORS     = 200,
        /// <summary>foCX̊g@\ɂĂ̏</summary>
        EXTENSIONS  = 300,
        /// <summary>ftHgfW^CÛ߂̘_ReNXg</summary>
        DDCTXS      = 400,
        /// <summary>ftHgVXe_ReNXg</summary>
        DSCTXS      = 500
    };

    /// <summary>
    /// CfbNXAWT_InfoĂяoɎgpB
    /// </summary>
    public struct InfoIndex {
        /// <summary>O[oC^tF[Xʎqє\͏</summary>
        public enum INTERFACE {
            WINTABID		= 1,
            SPECVERSION		= 2,
            IMPLVERSION		= 3,
            NDEVICES		= 4,
            NCURSORS		= 5,
            NCONTEXTS		= 6,
            CTXOPTIONS		= 7,
            CTXSAVESIZE		= 8,
            NEXTENSIONS		= 9,
            NMANAGERS		= 10,
            MAX				= 10
        }

        /// <summary>C^tF[X\[X̎gpv</summary>
        public enum STATUS {
            CONTEXTS		= 1,
            SYSCTXS			= 2,
            PKTRATE			= 3,
            PKTDATA			= 4,
            MANAGERS		= 5,
            SYSTEM			= 6,
            BUTTONUSE		= 7,
            SYSBTNUSE		= 8,
            MAX				= 8
        }

        /// <summary>WIȃVXe_ReNXg</summary>
        public enum CONTEXT {
            NAME		= 1,
            OPTIONS		= 2,
            STATUS		= 3,
            LOCKS		= 4,
            MSGBASE		= 5,
            DEVICE		= 6,
            PKTRATE		= 7,
            PKTDATA		= 8,
            PKTMODE		= 9,
            MOVEMASK	= 10,
            BTNDNMASK	= 11,
            BTNUPMASK	= 12,
            INORGX		= 13,
            INORGY		= 14,
            INORGZ		= 15,
            INEXTX		= 16,
            INEXTY		= 17,
            INEXTZ		= 18,
            OUTORGX		= 19,
            OUTORGY		= 20,
            OUTORGZ		= 21,
            OUTEXTX		= 22,
            OUTEXTY		= 23,
            OUTEXTZ		= 24,
            SENSX		= 25,
            SENSY		= 26,
            SENSZ		= 27,
            SYSMODE		= 28,
            SYSORGX		= 29,
            SYSORGY		= 30,
            SYSEXTX		= 31,
            SYSEXTY		= 32,
            SYSSENSX	= 33,
            SYSSENSY	= 34,
            MAX			= 34
        }

        /// <summary>foCX̔\͂ԏ</summary>
        public enum DEVICE {
            NAME			= 1,
            HARDWARE		= 2,
            NCSRTYPES		= 3,
            FIRSTCSR		= 4,
            PKTRATE			= 5,
            PKTDATA			= 6,
            PKTMODE			= 7,
            CSRDATA			= 8,
            XMARGIN			= 9,
            YMARGIN			= 10,
            ZMARGIN			= 11,
            X				= 12,
            Y				= 13,
            Z				= 14,
            NPRESSURE		= 15,
            TPRESSURE		= 16,
            ORIENTATION		= 17,
            ROTATION		= 18,
            PNPID			= 19,
            MAX				= 19
        }

        /// <summary>J[\`̋@\ԏ</summary>
        public enum CURSOR {
            NAME			= 1,
            ACTIVE			= 2,
            PKTDATA			= 3,
            BUTTONS			= 4,
            BUTTONBITS		= 5,
            BTNNAMES		= 6,
            BUTTONMAP		= 7,
            SYSBTNMAP		= 8,
            NPBUTTON		= 9,
            NPBTNMARKS		= 10,
            NPRESPONSE		= 11,
            TPBUTTON		= 12,
            TPBTNMARKS		= 13,
            TPRESPONSE		= 14,
            PHYSID			= 15,
            MODE			= 16,
            MINPKTDATA		= 17,
            MINBUTTONS		= 18,
            CAPABILITIES	= 19,
            MAX				= 19
        }

        /// <summary>foCX̊g@\ɂĂ̏</summary>
        public enum EXTENSION {
            NAME		= 1,
            TAG			= 2,
            MASK		= 3,
            SIZE		= 4,
            AXES		= 5,
            DEFAULT		= 6,
            DEFCONTEXT	= 7,
            DEFSYSCTX	= 8,
            CURSORS		= 9,
            MAX			= 109
        }
    };

    // --------------------------------------------------------------------------
    // CONTEXT DATA DEFS

    /// <summary>
    /// ^ubgReNXg̒`ɕKvȑێ\́B
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    unsafe public struct LOGCONTEXT {
        public fixed char    lcName[WinTab.LCNAMELEN];
        public ContextOption lcOptions;
        public uint	    lcStatus;
        public uint	    lcLocks;
        public uint	    lcMsgBase;
        public uint	    lcDevice;
        public uint	    lcPktRate;
        public WTPKT	lcPktData;
        public WTPKT	lcPktMode;
        public WTPKT	lcMoveMask;
        public uint	    lcBtnDnMask;
        public uint	    lcBtnUpMask;
        public int	    lcInOrgX;
        public int	    lcInOrgY;
        public int 	    lcInOrgZ;
        public int 	    lcInExtX;
        public int 	    lcInExtY;
        public int 	    lcInExtZ;
        public int 	    lcOutOrgX;
        public int 	    lcOutOrgY;
        public int	    lcOutOrgZ;
        public int 	    lcOutExtX;
        public int	    lcOutExtY;
        public int 	    lcOutExtZ;
        public Int32	lcSensX;
        public Int32	lcSensY;
        public Int32	lcSensZ;
        public int	    lcSysMode;
        public int		lcSysOrgX;
        public int		lcSysOrgY;
        public int		lcSysExtX;
        public int		lcSysExtY;
        public Int32	lcSysSensX;
        public Int32	lcSysSensY;
    }

    /// <summary>
    /// ReLXgIvV\tOB
    /// </summary>
    [Flags]
    public enum ContextOption : uint {
        /// <summary>ftHg̃IvV</summary>
        DEFAULT     = 0x0000,   // WinTab.NET extension
        /// <summary>VXeJ[\ReNXg (VXeJ[\yɒǏ]邩)</summary>
        SYSTEM		= 0x0001,
        /// <summary>yEBhEYCXg[ĂꍇAyEBhEỸReNXg</summary>
        PEN			= 0x0002,
        /// <summary>I[i[ WT_PACKETbZ[WԂReNXg (Ŏw肳)</summary>
        MESSAGES	= 0x0004,
        /// <summary>I[i[ WT_CSRCHANGEbZ[WԂReNXg (Ŏw肳)</summary>
        CSRMESSAGES	= 0x0008,
        /// <summary>MARGINw肳ĂꍇA}[WReNXg̓ɂ邱Ƃw</summary>
        MGNINSIDE	= 0x4000,
        /// <summary>^ubg̓̓ReNXg}[WƂ\</summary>
        MARGIN		= 0x8000,

        /// <summary>w肵IvVftHg؂@\ (DEFAULT͖܂)</summary>
        OFFMODE     = 0x10000,  // WinTab.NET extension
    };

    /// <summary>
    /// ReLXgԂ\tOB
    /// </summary>
    [Flags]
    public enum ContextStatus {
        /// <summary>WinTabContext.EnablevpeB(WTEnable֐)ɂĖɂꂽReNXg\</summary>
        DISABLED	= 0x0001,
        /// <summary>荂ʂ̃I[o[bvvɂĕIɕsĂƂȂĂReNXg\</summary>
        OBSCURED	= 0x0002,
        /// <summary>I[o[bvv̍ŏʂɂReNXg\</summary>
        ONTOP		= 0x0004
    };

    /// <summary>
    /// ReLXg̃bN(ύXs)ڂtOB
    /// </summary>
    [Flags]
    public enum ContextLock {
        /// <summary>ύXsȃReNXg̓̓TCY`</summary>
        INSIZE		= 0x0001,
        /// <summary>ύXsȃReNXg̓̓AXyNg`</summary>
        INASPECT	= 0x0002,
        /// <summary>ύXsȃReNXg̊x`</summary>
        SENSITIVITY	= 0x0004,
        /// <summary>ύXsȃReNXg̃}[WIvV`</summary>
        MARGIN		= 0x0008,
        /// <summary>ReNXgVXeJ[\ReNXgłꍇAVXewύXsȃReNXg̃Rg[ϐ̒`B</summary>
        SYSOUT		= 0x0010
    };

    // --------------------------------------------------------------------------
    // EVENT DATA DEFS

    /// <summary>
    /// Packet status values
    /// </summary>
    [Flags]
    public enum PacketStatus {
        PROXIMITY		= 0x0001,
        QUEUE_ERR		= 0x0002,
        MARGIN			= 0x0004,
        GRAB			= 0x0008,
        INVERT			= 0x0010
    }

    /// <summary>
    /// ^ubgɏJ[\̕B
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct ORIENTATION {
        /// <summary>zʂ]v̊px</summary>
        public int  orAzimuth;
        /// <summary>x-yʂʂ锼~̊px</summary>
        public int  orAltitude;
        /// <summary>J[\̎厲𒆐SƂv̊px</summary>
        public int  orTwist;
    }

    /// <summary>
    /// ^ubgł̃J[\̉]B
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct ROTATION { /* 1.1 */
        /// <summary>J[\̌XΓx (pitch)</summary>
        public int  roPitch;
        /// <summary>J[\̉]x (roll)</summary>
        public int  roRoll;
        /// <summary>J[\̕Ηhpx (yaw)</summary>
        public int  roYaw;
    }

    /// <summary>
    /// ΃[h̎AALLPACKET(pkts).pkButtons̉ʃ[hB
    /// </summary>
    public enum RelativeButton {
        /// <summary>{^̏ԕωƂ</summary>
        NONE        = 0,
        /// <summary>{^グꂽƂ</summary>
        UP          = 1,
        /// <summary>{^ꂽƂ</summary>
        DOWN        = 2
    };

    // --------------------------------------------------------------------------
    // DEVICE CONFIG CONSTANTS

    /// <summary>
    /// Device config status
    /// </summary>
    public enum WTDeviceConfig {
        NONE		= 0,
        CANCEL		= 1,
        OK			= 2,
        RESTART		= 3
    };

    // --------------------------------------------------------------------------
    // HOOK CONSTANTS

    /// <summary>
    /// Hook constants
    /// </summary>
    public enum WTHook {
        PLAYBACK		= 1,
        RECORD			= 2
    };

    /// <summary>
    /// Hook config values
    /// </summary>
    public enum WTHookConfig {
        GETLPLPFN	= -3,
        LPLPFNNEXT	= -2,
        LPFNNEXT	= -1,
        ACTION		= 0,
        GETNEXT   	= 1,
        SKIP 		= 2
    };

    // --------------------------------------------------------------------------
    // EXTENSION TAGS AND CONSTANTS
    
    /// <summary>
    /// Extension tags
    /// </summary>
    public enum WTX {
        OBT			= 0,	/// <summary>Out of bounds tracking</summary>
        FKEYS		= 1,	/// <summary>Function keys</summary>
        TILT		= 2,	/// <summary>Raw Cartesian tilt; 1.1</summary>
        CSRMASK		= 3,	/// <summary>select input by cursor type; 1.1</summary>
        XBTNMASK	= 4	    /// <summary>Extended button mask; 1.1</summary>
    };

    [StructLayout(LayoutKind.Sequential)]
    public unsafe struct XBTNMASK {
        public fixed byte xBtnDnMask[32];
        public fixed byte xBtnUpMask[32];
    };

    [StructLayout(LayoutKind.Sequential)]
    public struct TILT {
        public int  tiltX;
        public int  tiltY;
    };

    // --------------------------------------------------------------------------
    // Functions

    static unsafe public partial class WinTab {
#if WINTAB_DYNAMIC
        static void LoadWinTabLibrary() { WinTabInvoker.LoadWinTabLibrary(); }
        
        /// <summary>
        /// y^ubgCXg[Ă(WinTab32.dll݂Ă)ǂ
        /// </summary>
        static public bool Valid {
            get { return WinTabInvoker.IsValid(); }
        }

        static public UInt32 _WTOpen(IntPtr hWnd,/*LOGCONTEXT*/void* lpLogCtx,BOOL fEnable) {
            return WinTabInvoker._WTOpen(hWnd,lpLogCtx,fEnable);
        }

        static public int _WTClose(HCTX hCTX) {
            return WinTabInvoker._WTClose(hCTX);
        }

        static public uint _WTInfo(InfoCategory nCategory,uint nIndex,void* pBuf) {
            return WinTabInvoker._WTInfo((uint)nCategory,nIndex,pBuf);
        }

        static public int _WTPacket(HCTX hCTX,uint wSerial,void* pBuf) {
            return WinTabInvoker._WTPacket(hCTX,wSerial,pBuf);
        }

        static public int _WTEnable(HCTX hCTX,BOOL fEnable) {
            return WinTabInvoker._WTEnable(hCTX,fEnable);
        }

        static public int _WTOverlap(HCTX hCTX,BOOL fEnable) {
            return WinTabInvoker._WTOverlap(hCTX,fEnable);
        }

        static public int _WTConfig(HCTX hCTX,IntPtr hWnd) {
            return WinTabInvoker._WTConfig(hCTX,hWnd);
        }
#else
        static void LoadWinTabLibrary() { }

        [DllImport("WinTab32.dll",EntryPoint="WTOpenW")]
        static public extern UInt16 _WTOpen(IntPtr hWnd,/*LOGCONTEXT*/void* lpLogCtx,BOOL fEnable);
        [DllImport("WinTab32.dll",EntryPoint="WTClose")]
        static public extern int _WTClose(HCTX hCTX);
        [DllImport("WinTab32.dll",EntryPoint="WTInfoW")]
        static public extern uint _WTInfo(InfoCategory nCategory,uint nIndex,void* pBuf);
        [DllImport("WinTab32.dll",EntryPoint="WTPacket")]
        static public extern int _WTPacket(HCTX hCTX,uint wSerial,void* pBuf);
        [DllImport("WinTab32.dll",EntryPoint="WTEnable")]
        static public extern int _WTEnable(HCTX hCTX,BOOL fEnable);
        [DllImport("WinTab32.dll",EntryPoint="WTOverlap")]
        static public extern int _WTOverlap(HCTX hCTX,BOOL fEnable);
        [DllImport("WinTab32.dll",EntryPoint="WTConfig")]
        static public extern int _WTConfig(HCTX hCTX,IntPtr hWnd);
#endif
        /// <summary>
        /// Opens new context.
        /// </summary>
        /// <param name="hWnd">Window handle which receives a message</param>
        /// <param name="lpLogCtx">Context parameter</param>
        /// <param name="fEnable">Enable context on initialized</param>
        /// <exception cref="WinTabDotnet.WinTabException"></exception>
        /// <returns>Context handle</returns>
        static public HCTX WTOpen(IntPtr hWnd,/*LOGCONTEXT*/void* lpLogCtx,BOOL fEnable) {
            HCTX  ret = _WTOpen(hWnd,lpLogCtx,fEnable);
            if (ret==0) { throw new WinTabException("WTOpen failed."); }
            return ret;
        }

        /// <summary>
        /// Closes existing context.
        /// </summary>
        /// <param name="hCTX">Existing context</param>
        /// <exception cref="WinTabDotnet.WinTabException"></exception>
        static public void WTClose(HCTX hCTX) {
            if (_WTClose(hCTX)==0) { throw new WinTabException("WTClose failed."); }
        }
        
        /// <summary>
        /// Returns global information.
        /// </summary>
        /// <param name="nCategory">Info category</param>
        /// <param name="nIndex">Info index (WinTab.InfoIndex.INTERFACE,STATUS...)</param>
        /// <param name="pBuf">Buffer which returns information</param>
        /// <returns></returns>
        /// <exception cref="WinTabDotnet.WinTabException"></exception>
        static public uint WTInfo(InfoCategory nCategory,uint nIndex,void* pBuf) {
            uint  ret = _WTInfo(nCategory,nIndex,pBuf);
            if (ret==0) { throw new WinTabException("WTInfo failed."); }
            return ret;
        }

        /// <summary>
        /// Gets packet which arrived.
        /// </summary>
        /// <param name="hCTX">Context which packet arrived (WParam)</param>
        /// <param name="wSerial">Tablet event serial number (LParam)</param>
        /// <param name="pBuf">Buffer which returns packet values.</param>
        /// <exception cref="WinTabDotnet.WinTabException"></exception>
        static public void WTPacket(HCTX hCTX,uint wSerial,void* pBuf) {
            if (_WTPacket(hCTX,wSerial,pBuf)==0) { throw new WinTabException("WTPacket failed. (Packet queue is empty?)"); }
        }

        /// <summary>
        /// Enables or disables a tablet context.
        /// </summary>
        /// <param name="hCTX">Context which to be enabled or disabled</param>
        /// <param name="fEnable">Enable/disable flag</param>
        /// <exception cref="WinTabDotnet.WinTabException"></exception>
        static public void WTEnable(HCTX hCTX,BOOL fEnable) {
            if (_WTEnable(hCTX,fEnable)==0) { throw new WinTabException("WTEnable failed."); }
        }

        /// <summary>
        /// WTOverlap.
        /// </summary>
        /// <param name="hCTX"></param>
        /// <param name="fEnable"></param>
        static public void WTOverlap(HCTX hCTX,BOOL fEnable) {
            if (_WTOverlap(hCTX,fEnable)==0) { throw new WinTabException("WTOverlap failed."); }
        }

        /// <summary>
        /// Show context configuration dialogbox if device supports.
        /// </summary>
        /// <param name="hCTX">Context handle</param>
        /// <param name="hWnd">Dialogbox parent window</param>
        /// <returns>Returns true if the tablet context was changed, false otherwise.</returns>
        static public bool WTConfig(HCTX hCTX,IntPtr hWnd) {
            return _WTConfig(hCTX,hWnd)!=0;
        }

        [DllImport("User32.dll")]
        static public extern int GetSystemMetrics(int nIndex);
    };

    // --------------------------------------------------------------------------
    // Packet

    [StructLayout(LayoutKind.Sequential)]
    public struct ALLPACKET {
        public uint     pkContext;
        public uint     pkStatus;
        public int      pkTime;
        public WTPKT    pkChanged;
        public uint     pkSerialNumber;
        public uint     pkCursor;
        public uint     pkButtons;
        public int      pkX,pkY,pkZ;
        public int      pkNormalPressure;
        public int      pkTangendPressure;
    };

    // --------------------------------------------------------------------------
    // Main

    static public partial class WinTab {
        // --------------------------------------------------------------------------
        // Auxiliary functions
        static private unsafe uint GetInfoUInt(InfoCategory cat,uint idx) {
            uint  p;
            WTInfo(cat,idx,&p);
            return p;
        }

        static private unsafe uint[] GetInfoUInts(InfoCategory cat,uint idx,uint count) {
            uint[] r = new uint[count];
            fixed (uint* p = r) {
                WTInfo(cat,idx,p);
            }
            return r;
        }

        static private unsafe ushort GetInfoWord(InfoCategory cat,uint idx) {
            ushort p;
            WTInfo(cat,idx,&p);
            return p;
        }

        static private unsafe byte GetInfoByte(InfoCategory cat,uint idx) {
            byte p;
            WTInfo(cat,idx,&p);
            return p;
        }

        static private unsafe byte[] GetInfoBytes(InfoCategory cat,uint idx,uint bytes) {
            byte[] r = new byte[bytes];
            fixed (byte* p = r) {
                WTInfo(cat,idx,p);
            }
            return r;
        }

        static private unsafe string GetInfoString(InfoCategory cat,uint idx) {
            char* buf = stackalloc char[128];
            WTInfo(cat,idx,buf);
            return new string(buf);
        }

        static private unsafe string[] GetInfoStrings(InfoCategory cat,uint idx) {
            char[] buf = new char[256];
            char[] cbuf = new char[256];
            ArrayList  r = new ArrayList();
            
            fixed (char* p = buf) {
                uint f = WTInfo(cat,idx,p);
                int lp=0;
                for (int i=0;i<buf.Length-1;i++) {
                    if (p[i]=='\0') {
                        cbuf.Initialize();
                        Array.Copy(buf,lp,cbuf,0,i-lp);
                        r.Insert(0,new string(cbuf));
                        lp=0;

                        if (p[i+1]=='\0') { break; }
                    } else { lp++; }
                }
            }
            return (string[])r.ToArray(typeof(string[]));
        }

        static private unsafe AXIS GetInfoAxis(InfoCategory cat,uint idx) {
            AXIS  p;
            WTInfo(cat,idx,&p);
            return p;
        }

        static private unsafe AXIS[] GetInfoAxisA(InfoCategory cat,uint idx,int c) {
            AXIS[]  buf = new AXIS[3];
            fixed (AXIS* p = buf) { WTInfo(cat,idx,p); }
            return buf;
        }

        // --------------------------------------------------------------------------
        // Interface Properties

        /// <summary>
        /// ^ubgn[hEFAʂ镶B
        /// Tablet hardware identification string.
        /// </summary>
        static public string WinTabID {
            get { return GetInfoString(InfoCategory.INTERFACE,(uint)InfoIndex.INTERFACE.WINTABID); }
        }

        /// <summary>
        /// ڍ׃o[WBʃoCgFW[o[WAʃoCgF}Ci[o[WB
        /// Specification version. High/low-order byte contains the major/minor version.
        /// </summary>
        static public ushort SpecVersion {
            get { return GetInfoWord(InfoCategory.INTERFACE,(uint)InfoIndex.INTERFACE.SPECVERSION); }
        }

        /// <summary>
        /// o[WBʃoCgFW[o[WAʃoCgF}Ci[o[WB
        /// Implementation version. High/low-order byte contains the major/minor version.
        /// </summary>
        static public ushort ImplVersion {
            get { return GetInfoWord(InfoCategory.INTERFACE,(uint)InfoIndex.INTERFACE.IMPLVERSION); }
        }

        /// <summary>
        /// T|[gĂfoCXB
        /// Number of devices supported.
        /// </summary>
        static public uint SupportedDevices {
            get { return GetInfoUInt(InfoCategory.INTERFACE,(uint)InfoIndex.INTERFACE.NDEVICES); }
        }

        /// <summary>
        /// T|[gĂJ[\`(yAS)̐B
        /// Total number of cursor types supported.
        /// </summary>
        static public uint SupportedCursors {
            get { return GetInfoUInt(InfoCategory.INTERFACE,(uint)InfoIndex.INTERFACE.NCURSORS); }
        }

        /// <summary>
        /// T|[gĂReNXg̐B
        /// Number of contexts supported.
        /// </summary>
        static public uint SupportedContexts {
            get { return GetInfoUInt(InfoCategory.INTERFACE,(uint)InfoIndex.INTERFACE.NCONTEXTS); }
        }

        /// <summary>
        /// T|[gꂽReNXgIvVɂĎꂽtOB
        /// Flags indicating which context options are supported.
        /// </summary>
        static public uint ContextOptions {
            get { return GetInfoUInt(InfoCategory.INTERFACE,(uint)InfoIndex.INTERFACE.CTXOPTIONS); }
        }

        /// <summary>
        /// ۑ̃TCYB
        /// Size of the save information.
        /// </summary>
        static public uint ContextSaveSize {
            get { return GetInfoUInt(InfoCategory.INTERFACE,(uint)InfoIndex.INTERFACE.CTXSAVESIZE); }
        }

        /// <summary>
        /// T|[gꂽgf[^ACe̐B
        /// Number of extension data items supported.
        /// </summary>
        static public uint Extensions {
            get { return GetInfoUInt(InfoCategory.INTERFACE,(uint)InfoIndex.INTERFACE.NEXTENSIONS); }
        }

        /// <summary>
        /// T|[gꂽ}l[W[nh̐B
        /// Number of manager handles supported.
        /// </summary>
        static public uint Managers {
            get { return GetInfoUInt(InfoCategory.INTERFACE,(uint)InfoIndex.INTERFACE.NMANAGERS); }
        }

        // --------------------------------------------------------------------------
        // Device Properties

        /// <summary>
        /// \\ȃfoCXAArWx\B
        /// Displayable string describing the device, manufacturer, and revision level.
        /// </summary>
        static public string DeviceName {
            get { return GetInfoString(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.NAME); }
        }

        /// <summary>
        /// n[hEFAƃfoCX\͂\tOB
        /// Hardware and driver capabilities.
        /// </summary>
        static public HardwareCapabilities DeviceCapabilities {
            get { return (HardwareCapabilities)GetInfoUInt(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.HARDWARE); }
        }

        /// <summary>
        /// T|[gĂJ[\`(yAS)̐B
        /// Number of supported cursor types.
        /// </summary>
        static public uint DeviceCursorTypes {
            get { return GetInfoUInt(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.NCSRTYPES); }
        }

        /// <summary>
        /// J[\`B
        /// First cursor type number for the device.
        /// </summary>
        static public uint DeviceFirstCursor {
            get { return GetInfoUInt(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.FIRSTCSR); }
        }

        /// <summary>
        /// pPbg|[g[g̍ől(wcP)B
        /// Maximum packet report rate in Hertz.
        /// </summary>
        static public uint DevicePacketRate {
            get { return GetInfoUInt(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.PKTRATE); }
        }

        /// <summary>
        /// pPbgf[^ACeɕ\Ԃł邱Ƃrbg}XNB
        /// Bit mask indicating which packet data items are always available.
        /// </summary>
        static public WTPKT DevicePacketData {
            get { return (WTPKT)GetInfoUInt(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.PKTDATA); }
        }

        /// <summary>
        /// pPbgf[^ACeIɑΒlł邱Ƃrbg}XNB
        /// Bit mask indicating which packet data items are physically relative.
        /// </summary>
        static public WTPKT DevicePacketMode {
            get { return (WTPKT)GetInfoUInt(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.PKTMODE); }
        }

        /// <summary>
        /// mɃJ[\ڑĂꍇ̂ݕ\ĂpPbgf[^ACẽrbg}XN.
        /// Bit mask indicating which packet data items are only available when certain cursors are connected.
        /// </summary>
        static public WTPKT DeviceCursorData {
            get { return (WTPKT)GetInfoUInt(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.CSRDATA); }
        }

        /// <summary>
        /// ^ubg̃lCeBuWɂA^ubgReNXg̃}[WTCYB
        /// Size of tablet context margins in tablet native coordinates.
        /// </summary>
        static public uint DeviceXMargin {
            get { return GetInfoUInt(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.XMARGIN); }
        }

        /// <summary>
        /// ^ubg̃lCeBuWɂA^ubgReNXg̃}[WTCYB
        /// Size of tablet context margins in tablet native coordinates.
        /// </summary>
        static public uint DeviceYMargin {
            get { return GetInfoUInt(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.YMARGIN); }
        }

        /// <summary>
        /// ^ubg̃lCeBuWɂA^ubgReNXg̃}[WTCYB
        /// Size of tablet context margins in tablet native coordinates.
        /// </summary>
        static public uint DeviceZMargin {
            get { return GetInfoUInt(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.ZMARGIN); }
        }

        /// <summary>
        /// ^ubg͈̔͋yѕ\B
        /// Tablet's range and resolution capabilities.
        /// </summary>
        static public AXIS DeviceX {
            get { return GetInfoAxis(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.X); }
        }

        /// <summary>
        /// ^ubg͈̔͋yѕ\B
        /// Tablet's range and resolution capabilities.
        /// </summary>
        static public AXIS DeviceY {
            get { return GetInfoAxis(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.Y); }
        }

        /// <summary>
        /// ^ubg͈̔͋yѕ\B
        /// Tablet's range and resolution capabilities.
        /// </summary>
        static public AXIS DeviceZ {
            get { return GetInfoAxis(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.Z); }
        }

        /// <summary>
        /// ʏ̏ꍇ̃^ubgM͈̔͂ƕ\B
        /// Tablet's range and resolution capabilities, for the normal pressure inputs.
        /// </summary>
        static public AXIS DeviceNPressure {
            get { return GetInfoAxis(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.NPRESSURE); }
        }

        /// <summary>
        /// Xꍇ̃^ubgM͈̔͂ƕ\B
        /// Tablet's range and resolution capabilities, for the tangential pressure inputs.
        /// </summary>
        static public AXIS DeviceTPressure {
            get { return GetInfoAxis(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.TPRESSURE); }
        }

        /// <summary>
        /// ^ubg̓K͈͂ƕ\BAXIS3̔zB
        /// 3-element array describing the tablet's orientation range and resolution capabilities.
        /// </summary>
        static public AXIS[] DeviceOrientation {
            get { return GetInfoAxisA(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.ORIENTATION,3); }
        }

        /// <summary>
        /// ^ubg̊px͈͂ƕ\BAXIS3̔zB
        /// 3-element array describing the tablet's rotation range and resolution capabilities.
        /// </summary>
        static public AXIS[] DeviceRotation {
            get { return GetInfoAxisA(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.ROTATION,3); }
        }

        /// <summary>
        /// foCX Plug and Play IDB
        /// Device's Plug and Play ID.
        /// </summary>
        static public string DevicePnPID {
            get { return GetInfoString(InfoCategory.DEVICES,(uint)InfoIndex.DEVICE.PNPID); }
        }

        // --------------------------------------------------------------------------
        // Cursor Properties

        /// <summary>
        /// \\ȃJ[\̕B
        /// Displayable string containing the name of the cursor.
        /// </summary>
        static public string CursorName {
            get { return GetInfoString(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.NAME); }
        }

        /// <summary>
        /// J[\ݐڑĂ邩ǂB
        /// Returns whether the cursor is currently connected.
        /// </summary>
        static public bool CursorIsActive {
            get { return GetInfoUInt(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.ACTIVE)!=0; }
        }

        /// <summary>
        /// J[\ڑĂƂɃT|[gpPbgf[^ACerbg}XNB
        /// Bit mask indicating the packet data items supported when this cursor is connected.
        /// </summary>
        static public WTPKT CursorPacketData {
            get { return (WTPKT)GetInfoUInt(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.PKTDATA); }
        }

        /// <summary>
        /// J[\ɑ݂{^̐B
        /// Number of buttons on this cursor.
        /// </summary>
        static public byte CursorButtons {
            get { return GetInfoByte(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.BUTTONS); }
        }

        /// <summary>
        /// n[hEFAԂꂽH̃{^f[^̃rbgB
        /// Number of bits of raw button data returned by the hardware.
        /// </summary>
        static public byte CursorRawButton {
            get { return GetInfoByte(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.BUTTONBITS); }
        }

        /// <summary>
        /// J[\{^̖O܂񂾕zB
        /// String array containing the names of the cursor's buttons.
        /// </summary>
        static public string[] CursorButtonNames {
            get { return GetInfoStrings(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.BTNNAMES); }
        }

        // start from CSR_BUTTONMAP.... to CSR_CAPABILITIES

        /// <summary>
        /// X̕I{^ɊUꂽA{^ԍӖ32oCg̔zB
        /// 32 byte array of logical button numbers, one for each physical button.
        /// </summary>
        static public byte[] CursorButtonNumberMap {
            get { return GetInfoBytes(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.BUTTONMAP,32); }
        }

        /// <summary>
        /// X̕I{^ɊUꂽA{^ANVR[hӖ32oCg̔zB
        /// 32 byte array of logical button numbers, one for each physical button.
        /// </summary>
        static public byte[] CursorSystemActionCodeMap {
            get { return GetInfoBytes(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.SYSBTNMAP,32); }
        }

        /// <summary>
        /// WMɂăRg[{^̕I{^ԍB
        /// Returns the physical button number of the button that is controlled by normal pressure.
        /// </summary>
        static public byte CursorNPressureButton {
            get { return GetInfoByte(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.NPBUTTON); }
        }

        /// <summary>
        /// WMɂ{^}[N\2uint̔zB1=[X}[N / 2=vX}[N
        /// Array of two uints, specifying the button marks for the normal pressure button. The first/second uint contains the release/press mark.
        /// </summary>
        static public uint[] CursorNPressureButtonMark {
            get { return GetInfoUInts(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.NPBUTTON,2); }
        }

        /// <summary>
        /// WMɂM̉Ȑ킷uint̔zB
        /// Array of uints describing the pressure response curve for normal pressure.
        /// </summary>
        static public uint[] CursorNPressureResponce {
            get { return GetInfoUInts(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.NPRESPONSE,512); }
        }

        /// <summary>
        /// ږʕMɂăRg[{^̕I{^ԍB
        /// Returns the physical button number of the button that is controlled by tangential pressure.
        /// </summary>
        static public byte CursorTPressureButton {
            get { return GetInfoByte(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.NPBUTTON); }
        }

        /// <summary>
        /// ږʕMɂ{^}[N\2uint̔zB1=[X}[N / 2=vX}[N
        /// Array of two uints, specifying the button marks for the tangential pressure button. The first/second uint contains the release/press mark.
        /// </summary>
        static public uint[] CursorTPressureButtonMark {
            get { return GetInfoUInts(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.NPBUTTON,2); }
        }

        /// <summary>
        /// ږʂɂM̉Ȑ킷uint̔zB
        /// Array of uints describing the pressure response curve for tangential pressure.
        /// </summary>
        static public uint[] CursorTPressureResponce {
            get { return GetInfoUInts(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.NPRESPONSE,512); }
        }

        /// <summary>
        /// i̕IȃJ[\̎ʎqB
        /// Manufacturer-specific physical identifier for the cursor
        /// </summary>
        static public uint CursorPhysicalID {
            get { return GetInfoUInt(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.PHYSID); }
        }

        /// <summary>
        /// J[\^CvCursorCapabilities.MULTIMODE܂܂ꍇAJ[\[h̃J[\`ԍB
        /// Cursor mode number of this cursor type, if this cursor type has the CursorCapabilities.MULTIMODE.
        /// </summary>
        static public uint CursorMode {
            get { return GetInfoUInt(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.MODE); }
        }

        /// <summary>
        /// J[\^CvCursorCapabilities.AGGREGATE܂܂ꍇAIȃJ[\̃f[^̍ŏZbgB
        /// Minimum set of data available from a physical cursor in this cursor type, if this cursor type has the CursorCapabilities.AGGREGATE.
        /// </summary>
        static public uint CursorMinPacket {
            get { return GetInfoUInt(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.MINPKTDATA); }
        }

        /// <summary>
        /// J[\^CvCursorCapabilities.AGGREGATE܂܂ꍇAIȃJ[\̃{^̍ŏʁB
        /// Minimum number of buttons of physical cursors in the cursor type, if this cursor type has the CursorCapabilities.AGGREGATE.
        /// </summary>
        static public uint CursorMinButton {
            get { return GetInfoUInt(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.MINBUTTONS); }
        }

        /// <summary>
        /// J[\̔\͂tOB
        /// Flags indicating cursor capabilities.
        /// </summary>
        static public CursorCapabilities CursorCapabilities {
            get { return (CursorCapabilities)GetInfoUInt(InfoCategory.CURSORS,(uint)InfoIndex.CURSOR.CAPABILITIES); }
        }
    }

    // --------------------------------------------------------------------------
    // Delegates/Events
    public struct PacketEventArgs { public ALLPACKET pkts; }
    public delegate void NewPacketsHandler(PacketEventArgs e);
    public delegate void ButtonUpHandler(PacketEventArgs e);
    public delegate void ButtonDownHandler(PacketEventArgs e);
    public delegate void CursorMoveHandler(PacketEventArgs e);
    public delegate void NPressureChangeHandler(PacketEventArgs e);
    public delegate void TPressureChangeHandler(PacketEventArgs e);
    public delegate void CursorChangeHandler(PacketEventArgs e);
    public delegate void OrientationChangeHandler(PacketEventArgs e);
    public delegate void RotationChangeHandler(PacketEventArgs e);

    public class WinTabMessenger {
        /// <summary>VpPbgۂɔ</summary>
        public event NewPacketsHandler        NewPackets;
        /// <summary>{^ꂽۂɔ</summary>
        public event ButtonDownHandler        ButtonDown;
        /// <summary>{^グꂽۂɔ</summary>
        public event ButtonUpHandler          ButtonUp;
        /// <summary>J[\ړɔ</summary>
        public event CursorMoveHandler        CursorMove;
        /// <summary>MύXꂽۂɔ</summary>
        public event NPressureChangeHandler   NPressureChange;
        /// <summary>ږʕMύXꂽۂɔ</summary>
        public event TPressureChangeHandler   TPressureChange;
        /// <summary>J[\ύXꂽۂɔ</summary>
        public event CursorChangeHandler      CursorChange;
        /// <summary>J[\̕ύXꂽۂɔ</summary>
        public event OrientationChangeHandler OrientationChange;
        /// <summary>J[\̊pxύXꂽۂɔ</summary>
        public event RotationChangeHandler    RotationChange;

        /// <summary>
        /// WinTabContext.OpenɎw肵EBhEWndProcŌĂяoĉB
        /// </summary>
        /// <param name="m">ĂԏoWndProcMessage</param>
        /// <returns>pPbgꂽǂboollB</returns>
        public unsafe bool WndProc(ref Message m) {
            switch (m.Msg) {
                case WinTab.WT_PACKET: {
                    PacketEventArgs  e;
                    WinTab.WTPacket((ushort)m.LParam,(uint)m.WParam,&(e.pkts));

                    if (NewPackets!=null) { NewPackets(e); }

                    switch ((RelativeButton)e.pkts.pkButtons) {
                        case RelativeButton.UP: if (ButtonUp!=null) { ButtonUp(e); }  break;
                        case RelativeButton.DOWN: if (ButtonDown!=null) { ButtonDown(e); }  break;
                    }

                    if (((e.pkts.pkChanged & WTPKT.X) |
                         (e.pkts.pkChanged & WTPKT.Y) |
                         (e.pkts.pkChanged & WTPKT.Z))!=0)
                    { if (CursorMove!=null) { CursorMove(e); } }

                    if ((e.pkts.pkChanged & WTPKT.NORMAL_PRESSURE)!=0)
                    { if (NPressureChange!=null) { NPressureChange(e); } }
                    if ((e.pkts.pkChanged & WTPKT.TANGENT_PRESSURE)!=0)
                    { if (TPressureChange!=null) { TPressureChange(e); } }
                    if ((e.pkts.pkChanged & WTPKT.CURSOR)!=0)
                    { if (CursorChange!=null) { CursorChange(e); } }
                    if ((e.pkts.pkChanged & WTPKT.ORIENTATION)!=0)
                    { if (OrientationChange!=null) { OrientationChange(e); } }
                    if ((e.pkts.pkChanged & WTPKT.ROTATION)!=0)
                    { if (RotationChange!=null) { RotationChange(e); }  }

                    return true;
                }
                    // case WinTab
            }
            return false;
        }
    };

    /// <summary>
    /// ΃[hwpB
    /// </summary>
    public enum RelativeField {
        None,
        Time,
        Position,
        Button,
        NPressure,
        TPressure
    };

    /// <summary>
    /// ReLXgbp[NXB
    /// </summary>
    public class WinTabContext {
        private HCTX        m_hCTX;         // OO
        private bool        m_bEnabled;     // [Jŕێ[B
        private LOGCONTEXT  m_srLogContext;

        public WinTabContext()          { m_hCTX=0; }
        public WinTabContext(HCTX i)    { m_hCTX=i; }
               ~WinTabContext()         { if (IsValid) { Close(); } }
        public static explicit operator WinTabContext(HCTX x) { return new WinTabContext(x); }
        public static explicit operator HCTX(WinTabContext x) { return x.m_hCTX; }

        /// <summary>
        /// w肵IvVŁAReLXgJ܂B
        /// </summary>
        /// <param name="hWnd">EBhEbZ[WMnh</param>
        /// <param name="bEnable">ԂŗLɂ邩</param>
        /// <param name="xorg">o̓GÅ_FXW</param>
        /// <param name="yorg">o̓GÅ_FYW</param>
        /// <param name="vx">o̓GAXTCY</param>
        /// <param name="vy">o̓GAYTCY</param>
        /// <param name="cxo">ReLXg̃IvV</param>
        /// <param name="rf">΃[hɂ鍀</param>
        /// <returns></returns>
        public unsafe WinTabContext Open(IntPtr hWnd,bool bEnable,int xorg,int yorg,int vx,int vy,ContextOption cxo,RelativeField rf) {
            fixed (LOGCONTEXT* p = &m_srLogContext) {
                WinTab.WTInfo(InfoCategory.DEFSYSCTX,0,p);

                m_srLogContext.lcMsgBase    = WinTab.WT_DEFBASE;
                m_srLogContext.lcOptions   |= ContextOption.MESSAGES;
                m_srLogContext.lcPktData    = WinTab.WTPKT_ALL;
                m_srLogContext.lcPktMode    = 0;

                if (cxo!=ContextOption.DEFAULT) {
                    if ((cxo|ContextOption.OFFMODE)!=0) {
                        m_srLogContext.lcOptions   -= (cxo-ContextOption.OFFMODE);
                    } else {
                        m_srLogContext.lcOptions    = cxo;
                    }
                }
                m_srLogContext.lcOptions   |= ContextOption.MESSAGES | ContextOption.CSRMESSAGES;

                if ((rf & RelativeField.Button)!=0)    { m_srLogContext.lcPktMode |= WTPKT.BUTTONS; }
                if ((rf & RelativeField.Position)!=0)  { m_srLogContext.lcPktMode |= WTPKT.X | WTPKT.Y | WTPKT.Z; }
                if ((rf & RelativeField.Button)!=0)    { m_srLogContext.lcPktMode |= WTPKT.BUTTONS; }
                if ((rf & RelativeField.NPressure)!=0) { m_srLogContext.lcPktMode |= WTPKT.NORMAL_PRESSURE; }
                if ((rf & RelativeField.TPressure)!=0) { m_srLogContext.lcPktMode |= WTPKT.TANGENT_PRESSURE; }

                m_srLogContext.lcMoveMask   = WinTab.WTPKT_ALL;
                m_srLogContext.lcBtnUpMask  = m_srLogContext.lcBtnDnMask;

                m_srLogContext.lcOutOrgX    = m_srLogContext.lcOutOrgY = xorg;
                m_srLogContext.lcSysOrgX    = m_srLogContext.lcSysOrgY = yorg;
                m_srLogContext.lcOutExtX    = m_srLogContext.lcSysExtX = vx;
                m_srLogContext.lcOutExtY    = -vy;
                m_srLogContext.lcSysExtY    = vy;

                m_hCTX = WinTab.WTOpen(hWnd,p,Convert.ToInt32(bEnable));
            }
            m_bEnabled = bEnable;
            return this;
        }

        /// <summary>
        /// w肵IvVŁAReLXgJ܂B
        /// </summary>
        /// <param name="hWnd">EBhEbZ[WMnh</param>
        /// <param name="bEnable">ԂŗLɂ邩</param>
        /// <param name="cxo">ReLXg̃IvV</param>
        /// <param name="rf">΃[hɂ鍀</param>
        public WinTabContext Open(IntPtr hWnd,bool bEnable,ContextOption cxo,RelativeField rf) {
            return Open(hWnd,bEnable,0,0,WinTab.GetSystemMetrics(78),WinTab.GetSystemMetrics(79),cxo,rf);
        }

        /// <summary>
        /// w肵IvVŁAReLXgJ܂B
        /// </summary>
        /// <param name="hWnd">EBhEbZ[WMnh</param>
        /// <param name="bEnable">ԂŗLɂ邩</param>
        /// <param name="rf">΃[hɂ鍀</param>
        public WinTabContext Open(IntPtr hWnd,bool bEnable,RelativeField rf) {
            return Open(hWnd,bEnable,0,0,WinTab.GetSystemMetrics(78),WinTab.GetSystemMetrics(79),ContextOption.DEFAULT,rf);
        }

        /// <summary>
        /// w肵IvVŁAReLXgJ܂B
        /// </summary>
        /// <param name="hWnd">EBhEbZ[WMnh</param>
        /// <param name="bEnable">ԂŗLɂ邩</param>
        public WinTabContext Open(IntPtr hWnd,bool bEnable) {
            return Open(hWnd,bEnable,0,0,WinTab.GetSystemMetrics(78),WinTab.GetSystemMetrics(79),ContextOption.DEFAULT,RelativeField.None);
        }

        /// <summary>
        /// ReLXg܂B
        /// </summary>
        /// <exception cref="WinTabDotnet.WinTabException">ReLXgĂȂꍇɔ</exception>
        public void Close() {
            if (m_hCTX!=0) {
                WinTab.WTClose(m_hCTX);
                m_hCTX=0;
            } else {
                throw new WinTabException("Context is not initialized.");
            }
        }

        /// <summary>
        /// ReLXg̐ݒ_CAO\ (T|[gĂꍇ)
        /// </summary>
        /// <param name="hWnd">eEBhẼnh</param>
        /// <returns>ReLXgύXꂽbooll (_CAO\łȂĂAO͔܂)</returns>
        public bool Config(IntPtr hWnd) {
            return WinTab.WTConfig(m_hCTX,hWnd);
        }

        /// <summary>
        /// ReLXg̗Lyі擾܂͐ݒ肵܂B
        /// </summary>
        public bool Enabled {
            get { return m_bEnabled; }
            set {
                if (m_bEnabled==value) { return; }
                WinTab.WTEnable(m_hCTX,Convert.ToInt32(value));
            }
        }

        public void Overlap(bool bOverlap) {
            WinTab.WTOverlap(m_hCTX,Convert.ToInt16(bOverlap));
        }

        /// <summary>
        /// ReLXgĂ邩擾܂B
        /// </summary>
        public bool IsValid {
            get { return m_hCTX!=0; }
        }
    };
}