/* WinUMP.c */

/*      WinUMP  Midi plugin for Mozilla  with TiMidity++
                               Ver 0.0.1 (Pre Alpha 1)
     ------------------------------------------------------------
     Copyright (C) 2002N Keishi Suenaga
                              ----------

     {vO̓t[E\tgEFAłBȂ́AFree Software Foundation 
     \GNU ʌLgṕuo[WQv͂ȍ~̊eo[W
     ̒炢ꂩIÃo[W߂ɏ]Ė{vO
     ĔЕz܂͕ύX邱Ƃł܂B

     {vO͗LpƂ͎v܂AЕzɂẮAsꐫyѓړIK
     ɂĂ̈Öق̕ۏ؂܂߂āAȂۏ؂sȂ܂BڍׂɂĂ
     GNU ʌLgpǂ݂B

     Ȃ́A{vOƈꏏGNU ʌLgp̎ʂ󂯎Ă
     ͂łBłȂꍇ́AFree Software Foundation, Inc., 675 Mass Ave,
     Cambridge, MA 02139, USA ֎莆ĂB

     Keishi Suenaga̘A     E-mail:skeishi@users.sourceforge.jp
*/
#if !defined(__GNUC__)
#define  strcasecmp stricmp
#endif

#include <windows.h>
//摜𒆉ɂׂXW(LEFT)YW(TOP)Zo}N
#define CenterX(Width) ((0)<((rect.right - rect.left - Width) / 2) ? ((rect.right - rect.left - Width) / 2) :(0))
#define CenterY(Height) ((0)<((rect.bottom - rect.top - Height) / 2) ? ((rect.bottom - rect.top - Height) / 2) :(0))

#include <windowsx.h>
#include <process.h>
#include <stdio.h>                               /* sprintf(), fprintf(), etc. */
#include <fcntl.h>                               /* O_RDWR */
//#include "npapi.h"
#include "resource.h"


#include "plugin.h"
WinUMPSM MapAdress3;

CRITICAL_SECTION cs;
BOOL cs_init=FALSE;


extern "C" int timiditymain(int argc, char** argv);
extern "C" void free_timidity(void);

static int firsttime=1;

int autostart;
int loop;

// TIMIDITỸftHgl
#ifndef DEFAULT_PATH
#define DEFAULT_PATH "c:\\timidity"
#endif /* DEFAULT_PATH */
static char timdir[MAX_PATH];

// xvZbT̂߂ɒxTvO[gftHg
static int eightKFlag = 0;
static int timid_ump_rate = 0;
static char *timid_ump_interface = "pqq";
static char temp_path[MAX_PATH];
static char filestub[MAX_PATH+12]; // \winump_midi
static char find_key[MAX_PATH+15]; // \winump_midi*.*
//static const char *filestub = "c:\\tmp\\midi";
static char timid_cfg_path[MAX_PATH];

void ThreadProc(void * MapAdress);

#define IDBT_PLAY 	201
#define IDBT_STOP	202
#define IDBT_PAUSE	203
#define IDBT_PLUS	204
#define	IDBT_MINUS	205

#define PLAYER_WIDTH 140
#define PLAYER_HIGHT 50
#define S_PLAYER_WIDTH 100
#define S_PLAYER_HIGHT 30

#define WM_MYCREATE    WM_USER

BOOL InitApp(HINSTANCE);
BOOL InitInstance(HINSTANCE, int);
HWND CreateMyStaticWindow(HWND, int x, int y, int w, int h);
HWND CreateMyButton(HWND, int x, int y, int w, int h, int ID);
int DrawMyButton(HWND hWnd, DRAWITEMSTRUCT *, int ID);

void ThreadProc(void * cplugin)
{
	int i;
   char *argv[16];
	char opt_interface[8];
	char opt_rate[32];
	char opt_cfg[MAX_PATH+2];
	int argc;
	int aid;

//	aid=AdressID;
//	AdressID=(AdressID+1) % 64;

    argc=0;
	argv[argc++] = "timidity";
	argv[argc++] = "-Od";

//	strcpy(timid_cfg_path, "c:\\timidity_buhi\\timidity.cfg" );
	if(timid_cfg_path[0] != '\0' ){
	  argv[argc++] = "-c";
	  strcpy(opt_cfg, timid_cfg_path );
	  argv[argc++] = opt_cfg;
	}

	if(timid_ump_rate <= 0 || timid_ump_rate<4000 || timid_ump_rate>96000){
		if(eightKFlag==0){	// check if the user specified 8K rate 
			argv[argc++] = "-s8000";
		}else{
			argv[argc++] = "-s22050"; 
		}
	}else
	{
	  wsprintf(opt_rate, "-s%d", timid_ump_rate);
	  argv[argc++] = opt_rate;
	}

	opt_interface[0] = '-';
	opt_interface[1] = 'i';
	strncpy(opt_interface + 2, timid_ump_interface, sizeof(opt_interface) - 3);
	opt_interface[sizeof(opt_interface) - 1] = '\0';
	argv[argc++] = opt_interface;

	EnterCriticalSection(&cs);
	argv[argc++] = MapAdress3.filename;
	LeaveCriticalSection(&cs);
	argv[argc] = NULL;

    // change to the configuration directory 
//    chdir(timdir);
	EnterCriticalSection(&cs);
    MapAdress3.playing=~0;
    MapAdress3.cstoped=0;
	LeaveCriticalSection(&cs);
   
    if(loop==0){
		timiditymain(argc, argv);
    }else{
    	while(MapAdress3.cstoped==0){
    		timiditymain(argc, argv);
    	}
    }
	EnterCriticalSection(&cs);
	MapAdress3.playing=0;
	MapAdress3.cstoped=0;
	LeaveCriticalSection(&cs);
	
	((CPlugin *)cplugin)->pluginState = PLUGIN_STOPPED;
	InvalidateRect( ((CPlugin *)cplugin)->p_hWnd, NULL, TRUE);
	_endthread();

}



NPError
NPP_Initialize(void)
{
	MapAdress3.playing = 0;
    MapAdress3.cstoped = 0;
	return NPERR_NO_ERROR;
}

void
NPP_Shutdown(void)
{
	DeleteCriticalSection(&cs);
	free_timidity();
}


NPError 
NPP_New(NPMIMEType pluginType,
                NPP instance,
                uint16 mode,
                int16 argc,
                char* argn[],
                char* argv[],
                NPSavedData* saved)
{ 
	if(instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  NPError rv = NPERR_NO_ERROR;

  CPlugin * pPlugin = new CPlugin(instance);
  if(pPlugin == NULL)
    return NPERR_OUT_OF_MEMORY_ERROR;

  instance->pdata = (void *)pPlugin;

  if(!cs_init){
  	InitializeCriticalSection(&cs);
  	cs_init == TRUE;
  }
  pPlugin->loop = 0;
  pPlugin->pluginState = PLUGIN_PLAYING;
  autostart=~0;
  {
    int i;
    for(i = 0; i < argc; i++) {
      	if(strcasecmp(argn[i], "loop") == 0){
			if(strcasecmp(argv[i], "true") == 0 ||
		   			strcasecmp(argv[i], "yes") == 0) {
		  		pPlugin->loop = ~0;
			}
     	}
     	else if(strcasecmp(argn[i], "autostart") == 0){
			if(strcasecmp(argv[i], "false") == 0 ||
	   				strcasecmp(argv[i], "no") == 0) {
	  			pPlugin->pluginState = PLUGIN_STOPPED;
	   			autostart=0;
	   		}
		}
    }
  }

 {
    FILE *bufstream;
 	char cbuf[MAX_PATH];
 	
 	DWORD retval;
    HANDLE hFind;
    WIN32_FIND_DATA FindFileData;
    char path_name[MAX_PATH];
 	
 	strcpy(timdir, DEFAULT_PATH);
    /* see if the user has specified an alternate directory for timidity */
 	if(GetEnvironmentVariable("TIMID_DIR", cbuf, MAX_PATH)) strcpy(timdir,cbuf);
 	strcpy(timid_cfg_path,timdir);
    strcat(timid_cfg_path,"\\timidity.cfg");
 	if(GetEnvironmentVariable("TIMID_CFG_PATH", cbuf, MAX_PATH)) strcpy(timid_cfg_path, cbuf );

 	if(NULL != (bufstream = fopen(timid_cfg_path,"r"))){
      fclose(bufstream);
    }else{
      if(NULL != (bufstream = fopen("timidity.cfg","r"))){
      	strcpy(timid_cfg_path, "timidity.cfg");
        fclose(bufstream);
      }else{
        timid_cfg_path[0] = '\0';
      }
    }

    /* see if the user has specified an alternate directory for timidity */
 	if(GetEnvironmentVariable("TIMID_8K", cbuf, MAX_PATH)) eightKFlag = 1;
 	if(GetEnvironmentVariable("TIMID_INTERFACE", cbuf, MAX_PATH)) strcpy(timid_ump_interface, cbuf);
 	if(GetEnvironmentVariable("TIMID_RATE", cbuf, MAX_PATH)) timid_ump_rate = atoi(cbuf);
 	


	/* setup temporary filename stub */
    retval = GetTempPath(MAX_PATH,temp_path);
    if(retval < MAX_PATH && retval != 0){
    	strcpy(filestub,temp_path);
     	strcat(filestub,"\\winump_midi");
    }
 	if(firsttime==1){
 		firsttime--;
 	/* cleanup old files */
    strcpy(find_key,filestub);
    strcat(find_key, "*.mid");
    hFind = FindFirstFile(find_key, &FindFileData);
    if(hFind != INVALID_HANDLE_VALUE){
      do{
        strcpy(path_name, temp_path);
        strcat(path_name, FindFileData.cFileName);
        DeleteFile(path_name);
      }while(FindNextFile(hFind, &FindFileData));
    FindClose(hFind);
    }
 	}

  }

  return rv;
}


NPError 
NPP_Destroy (NPP instance, NPSavedData** save)
{
  if(instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  NPError rv = NPERR_NO_ERROR;

  CPlugin * pPlugin = (CPlugin *)instance->pdata;
  if(pPlugin != NULL) {
    pPlugin->shut();
    delete pPlugin;
  }
	return rv;
}


// during this call we know when the plugin window is ready or
// is about to be destroyed so we can do some gui specific
// initialization and shutdown
NPError NPP_SetWindow (NPP instance, NPWindow* pNPWindow)
{    
  if(instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  NPError rv = NPERR_NO_ERROR;

  if(pNPWindow == NULL)
    return NPERR_GENERIC_ERROR;

  CPlugin * pPlugin = (CPlugin *)instance->pdata;

  if(pPlugin == NULL) 
    return NPERR_GENERIC_ERROR;

  // window just created
  if(!pPlugin->isInitialized() && (pNPWindow->window != NULL)) { 
    if(!pPlugin->init(pNPWindow)) {
      delete pPlugin;
      pPlugin = NULL;
      return NPERR_MODULE_LOAD_FAILED_ERROR;
    }
  }

  // window goes away
  if((pNPWindow->window == NULL) && pPlugin->isInitialized())
    return NPERR_NO_ERROR;

  // window resized
  if(pPlugin->isInitialized() && (pNPWindow->window != NULL))
    return NPERR_NO_ERROR;

  // this should not happen, nothing to do
  if((pNPWindow->window == NULL) && !pPlugin->isInitialized())
    return NPERR_NO_ERROR;

  return rv;
}


NPError 
NPP_NewStream(NPP instance,
	      NPMIMEType type,
	      NPStream *stream, 
	      NPBool seekable,
	      uint16 *stype)
{

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	CPlugin * pPlugin = (CPlugin *)instance->pdata;
	
	{
	const char *ext, *p;
	ext = stream->url;
  	if((p = strrchr(ext, '/')) != NULL)
	  ext = p + 1;
  	if((p = strchr(ext, '.')) != NULL)
	  ext = p + 1;
	_snprintf(pPlugin->filename, sizeof(pPlugin->filename), "%s%x.%s", filestub, pPlugin, ext);
  	/* open the file to store data in */
  	unlink(pPlugin->filename);	/* for security. */
  	pPlugin->fd = open(pPlugin->filename, O_RDWR|O_CREAT|O_BINARY, 0666);
  	if(pPlugin->fd == -1) {
  		pPlugin->filename[0]='\0';
    	return NPERR_GENERIC_ERROR;
  	}
	}
	return NPERR_NO_ERROR;
}



int32 STREAMBUFSIZE = 0X0FFFFFFF; 




int32 
NPP_WriteReady(NPP instance, NPStream *stream)
{
/*
	if (instance != NULL)
		CPlugin * pPlugin = (CPlugin *)instance->pdata;
*/
	return STREAMBUFSIZE;
}




int32 
NPP_Write(NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer)
{
	if (instance != NULL) {
		CPlugin * pPlugin = (CPlugin *)instance->pdata;
		len = write(pPlugin->fd, buffer, len);
      	if(len <0) close(pPlugin->fd);
	}
	return len;
}




NPError 
NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason)
{

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;
    CPlugin * pPlugin = (CPlugin *)instance->pdata;

  close(pPlugin->fd);

if(autostart==~0){
  if( pPlugin->startMidiPlayer()){
//  	NPN_Status(instance, "Playing MIDI file");
  	pPlugin->pluginState = PLUGIN_PLAYING;
  }else{
  	pPlugin->pluginState = PLUGIN_STOPPED;
  }
}
  if(pPlugin->p_hWnd != NULL){
  	InvalidateRect(pPlugin->p_hWnd, NULL, TRUE);
  }

	return NPERR_NO_ERROR;
}




void 
NPP_StreamAsFile(NPP instance, NPStream *stream, const char* fname)
{
/*
	if (instance != NULL){
		CPlugin * pPlugin = (CPlugin *)instance->pdata;
	}
*/
}

void 
NPP_Print(NPP instance, NPPrint* printInfo)
{
	if(printInfo == NULL)
		return;
/*
	if (instance != NULL) {
	
		if (printInfo->mode == NP_FULL) {
			printInfo->print.fullPrint.pluginPrinted = FALSE;
		}
	}
*/
}


void
NPP_URLNotify(NPP instance, const char* url, NPReason reason, void* notifyData)
{
  if(instance == NULL)
    return;
}

NPError NPP_SetValue(NPP instance, NPNVariable variable, void *value)
{
  if(instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  NPError rv = NPERR_NO_ERROR;
  return rv;
}

int16	NPP_HandleEvent(NPP instance, void* event)
{
  if(instance == NULL)
    return 0;

  int16 rv = 0;
  CPlugin * pPlugin = (CPlugin *)instance->pdata;
  if (pPlugin)
    rv = pPlugin->handleEvent(event);

  return rv;
}

/*
jref
NPP_GetJavaClass()
{
  return NULL;
}
*/
// ==============================
// ! Scriptability related code !
// ==============================
//
// here the plugin is asked by Mozilla to tell if it is scriptable
// we should return a valid interface id and a pointer to 
// nsScriptablePeer interface which we should have implemented
// and which should be defined in the corressponding *.xpt file
// in the bin/components folder
NPError	NPP_GetValue(NPP instance, NPPVariable variable, void *value)
{
  if(instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  NPError rv = NPERR_NO_ERROR;

  if(instance == NULL)
    return NPERR_GENERIC_ERROR;

  CPlugin * pPlugin = (CPlugin *)instance->pdata;
  if(pPlugin == NULL)
    return NPERR_GENERIC_ERROR;

  if (variable == NPPVpluginScriptableInstance) {
    // addref happens in getter, so we don't addref here
    nsIWinumpPlugin * scriptablePeer = pPlugin->getScriptablePeer();
    if (scriptablePeer) {
      *(nsISupports **)value = scriptablePeer;
    } else {
      rv = NPERR_OUT_OF_MEMORY_ERROR;
    }
  }
  else if (variable == NPPVpluginScriptableIID) {
    static nsIID scriptableIID = NS_IWINUMPPLUGIN_IID;
    nsIID* ptr = (nsIID *)NPN_MemAlloc(sizeof(nsIID));
    if (ptr) {
        *ptr = scriptableIID;
        *(nsIID **)value = ptr;
    } else {
      rv = NPERR_OUT_OF_MEMORY_ERROR;
    }
  }

  return rv;
}


CPlugin::CPlugin(NPP pNPInstance) :
  m_pNPInstance(pNPInstance),
  m_pNPStream(NULL),
  m_bInitialized(FALSE),
  m_pScriptablePeer(NULL)
{
  m_hWnd = NULL;

	p_hWnd = NULL;
	filename[0]='\0';
	MapAdress = NULL;
    pluginState = PLUGIN_PLAYING;
    MapAdress = NULL;
}

CPlugin::~CPlugin()
{
//  free_timidity();
  NS_IF_RELEASE(m_pScriptablePeer);
}

static LRESULT CALLBACK PluginWinProc(HWND, UINT, WPARAM, LPARAM);
static WNDPROC lpOldProc = NULL;

  	
NPBool CPlugin::init(NPWindow* pNPWindow)
{
  if(pNPWindow == NULL)
    return FALSE;

  m_hWnd = (HWND)pNPWindow->window;
  if(m_hWnd == NULL)
    return FALSE;

  // subclass window so we can intercept window messages and
  // do our drawing to it
  lpOldProc = SubclassWindow(m_hWnd, (WNDPROC)PluginWinProc);


  // associate window with our CPlugin object so we can access 
  // it in the window procedure
  SetWindowLong(m_hWnd, GWL_USERDATA, (LONG)this);
  
  SendMessage(m_hWnd, WM_MYCREATE, (WPARAM)0, (LPARAM)NULL);

  m_Window = pNPWindow;

  m_bInitialized = TRUE;
  return TRUE;
}

void CPlugin::shut()
{
  if( strcmp(::MapAdress3.filename, filename) ==0){
  	while(! stopMidiPlayer() ){Sleep(1);}
  	while(MapAdress->playing != 0){Sleep(1);}
  }
	remove(filename);
	
  // subclass it back
  SubclassWindow(m_hWnd, lpOldProc);
  m_hWnd = NULL;

  m_bInitialized = FALSE;

}

NPBool CPlugin::isInitialized()
{
  return m_bInitialized;
}

int16 CPlugin::handleEvent(void* event)
{
    return 0;
}





// ==============================
// ! Scriptability related code !
// ==============================
//
// this method will return the scriptable object (and create it if necessary)
nsIWinumpPlugin* CPlugin::getScriptablePeer()
{
  if (!m_pScriptablePeer) {
    m_pScriptablePeer = new nsScriptablePeer(this);
    if(!m_pScriptablePeer)
      return NULL;

    NS_ADDREF(m_pScriptablePeer);
  }

  // add reference for the caller requesting the object
  NS_ADDREF(m_pScriptablePeer);
  return m_pScriptablePeer;
}

BOOL CPlugin::plusMidiPlayer()
{
	if( strcmp(::MapAdress3.filename, filename) !=0) 
		return FALSE;
	EnterCriticalSection(&cs);
	if( ((char *)MapAdress)[0]=='1' ){
   		((char *)MapAdress)[0]='V';
		LeaveCriticalSection(&cs);
		return TRUE;
   	}
	LeaveCriticalSection(&cs);
   	return FALSE;
}

BOOL CPlugin::minusMidiPlayer()
{
	if( strcmp(::MapAdress3.filename, filename) !=0) 
		return FALSE;
	EnterCriticalSection(&cs);
	if( ((char *)MapAdress)[0]=='1' ){
 		((char *)MapAdress)[0]='v';
		LeaveCriticalSection(&cs);
		return TRUE;
 	}
	LeaveCriticalSection(&cs);
   	return FALSE;
}

BOOL CPlugin::pauseMidiPlayer()
{
	if( strcmp(::MapAdress3.filename, filename) !=0) 
		return FALSE;
	EnterCriticalSection(&cs);
	if( ((char *)MapAdress)[0]=='1' ){
   			((char *)MapAdress)[0]=' ';
		LeaveCriticalSection(&cs);
		return TRUE;
   	}
	LeaveCriticalSection(&cs);
   	return FALSE;
}

BOOL CPlugin::stopMidiPlayer(){
	if( strcmp(::MapAdress3.filename, filename) !=0) 
		return FALSE;
	EnterCriticalSection(&cs);
	if( ((char *)MapAdress)[0]=='1' ){
		((char *)MapAdress)[0] = 'q';
		LeaveCriticalSection(&cs);
		return TRUE;
	}
	LeaveCriticalSection(&cs);
   	return FALSE;
}

BOOL CPlugin::startMidiPlayer()
{	
	EnterCriticalSection(&cs);
	if(::MapAdress3.playing == 0){
		MapAdress=&(::MapAdress3);
		MapAdress->playing = ~0;
		MapAdress->cstoped = 0;
		MapAdress->command = 'l';
		strcpy(MapAdress->filename, filename);
		LeaveCriticalSection(&cs);
		_beginthread(ThreadProc, 0, (void *)this);
		return TRUE;
	}
	LeaveCriticalSection(&cs);
   	return FALSE;
}

void CPlugin::pausebutton(){
	if( pluginState == PLUGIN_PLAYING){
    	if( pauseMidiPlayer() ){
			pluginState = PLUGIN_PAUSED;
		}
	}else{
		if( pluginState == PLUGIN_PAUSED){
			if( pauseMidiPlayer() ){
				pluginState = PLUGIN_PLAYING;
			}
		}
	}
	InvalidateRect(p_hWnd, NULL, TRUE); 
}

void CPlugin::playbutton(){
	if(pluginState == PLUGIN_STOPPED){
		if(startMidiPlayer()){
			pluginState = PLUGIN_PLAYING;
		}
	}
	if( pluginState == PLUGIN_PAUSED){
		if( pauseMidiPlayer() ){
			pluginState = PLUGIN_PLAYING;
		}
	}
	InvalidateRect(p_hWnd, NULL, TRUE); 
}

void CPlugin::plusbutton(){
	plusMidiPlayer();
}

void CPlugin::minusbutton(){
	minusMidiPlayer();
}

void CPlugin::stopbutton(){
	if( pluginState == PLUGIN_PAUSED){
		pauseMidiPlayer();
		while( ((char *)MapAdress)[0]!='1' ) { Sleep(1);}
	}
	if( stopMidiPlayer() ){
		pluginState = PLUGIN_STOPPED;
    }
	InvalidateRect(p_hWnd, NULL, TRUE); 
}


LRESULT CALLBACK PluginWinProc( HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	CPlugin * ppPlugin = (CPlugin *)GetWindowLong(hWnd, GWL_USERDATA);
	int id;
    DRAWITEMSTRUCT *lpdraw;
	RECT rect;
	int st_x, st_y,wx,wy;
	PAINTSTRUCT ps;
	HDC hdc, hdc_mem;
	HBITMAP hBitmap;
	BITMAP bmp_info;
	int playon_bmp, play_bmp, stop_bmp, pauseon_bmp, pause_bmp, plus_bmp, minus_bmp;
	HINSTANCE hInst,hInstDll;
	hInst=(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
	ppPlugin->p_hWnd=hWnd;
	
	switch( msg ) {

        case WM_MYCREATE:
			GetClientRect(hWnd, &rect);
			if( (PLAYER_WIDTH > rect.right - rect.left) 
				|| (PLAYER_HIGHT > rect.bottom - rect.top) ){
				ppPlugin->bDispSmall = TRUE;
				st_x = CenterX(S_PLAYER_WIDTH);
				st_y = CenterY(S_PLAYER_HIGHT);
				ppPlugin->hStatic = CreateMyStaticWindow(hWnd, st_x, st_y+15, S_PLAYER_WIDTH, S_PLAYER_HIGHT-15);
				ppPlugin->hBPlay = CreateMyButton(hWnd, st_x, st_y+S_PLAYER_HIGHT-15, 20, 15, IDBT_PLAY);
				ppPlugin->hBStop = CreateMyButton(hWnd, st_x+20, st_y+S_PLAYER_HIGHT-15, 20, 15, IDBT_STOP);
				ppPlugin->hBPause = CreateMyButton(hWnd, st_x+40, st_y+S_PLAYER_HIGHT-15, 20, 15, IDBT_PAUSE);
            	ppPlugin->hBPlus = CreateMyButton(hWnd, st_x+60, st_y+S_PLAYER_HIGHT-15, 20, 15, IDBT_PLUS);
				ppPlugin->hBMinus = CreateMyButton(hWnd, st_x+80, st_y+S_PLAYER_HIGHT-15, 20, 15, IDBT_MINUS);
			}else{
				ppPlugin->bDispSmall = FALSE;
				st_x = CenterX(PLAYER_WIDTH);
				st_y = CenterY(PLAYER_HIGHT);
				ppPlugin->hStatic = CreateMyStaticWindow(hWnd, st_x, st_y+25, PLAYER_WIDTH, PLAYER_HIGHT-25);
				ppPlugin->hBPlay = CreateMyButton(hWnd, st_x, st_y+PLAYER_HIGHT-25, 40, 25, IDBT_PLAY);
				ppPlugin->hBStop = CreateMyButton(hWnd, st_x+40, st_y+PLAYER_HIGHT-25, 25, 25, IDBT_STOP);
				ppPlugin->hBPause = CreateMyButton(hWnd, st_x+65, st_y+PLAYER_HIGHT-25, 25, 25, IDBT_PAUSE);
            	ppPlugin->hBPlus = CreateMyButton(hWnd, st_x+90, st_y+PLAYER_HIGHT-25, 25, 25, IDBT_PLUS);
				ppPlugin->hBMinus = CreateMyButton(hWnd, st_x+115, st_y+PLAYER_HIGHT-25, 25, 25, IDBT_MINUS);
			}
            break;
		case WM_DRAWITEM:
             	lpdraw = (DRAWITEMSTRUCT *)lp;
            	id = lpdraw->CtlID;
            	if(ppPlugin->bDispSmall){
            		playon_bmp = S_PLAYON_BMP;
            		play_bmp = S_PLAY_BMP;
            		stop_bmp = S_STOP_BMP;
            		pauseon_bmp = S_PAUSEON_BMP;
            		pause_bmp = S_PAUSE_BMP;
            		plus_bmp = S_PLUS_BMP;
            		minus_bmp = S_MINUS_BMP;
            	}else{
            		playon_bmp = PLAYON_BMP;
            		play_bmp = PLAY_BMP;
            		stop_bmp = STOP_BMP;
            		pauseon_bmp = PAUSEON_BMP;
            		pause_bmp = PAUSE_BMP;
            		plus_bmp = PLUS_BMP;
            		minus_bmp = MINUS_BMP;
            	}		
                switch (id) {
                    case IDBT_PLAY:
                    	if(( ppPlugin->pluginState == PLUGIN_PLAYING)
                    		||( ppPlugin->pluginState == PLUGIN_PAUSED)){
                        	DrawMyButton(hWnd, lpdraw, playon_bmp);
                        }else{
                        	DrawMyButton(hWnd, lpdraw, play_bmp);
                        }
                        break;
                    case IDBT_STOP:
                        DrawMyButton(hWnd, lpdraw, stop_bmp);
                        break;
                    case IDBT_PAUSE:
                        if( ppPlugin->pluginState == PLUGIN_PAUSED){
                        	DrawMyButton(hWnd, lpdraw, pauseon_bmp);
                        }else{
                        	DrawMyButton(hWnd, lpdraw, pause_bmp);
                        }
                        break;
                    case IDBT_PLUS:
                        DrawMyButton(hWnd, lpdraw, plus_bmp);
                        break;
                    case IDBT_MINUS:
                        DrawMyButton(hWnd, lpdraw, minus_bmp);
                        break;
                }
            break;      
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDBT_PLAY:
                	ppPlugin->playbutton();
                    break;
                case IDBT_STOP:
                	ppPlugin->stopbutton();
                    break;
                case IDBT_PAUSE:
                	ppPlugin->pausebutton();
                    break;
                case IDBT_PLUS:
                	ppPlugin->plusbutton();
                    break;
                case IDBT_MINUS:
                	ppPlugin->minusbutton();
                    break;
            }
            break;
        case WM_SIZE:
			GetClientRect(hWnd, &rect);
			if(ppPlugin->bDispSmall){
				st_x = CenterX(S_PLAYER_WIDTH);
				st_y = CenterY(S_PLAYER_HIGHT);
            	MoveWindow(ppPlugin->hStatic, st_x, st_y+15, S_PLAYER_WIDTH, S_PLAYER_HIGHT-15, TRUE);
				MoveWindow(ppPlugin->hBPlay, st_x, st_y+S_PLAYER_HIGHT-15, 20, 15, TRUE);
				MoveWindow(ppPlugin->hBStop, st_x+20, st_y+S_PLAYER_HIGHT-15, 20, 15, TRUE);
				MoveWindow(ppPlugin->hBPause, st_x+40, st_y+S_PLAYER_HIGHT-15, 20, 15, TRUE);
            	MoveWindow(ppPlugin->hBPlus, st_x+60, st_y+S_PLAYER_HIGHT-15, 20, 15, TRUE);
				MoveWindow(ppPlugin->hBMinus, st_x+80, st_y+S_PLAYER_HIGHT-15, 20, 15, TRUE);
			}else{
				st_x = CenterX(PLAYER_WIDTH);
				st_y = CenterY(PLAYER_HIGHT);
            	MoveWindow(ppPlugin->hStatic, st_x, st_y+25, PLAYER_WIDTH, PLAYER_HIGHT-25, TRUE);
				MoveWindow(ppPlugin->hBPlay, st_x, st_y+PLAYER_HIGHT-25, 40, 25, TRUE);
				MoveWindow(ppPlugin->hBStop, st_x+40, st_y+PLAYER_HIGHT-25, 25, 25, TRUE);
				MoveWindow(ppPlugin->hBPause, st_x+65, st_y+PLAYER_HIGHT-25, 25, 25, TRUE);
            	MoveWindow(ppPlugin->hBPlus, st_x+90, st_y+PLAYER_HIGHT-25, 25, 25, TRUE);
				MoveWindow(ppPlugin->hBMinus, st_x+115, st_y+PLAYER_HIGHT-25, 25, 25, TRUE);
			}
            break;
		case WM_PAINT:
			HBRUSH  hOldBrush;
			hdc = BeginPaint(hWnd, &ps);
			hOldBrush = ( HBRUSH )SelectObject( hdc, ( HBRUSH )GetStockObject( WHITE_BRUSH ));
			GetClientRect(hWnd, &rect);
			Rectangle( hdc, rect.left, rect.top, rect.right, rect.bottom);
			SelectObject( hdc, hOldBrush );
			EndPaint(hWnd, &ps);

			GetClientRect(hWnd, &rect);
			GetClientRect(hWnd, &rect);
			if(ppPlugin->bDispSmall){
				st_x = CenterX(S_PLAYER_WIDTH);
				st_y = CenterY(S_PLAYER_HIGHT);
				hInstDll = LoadLibrary( "npWinUMP32.dll");
	            hBitmap =(HBITMAP)LoadImage(hInstDll, 
	            	MAKEINTRESOURCE(S_TITLE_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
            	//hBitmap = LoadBitmap(hInst, MAKEINTRESOURCE(S_TITLE_BMP)); 
			}else{
				st_x = CenterX(PLAYER_WIDTH);
				st_y = CenterY(PLAYER_HIGHT);
				hInstDll = LoadLibrary( "npWinUMP32.dll");
	            hBitmap =(HBITMAP)LoadImage(hInstDll, 
	            	MAKEINTRESOURCE(TITLE_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
            	//hBitmap = LoadBitmap(hInst, MAKEINTRESOURCE(TITLE_BMP)); 
			}
//            hdc = BeginPaint(hWnd, &ps);
            GetObject(hBitmap, sizeof(BITMAP), &bmp_info);
            wx = bmp_info.bmWidth;
            wy = bmp_info.bmHeight;
			hdc = GetDC(hWnd);
            hdc_mem = CreateCompatibleDC(hdc);
            SelectObject(hdc_mem, hBitmap);
            BitBlt(hdc,st_x, st_y , wx, wy, hdc_mem, 0, 0, SRCCOPY);
            DeleteDC(hdc_mem);
            ReleaseDC(hWnd, hdc);
            DeleteObject(hBitmap);
 //           EndPaint(hWnd, &ps);
			break;
			
        default:
            return (lpOldProc(hWnd, msg, wp, lp));
// 			break;
    }
    return 0L;
//    return DefWindowProc(hWnd, msg, wp, lp);
}
HWND CreateMyStaticWindow(HWND hWnd, int x, int y, int w, int h)
{
    HWND hStatic;
	HINSTANCE hInst;
	hInst=(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);

    hStatic = CreateWindow("static",
        NULL,
        SS_BLACKRECT | WS_CHILD | WS_VISIBLE,
        x, y, w, h, hWnd, (HMENU)100, hInst, NULL);
    return hStatic;
}

HWND CreateMyButton(HWND hWnd, int x, int y, int w, int h, int ID)
{
    HWND hButton;
	HINSTANCE hInst;
	hInst=(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);

    hButton = CreateWindow(
        "button",
        NULL,
        BS_OWNERDRAW | WS_CHILD | WS_VISIBLE,
        x, y, w, h,
        hWnd,
        (HMENU)ID,
        hInst,
        NULL);
    return hButton;
}

int DrawMyButton(HWND hWnd, DRAWITEMSTRUCT *lpdraw, int bmname)
{
    HBITMAP hBmp;
    BITMAP bitmap_info;
    HDC hdc, hdc_mem;
    int wx, wy;

	HINSTANCE hInst, hInstDll;
	hInst=(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);

	
//    hBmp = LoadBitmap(hInst, MAKEINTRESOURCE(bmname));
    hInstDll = LoadLibrary( "npWinUMP32.dll");
    hBmp =(HBITMAP)LoadImage(hInstDll,
    	MAKEINTRESOURCE(bmname),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
    GetObject(hBmp, sizeof(BITMAP), &bitmap_info);
    wx = bitmap_info.bmWidth;
    wy = bitmap_info.bmHeight;
    hdc = lpdraw->hDC;
    hdc_mem = CreateCompatibleDC(hdc);
    SelectObject(hdc_mem, hBmp);
    BitBlt(hdc, 0, 0, wx, wy, hdc_mem, 0, 0, SRCCOPY);
    DeleteDC(hdc_mem);
    DeleteObject(hBmp);
    return 0;
}

