/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   instrum_export.c

*/

#include "instrum_export.h"
#include "rtsyn.h"

/* sndfont.c */
void ts_add_soundfont(char *sf_file, int sf_order,
			  int cutoff_allowed, int resonance_allowed,
				int amp){
	rtsyn_mutex_lock(timidityMUTEX);
	add_soundfont(sf_file,sf_order,cutoff_allowed,resonance_allowed,
			  amp);
	rtsyn_mutex_unlock(timidityMUTEX);
}
void ts_remove_soundfont(char *sf_file){
	rtsyn_mutex_lock(timidityMUTEX);
	remove_soundfont(sf_file);
	rtsyn_mutex_unlock(timidityMUTEX);
}
void ts_init_load_soundfont(void){
	rtsyn_mutex_lock(timidityMUTEX);
	init_load_soundfont();
	rtsyn_mutex_unlock(timidityMUTEX);
}
Instrument *ts_load_soundfont_inst(int order, int bank, int preset,
	int keynote){
	Instrument * ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=load_soundfont_inst(order,bank,preset,keynote);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
Instrument *ts_extract_soundfont(char *sf_file, int bank, int preset,
			int keynote){
	Instrument * ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=extract_soundfont(sf_file,bank,preset,keynote);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
int ts_exclude_soundfont(int bank, int preset, int keynote){
	int ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=exclude_soundfont(bank,preset,keynote);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
int ts_order_soundfont(int bank, int preset, int keynote, int order){
	int ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=order_soundfont(bank,preset,keynote,order);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
char *ts_soundfont_preset_name(int bank, int preset, int keynote,
		char **sndfile){
	char *ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=soundfont_preset_name(bank,preset,keynote,sndfile);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
/*
void ts_free_soundfont_inst(void){
	rtsyn_mutex_lock(timidityMUTEX);
	free_soundfont_inst();
	rtsyn_mutex_unlock(timidityMUTEX);
}
*/
/* instrum.c */
int ts_load_missing_instruments(int *rc){
	int ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=load_missing_instruments(rc);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
void ts_free_instruments(int reload_default_inst){
	rtsyn_mutex_lock(timidityMUTEX);
	free_instruments(reload_default_inst);
	rtsyn_mutex_unlock(timidityMUTEX);
}
void ts_free_special_patch(int id){
	rtsyn_mutex_lock(timidityMUTEX);
	free_special_patch(id);
	rtsyn_mutex_unlock(timidityMUTEX);
}
int ts_set_default_instrument(char *name){
	int ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=set_default_instrument(name);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
void ts_clear_magic_instruments(void){
	rtsyn_mutex_lock(timidityMUTEX);
	clear_magic_instruments();
	rtsyn_mutex_unlock(timidityMUTEX);
}
Instrument *ts_load_instrument(int dr, int b, int prog){
	Instrument *ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=load_instrument(dr, b, prog);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
void ts_alloc_instrument_bank(int dr, int bankset){
	rtsyn_mutex_lock(timidityMUTEX);
	alloc_instrument_bank(dr, bankset);
	rtsyn_mutex_unlock(timidityMUTEX);
}
int ts_instrument_map(int mapID, int *set_in_out, int *elem_in_out){
	int ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=instrument_map(mapID,set_in_out,elem_in_out);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
void ts_set_instrument_map(int mapID,
			       int set_from, int elem_from,
					int set_to, int elem_to){
	rtsyn_mutex_lock(timidityMUTEX);
	set_instrument_map(mapID,set_from,elem_from,
			       set_to,elem_to);
	rtsyn_mutex_unlock(timidityMUTEX);
}
void ts_free_instrument_map(void){
	rtsyn_mutex_lock(timidityMUTEX);
	free_instrument_map();
	rtsyn_mutex_unlock(timidityMUTEX);
}
AlternateAssign *ts_add_altassign_string(AlternateAssign *old,
		char **params, int n){
	AlternateAssign *ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=add_altassign_string(old,params,n);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
AlternateAssign *ts_find_altassign(AlternateAssign *altassign, int note){
	AlternateAssign *ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=find_altassign(altassign,note);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
void ts_free_instrument(Instrument *ip){
	rtsyn_mutex_lock(timidityMUTEX);
	free_instrument(ip);
	rtsyn_mutex_unlock(timidityMUTEX);
}


instrum_ex_t* instrum_ex=NULL;

void destroy_instrumn(void);

instrum_ex_t* new_instrum(void){
	
	if(instrum_ex==NULL){
		instrum_ex=(instrum_ex_t *)safe_malloc(sizeof(instrum_ex_t));
	}
/* sndfont.c */
	instrum_ex->add_soundfont=ts_add_soundfont;
	instrum_ex->remove_soundfont=ts_remove_soundfont;
	instrum_ex->init_load_soundfont=ts_init_load_soundfont;
	instrum_ex->load_soundfont_inst=ts_load_soundfont_inst;
	instrum_ex->extract_soundfont=ts_extract_soundfont;
	instrum_ex->exclude_soundfont=ts_exclude_soundfont;
	instrum_ex->order_soundfont=ts_order_soundfont;
	instrum_ex->soundfont_preset_name=ts_soundfont_preset_name;
//	instrum_ex->free_soundfont_inst=ts_free_soundfont_inst;
/* instrum.c */
	instrum_ex->load_missing_instruments=ts_load_missing_instruments;
	instrum_ex->free_instruments=ts_free_instruments;
	instrum_ex->free_special_patch=ts_free_special_patch;
	instrum_ex->set_default_instrument=ts_set_default_instrument;
	instrum_ex->clear_magic_instruments=ts_clear_magic_instruments;
	instrum_ex->load_instrument=ts_load_instrument;
	instrum_ex->alloc_instrument_bank=ts_alloc_instrument_bank;
	instrum_ex->instrument_map=ts_instrument_map;
	instrum_ex->set_instrument_map=ts_set_instrument_map;
	instrum_ex->free_instrument_map=ts_free_instrument_map;
	instrum_ex->add_altassign_string=ts_add_altassign_string;
	instrum_ex->find_altassign=ts_find_altassign;
	instrum_ex->free_instrument=ts_free_instrument;
	instrum_ex->default_instrument_name=default_instrument_name;
	instrum_ex->progbase_p=&progbase;
	instrum_ex->modify_release_p=&modify_release;
	return instrum_ex;
}
void destroy_instrum(instrum_ex_t* instrum){
	free(instrum);
}

