/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   instrum_export.h

   */

#ifndef ___INSTRUM_EXPORT_H_
#define ___INSTRUM_EXPORT_H_

#include "timidity.h"
#include "common.h"
#include "instrum.h"

typedef struct _instrum_ex_t {
/* sndfont.c */
	void (*add_soundfont)(char *sf_file, int sf_order,
			  int cutoff_allowed, int resonance_allowed,
			  int amp);
	void (*remove_soundfont)(char *sf_file);
	void (*init_load_soundfont)(void);
	Instrument *(*load_soundfont_inst)(int order, int bank, int preset,
				       int keynote);
	Instrument *(*extract_soundfont)(char *sf_file, int bank, int preset,
				     int keynote);
	int (*exclude_soundfont)(int bank, int preset, int keynote);
	int (*order_soundfont)(int bank, int preset, int keynote, int order);
	char *(*soundfont_preset_name)(int bank, int preset, int keynote,
				   char **sndfile);
//	void (*free_soundfont_inst)(void);

/* instrum.c */
int (*load_missing_instruments)(int *rc);
void (*free_instruments)(int reload_default_inst);
void (*free_special_patch)(int id);
int (*set_default_instrument)(char *name);
void (*clear_magic_instruments)(void);
	Instrument *(*load_instrument)(int dr, int b, int prog);
void (*alloc_instrument_bank)(int dr, int bankset);
int (*instrument_map)(int mapID, int *set_in_out, int *elem_in_out);
void (*set_instrument_map)(int mapID,
			       int set_from, int elem_from,
			       int set_to, int elem_to);
void (*free_instrument_map)(void);
AlternateAssign *(*add_altassign_string)(AlternateAssign *old,
					     char **params, int n);
AlternateAssign *(*find_altassign)(AlternateAssign *altassign, int note);
void (*free_instrument)(Instrument *ip);

char *default_instrument_name;
int *progbase_p;

int32 *modify_release_p;
}instrum_ex_t;

extern instrum_ex_t* instrum_ex;

instrum_ex_t* new_instrum(void);
void destroy_instrum(instrum_ex_t* instrum);

#endif /* ___INSTRUM_EXPORT_H_ */
