/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   playmidi_export.c

*/
#include "timidity.h"
#include "common.h"
#include "instrum.h"
#include "playmidi.h"
#include "playmidi_export.h"
#include "rtsyn.h"


int ts_play_midi_file(char *fn){
	int ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=play_midi_file(fn);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
void ts_dumb_pass_playing_list(int number_of_files, char *list_of_files[]){
	rtsyn_mutex_lock(timidityMUTEX);
	dumb_pass_playing_list(number_of_files,list_of_files);
	rtsyn_mutex_unlock(timidityMUTEX);
}
void ts_default_ctl_lyric(int lyricid){
	rtsyn_mutex_lock(timidityMUTEX);
	default_ctl_lyric(lyricid);
	rtsyn_mutex_unlock(timidityMUTEX);
}
int ts_check_apply_control(void){
	int ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=check_apply_control();
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
void ts_recompute_freq(int v){
	rtsyn_mutex_lock(timidityMUTEX);
	recompute_freq(v);
	rtsyn_mutex_unlock(timidityMUTEX);
}
int ts_midi_drumpart_change(int ch, int isdrum){
	int ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=midi_drumpart_change(ch, isdrum);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
void ts_ctl_note_event(int noteID){
	rtsyn_mutex_lock(timidityMUTEX);
	ctl_note_event(noteID);
	rtsyn_mutex_unlock(timidityMUTEX);
}
void ts_ctl_mode_event(int type, int trace, long arg1, long arg2){
	rtsyn_mutex_lock(timidityMUTEX);
	ctl_mode_event(type, trace, arg1, arg2);
	rtsyn_mutex_unlock(timidityMUTEX);
}
char *ts_channel_instrum_name(int ch){
	char *ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=channel_instrum_name(ch);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
int ts_get_reverb_level(int ch){
	int ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=get_reverb_level(ch);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
int ts_get_chorus_level(int ch){
	int ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=get_chorus_level(ch);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
void ts_playmidi_output_changed(int play_state){
	rtsyn_mutex_lock(timidityMUTEX);
	playmidi_output_changed(play_state);
	rtsyn_mutex_unlock(timidityMUTEX);
}
Instrument *ts_play_midi_load_instrument(int dr, int bk, int prog){
	Instrument *ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=play_midi_load_instrument(dr, bk, prog);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}
void ts_midi_program_change(int ch, int prog){
	rtsyn_mutex_lock(timidityMUTEX);
	midi_program_change(ch, prog);
	rtsyn_mutex_unlock(timidityMUTEX);
}
void ts_free_voice(int v){
	rtsyn_mutex_lock(timidityMUTEX);
	free_voice(v);
	rtsyn_mutex_unlock(timidityMUTEX);
}
void ts_play_midi_setup_drums(int ch,int note){
	rtsyn_mutex_lock(timidityMUTEX);
	play_midi_setup_drums(ch,note);
	rtsyn_mutex_unlock(timidityMUTEX);
}

/* For stream player */
void ts_playmidi_stream_init(void){
	rtsyn_mutex_lock(timidityMUTEX);
	playmidi_stream_init();
	rtsyn_mutex_unlock(timidityMUTEX);
}
void ts_playmidi_tmr_reset(void){
	rtsyn_mutex_lock(timidityMUTEX);
	playmidi_tmr_reset();
	rtsyn_mutex_unlock(timidityMUTEX);
}
int ts_play_event(MidiEvent *ev){
	int ts_buf;
	rtsyn_mutex_lock(timidityMUTEX);
	ts_buf=play_event(ev);
	rtsyn_mutex_unlock(timidityMUTEX);
	return ts_buf;
}

void ts_dup_tone_bank_element(int a,int b,int c){
	rtsyn_mutex_lock(timidityMUTEX);
	dup_tone_bank_element(a,b,c);
	rtsyn_mutex_unlock(timidityMUTEX);
}
void ts_free_tone_bank_element(int a,int b,int c){
	rtsyn_mutex_lock(timidityMUTEX);
	free_tone_bank_element(a,b,c);
	rtsyn_mutex_unlock(timidityMUTEX);
}

void ts_recompute_voice_filter(int a){
	rtsyn_mutex_lock(timidityMUTEX);
	recompute_voice_filter(a);
	rtsyn_mutex_unlock(timidityMUTEX);
}




playmidi_ex_t* playmidi_ex=NULL;

void destroy_playmidin(void);

playmidi_ex_t* new_playmidi(void){
	
	if(playmidi_ex==NULL){
		playmidi_ex=(playmidi_ex_t *)safe_malloc(sizeof(playmidi_ex_t));
	}
playmidi_ex->channel=channel;
playmidi_ex->voice=voice;

playmidi_ex->control_ratio_p=&control_ratio;
//playmidi_ex->amp_with_poly_p=&amp_with_poly;
playmidi_ex->amplification_p=&amplification;
	
playmidi_ex->default_drumchannel_mask_p=&default_drumchannel_mask;
playmidi_ex->drumchannel_mask_p=&drumchannel_mask;
playmidi_ex->default_drumchannels_p=&default_drumchannels;
playmidi_ex->drumchannels_p=&drumchannels;

playmidi_ex->adjust_panning_immediately_p=&adjust_panning_immediately;
playmidi_ex->voices_p=&voices; 
playmidi_ex->upper_voices_p=&upper_voices;
playmidi_ex->note_key_offset_p=&note_key_offset;
playmidi_ex->midi_time_ratio_p=&midi_time_ratio;
playmidi_ex->opt_modulation_wheel_p=&opt_modulation_wheel;
playmidi_ex->opt_portamento_p=&opt_portamento;
playmidi_ex->opt_nrpn_vibrato_p=&opt_nrpn_vibrato;
playmidi_ex->opt_reverb_control_p=&opt_reverb_control;
playmidi_ex->opt_chorus_control_p=&opt_chorus_control;
playmidi_ex->opt_surround_chorus_p=&opt_surround_chorus;
playmidi_ex->opt_channel_pressure_p=&opt_channel_pressure;
playmidi_ex->opt_lpf_def_p=&opt_lpf_def;
playmidi_ex->opt_overlap_voice_allow_p=&opt_overlap_voice_allow;
playmidi_ex->opt_temper_control_p=&opt_temper_control;
playmidi_ex->opt_tva_attack_p=&opt_tva_attack;
playmidi_ex->opt_tva_decay_p=&opt_tva_decay;
playmidi_ex->opt_tva_release_p=&opt_tva_release;
playmidi_ex->opt_delay_control_p=&opt_delay_control;
playmidi_ex->opt_eq_control_p=&opt_eq_control;
playmidi_ex->opt_insertion_effect_p=&opt_insertion_effect;
playmidi_ex->opt_drum_effect_p=&opt_drum_effect;
//playmidi_ex->opt_env_attack_p=&opt_env_attack;
playmidi_ex->opt_modulation_envelope_p=&opt_modulation_envelope;
playmidi_ex->noise_sharp_type_p=&noise_sharp_type;
playmidi_ex->current_play_tempo_p=&current_play_tempo;
playmidi_ex->opt_realtime_playing_p=&opt_realtime_playing;
playmidi_ex->reduce_voice_threshold_p=&reduce_voice_threshold; /* msec */
playmidi_ex->check_eot_flag_p=&check_eot_flag;
playmidi_ex->special_tonebank_p=&special_tonebank;
playmidi_ex->default_tonebank_p=&default_tonebank;
playmidi_ex->playmidi_seek_flag_p=&playmidi_seek_flag;
playmidi_ex->effect_lr_mode_p=&effect_lr_mode;
playmidi_ex->effect_lr_delay_msec_p=&effect_lr_delay_msec;
playmidi_ex->auto_reduce_polyphony_p=&auto_reduce_polyphony;
playmidi_ex->play_pause_flag_p=&play_pause_flag;
playmidi_ex->reduce_quality_flag_p=&reduce_quality_flag;
playmidi_ex->no_4point_interpolation_p=&no_4point_interpolation;
playmidi_ex->channel_mute_p=&channel_mute;
playmidi_ex->temper_type_mute_p=&temper_type_mute;
playmidi_ex->current_keysig_p=&current_keysig;
playmidi_ex->current_temper_keysig_p=&current_temper_keysig;
playmidi_ex->opt_init_keysig_p=&opt_init_keysig;
playmidi_ex->opt_force_keysig_p=&opt_force_keysig;
playmidi_ex->key_adjust_p=&key_adjust;
playmidi_ex->opt_pure_intonation_p=&opt_pure_intonation;
playmidi_ex->current_freq_table_p=&current_freq_table;
playmidi_ex->opt_drum_power_p=&opt_drum_power;
playmidi_ex->opt_amp_compensation_p=&opt_amp_compensation;
//playmidi_ex->opt_realtime_priority_p=&opt_realtime_priority;	/* interface/alsaseq_c.c */
//playmidi_ex->opt_sequencer_ports_p=&opt_sequencer_ports;		/* interface/alsaseq_c.c */

playmidi_ex->play_midi_file=play_midi_file;
playmidi_ex->dumb_pass_playing_list=dumb_pass_playing_list;
playmidi_ex->default_ctl_lyric=default_ctl_lyric;
playmidi_ex->check_apply_control=check_apply_control;
playmidi_ex->recompute_freq=recompute_freq;
playmidi_ex->midi_drumpart_change=midi_drumpart_change;
playmidi_ex->ctl_note_event=ctl_note_event;
playmidi_ex->ctl_mode_event=ctl_mode_event;
playmidi_ex->channel_instrum_name=channel_instrum_name;
playmidi_ex->get_reverb_level=get_reverb_level;
playmidi_ex->get_chorus_level=get_chorus_level;
playmidi_ex->playmidi_output_changed=playmidi_output_changed;
playmidi_ex->play_midi_load_instrument=play_midi_load_instrument;
playmidi_ex->midi_program_change=midi_program_change;
playmidi_ex->free_voice=free_voice;
playmidi_ex->play_midi_setup_drums=play_midi_setup_drums;

/* For stream player */
playmidi_ex->playmidi_stream_init=playmidi_stream_init;
playmidi_ex->playmidi_tmr_reset=playmidi_tmr_reset;
playmidi_ex->play_event=play_event;

playmidi_ex->dup_tone_bank_element=dup_tone_bank_element;
playmidi_ex->free_tone_bank_element=free_tone_bank_element;

playmidi_ex->recompute_voice_filter=recompute_voice_filter;
	return playmidi_ex;
}

void destroy_playmidi(playmidi_ex_t* playmidi){
	free(playmidi);
}
