/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   rtsyn_export.c

*/

#include "rtsyn_export.h"

rtsyn_ex_t* rtsyn_ex=NULL;

void destroy_rtsynn(void);

rtsyn_ex_t* new_rtsyn(void){
	
	if(rtsyn_ex==NULL){
		rtsyn_ex=(rtsyn_ex_t *)safe_malloc(sizeof(rtsyn_ex_t));
	}
	/*from plugin_c.c */
	rtsyn_ex->rtsyn_seq_quit_p=&rtsyn_seq_quit;
	rtsyn_ex->dumb_ctl_p=&dumb_ctl;
#ifdef USE_WINSYN_TIMER_I
	rtsyn_ex->busy_p=&timidityMUTEX;
#else
	rtsyn_ex->busy_p=NULL;	
#endif
	rtsyn_ex->rtsyn_reachtime_p=&rtsyn_reachtime;
	rtsyn_ex->rtsyn_system_mode_p=&rtsyn_system_mode;
	rtsyn_ex->rtsyn_gm_reset=rtsyn_gm_reset;
	rtsyn_ex->rtsyn_gs_reset=rtsyn_gs_reset;
	rtsyn_ex->rtsyn_xg_reset=rtsyn_xg_reset;
	rtsyn_ex->rtsyn_normal_reset=rtsyn_normal_reset;
	rtsyn_ex->rtsyn_gm_modeset=rtsyn_gm_modeset;
	rtsyn_ex->rtsyn_gs_modeset=rtsyn_gs_modeset;
	rtsyn_ex->rtsyn_xg_modeset=rtsyn_xg_modeset;
	rtsyn_ex->rtsyn_normal_modeset=rtsyn_normal_modeset;
	rtsyn_ex->rtsyn_init=rtsyn_init;
	rtsyn_ex->rtsyn_close=rtsyn_close;
	rtsyn_ex->rtsyn_play_event=rtsyn_play_event;
	rtsyn_ex->rtsyn_server_reset=rtsyn_server_reset;
	rtsyn_ex->rtsyn_reset=rtsyn_reset;
	rtsyn_ex->rtsyn_stop_playing=rtsyn_stop_playing;
	rtsyn_ex->rtsyn_play_one_data=rtsyn_play_one_data;
	rtsyn_ex->rtsyn_play_one_sysex=rtsyn_play_one_sysex;
	rtsyn_ex->rtsyn_play_calculate=rtsyn_play_calculate;
	rtsyn_ex->rtsyn_add_midi_port=rtsyn_add_midi_port;
	rtsyn_ex->rtsyn_delete_midi_port=rtsyn_delete_midi_port;

	rtsyn_ex->rtsyn_portnumber_p=&rtsyn_portnumber;
	rtsyn_ex->portID=portID;
	rtsyn_ex->rtsyn_portlist_p=&rtsyn_portlist;
	rtsyn_ex->rtsyn_nportlist_p=&rtsyn_nportlist;
	rtsyn_ex->rtsyn_get_port_list=rtsyn_get_port_list;
	rtsyn_ex->rtsyn_synth_start=rtsyn_synth_start;
	rtsyn_ex->rtsyn_synth_stop=rtsyn_synth_stop;
	rtsyn_ex->rtsyn_play_some_data=rtsyn_play_some_data;

//#if defined(IA_WINSYN) || defined(IA_W32G_SYN)
//	rtsyn_ex->rtsyn_buf_check=rtsyn_buf_check;
//#endif

	
	return rtsyn_ex;
}
void destroy_rtsyn(rtsyn_ex_t* rtsyn){
	free(rtsyn);
}
