/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   rtsyn_export.h

   */

#ifndef ___RTSYN_EXPORT_H_
#define ___RTSYN_EXPORT_H_

#include "timidity.h"
#include "common.h"
#include "rtsyn.h"

/* import from plugin_c.c */
extern int rtsyn_seq_quit;
extern char *dumb_ctl;

typedef struct _rtsyn_ex_t {
/* from plugin_c.c */
	int *rtsyn_seq_quit_p;
	char *dumb_ctl_p;
	char *filename;
/******************************************************************************/
/*                                                                            */
/*  Interface independent functions (see rtsyn_common.c)                      */
/*                                                                            */
/******************************************************************************/
	rtsyn_mutex_t* busy_p;
	double* rtsyn_reachtime_p;
	int* rtsyn_system_mode_p;
	void (*rtsyn_gm_reset)(void);
	void (*rtsyn_gs_reset)(void);
	void (*rtsyn_xg_reset)(void);
	void (*rtsyn_normal_reset)(void);

/* mode change                                            *
 * only in nomalmode program can accept reset(sysex) data */
	void (*rtsyn_gm_modeset)(void);
	void (*rtsyn_gs_modeset)(void);
	void (*rtsyn_xg_modeset)(void);
	void (*rtsyn_normal_modeset)(void);

	void (*rtsyn_init)(void);
	void (*rtsyn_close)(void);
	void (*rtsyn_play_event)(MidiEvent *ev);
	void (*rtsyn_server_reset)(void);
	void (*rtsyn_reset)(void);
	void (*rtsyn_stop_playing)(void);
	int (*rtsyn_play_one_data)(int port, int32 dwParam1);
	void (*rtsyn_play_one_sysex)(char *sysexbuffer, int exlen );
	void (*rtsyn_play_calculate)(void);
	
	int (*rtsyn_add_midi_port)(int port_id);
	void (*rtsyn_delete_midi_port)(int port_id);
/******************************************************************************/
/*                                                                            */
/*  Interface dependent functions (see rtsyn_winmm.c rtsyn_portmidi.c)        */
/*                                                                            */
/******************************************************************************/
	int *rtsyn_portnumber_p;
	int *portID;
	char  (*rtsyn_portlist_p)[32][80];
	int *rtsyn_nportlist_p;

	void (*rtsyn_get_port_list)(void);
	int (*rtsyn_synth_start)(void);
	void (*rtsyn_synth_stop)(void);
	int (*rtsyn_play_some_data)(void);

//#if defined(IA_WINSYN) || defined(IA_W32G_SYN)
//	int (*rtsyn_buf_check)(void);
//#endif

}rtsyn_ex_t;

extern rtsyn_ex_t* rtsyn_ex;

rtsyn_ex_t* new_rtsyn(void);
void destroy_rtsyn(rtsyn_ex_t* rtsyn);

#endif /* ___RTSYN_EXPORT_H_ */
