/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    rtsyn_winmm.c
        Copyright (c) 2003 Keishi Suenaga <s_keishi@mutt.freemail.ne.jp>

    I referenced following sources.
        alsaseq_c.c - ALSA sequencer server interface
            Copyright (c) 2000  Takashi Iwai <tiwai@suse.de>
        readmidi.c

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#include "interface.h"

#include <stdio.h>

#include <stdarg.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#endif
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <math.h>
#include <signal.h>

#include "server_defs.h"

#ifdef __W32__
#include <windows.h>
#include <mmsystem.h>
#define sleep(time) Sleep(time)
#endif

#include "tmdy_struct.h"
#include "timidity.h"
#include "common.h"
#include "controls.h"
#include "instrum.h"
#include "playmidi.h"
#include "readmidi.h"
#include "recache.h"
#include "output.h"
#include "aq.h"
#include "timer.h"

#include "rtsyn.h"
#include "rtsyn_prv.h"

void CALLBACK MidiInProc(HMIDIIN,UINT,DWORD,DWORD,DWORD);

void rtsyn_get_port_list(tmdy_struct_ex_t *tmdy_struct){
	int i;
	MIDIINCAPS InCaps;
	RTSYN->InNum = midiInGetNumDevs();
	for (i=1;i <=RTSYN->InNum && i<=32;i++){
		midiInGetDevCaps(i-1,(LPMIDIINCAPSA) &InCaps,sizeof(InCaps));
		sprintf(RTSYN->rtsyn_portlist[i-1],"%d:%s",i,(LPSTR)InCaps.szPname);
	}
	RTSYN->rtsyn_nportlist=i-1;
}


static int rtsynth_set_midi_port(tmdy_struct_ex_t *tmdy_struct, UINT port){
	int i;
	midiInOpen(&RTSYN->hMidiIn[port],RTSYN->portID[port],(DWORD)MidiInProc,(DWORD)port,CALLBACK_FUNCTION);
	for (i=0;i<MAX_EXBUF;i++){
		midiInUnprepareHeader(RTSYN->hMidiIn[port],RTSYN->IMidiHdr[port][i],sizeof(MIDIHDR));
		midiInPrepareHeader(RTSYN->hMidiIn[port],RTSYN->IMidiHdr[port][i],sizeof(MIDIHDR));
		midiInAddBuffer(RTSYN->hMidiIn[port],RTSYN->IMidiHdr[port][i],sizeof(MIDIHDR));
	}
	if(MMSYSERR_NOERROR !=midiInStart(RTSYN->hMidiIn[port])){
		midiInStop(RTSYN->hMidiIn[port]);
		midiInReset(RTSYN->hMidiIn[port]);
		midiInClose(RTSYN->hMidiIn[port]);
		RTSYN->portID[port]=-1;
		goto winmmerror;
	}
	return 0;
winmmerror:
	tmdy_struct->controls->ctl->cmsg(tmdy_struct,   CMSG_ERROR, VERB_NORMAL, "midiInStarterror\n" );
	return ~0;
}


static void rtsynth_unset_midi_port(UINT port){
	
	if( MMSYSERR_NOERROR!=midiInStop(RTSYN->hMidiIn[port]) )
		/*tmdy_struct->controls->ctl->cmsg(tmdy_struct,   CMSG_ERROR, VERB_NORMAL,"MIDI Stop Error\n")*/;
	if( MMSYSERR_NOERROR!=midiInReset(RTSYN->hMidiIn[port]) ) 
		/*tmdy_struct->controls->ctl->cmsg(tmdy_struct,   CMSG_ERROR, VERB_NORMAL,"MIDI Rest Error\n")*/;
	if( MMSYSERR_NOERROR!=midiInClose(RTSYN->hMidiIn[port]) ) 
		/*tmdy_struct->controls->ctl->cmsg(tmdy_struct,   CMSG_ERROR, VERB_NORMAL,"MIDI Close Error\n")*/;
}


int rtsyn_add_midi_port(tmdy_struct_ex_t *tmdy_struct, int port_id){
	UINT port;
	port_id--;
	for(port=0;port<MAX_PORT;port++){
		if(RTSYN->portID[port]==port_id) return 0;
	}
	for(port=0;port<MAX_PORT;port++){
		if(RTSYN->portID[port]==-1){
			RTSYN->portID[port]=port_id;
			if(0==rtsynth_set_midi_port(tmdy_struct, port)){
				return 0;
			}
		}
	}
	return ~0;
}
void rtsyn_delete_midi_port(tmdy_struct_ex_t *tmdy_struct, int port_id){
	UINT port;
	port_id--;
	for(port=0;port<MAX_PORT;port++){
		if(RTSYN->portID[port]==port_id){
			RTSYN->portID[port]=-1;
			rtsynth_unset_midi_port(port);
		}
	}
}	



int rtsyn_synth_start(tmdy_struct_ex_t *tmdy_struct){
	int i;
	UINT port;
	MidiEvent ev;
	int retval;

	rtsyn_mutex_init(RTSYN->midi_mutex);
	rtsyn_reset(tmdy_struct);

	RTSYN->rtsyn_system_mode=DEFAULT_SYSTEM_MODE;
//	tmdy_struct->readmidi->change_system_mode(tmdy_struct, RTSYN->rtsyn_system_mode);
	ev.type=ME_RESET;
//	ev.a=GS_SYSTEM_MODE; //GM is mor better ???
	rtsyn_play_event(tmdy_struct, &ev);


	
//	RTSYN->evbuf[0].status=B_END;
	RTSYN->evbwpoint=0;
	RTSYN->evbrpoint=0;
//	RTSYN->mvbuse=0;
	
	retval=0;
	for(port=0;port<MAX_PORT;port++){
		for (i=0;i<MAX_EXBUF;i++){
			RTSYN->IMidiHdr[port][i] = (MIDIHDR *)RTSYN->sIMidiHdr[port][i];
			memset(RTSYN->IMidiHdr[port][i],0,sizeof(MIDIHDR));
			RTSYN->IMidiHdr[port][i]->lpData = RTSYN->sImidiHdr_data[port][i];
			memset((RTSYN->IMidiHdr[port][i]->lpData),0,BUFF_SIZE);
			RTSYN->IMidiHdr[port][i]->dwBufferLength = BUFF_SIZE;
		}
	}
	for(port=0;port<MAX_PORT;port++){
		if(RTSYN->portID[port]!=-1){
			retval=retval&rtsynth_set_midi_port(tmdy_struct, port);
		}
	}
	return retval;
}

void rtsyn_synth_stop(tmdy_struct_ex_t *tmdy_struct){
	UINT port;
	
	rtsyn_stop_playing(tmdy_struct);
	//	(tmdy_struct->output->play_mode)->close_output();
	for(port=0;port<MAX_PORT;port++){
		if(RTSYN->portID[port]!=-1){
			rtsynth_unset_midi_port(port);
		}
	}
	rtsyn_mutex_destroy(RTSYN->midi_mutex);
	return;
}

void rtsyn_midiports_close(){
	UINT port;
	for(port=0;port<MAX_PORT;port++){
		rtsynth_unset_midi_port(port);
	}
}


int rtsyn_buf_check(tmdy_struct_ex_t *tmdy_struct){
//	if( (RTSYN->evbuf[RTSYN->evbrpoint].status==B_OK)&&(RTSYN->evbrpoint!=RTSYN->evbwpoint) ){
	if( (RTSYN->evbrpoint!=RTSYN->evbwpoint) ){
		return ~0;
	}else{
		return 0;
	}
}

int rtsyn_play_some_data(tmdy_struct_ex_t *tmdy_struct){
	UINT wMsg;
	DWORD	dwInstance;
	DWORD	dwParam1;
	DWORD	dwParam2;
	MidiEvent ev;
	MidiEvent evm[260];
	int port;
	UINT evbpoint;
	MIDIHDR *IIMidiHdr;
	int exlen;
	char *sysexbuffer;
	int ne,i,j,chk,played;
	
	played=0;
#ifndef USE_WINSYN_TIMER_I
	do{
		Sleep(1);
#endif
//		if( !(RTSYN->evbuf[RTSYN->evbrpoint].status==B_OK)&&(RTSYN->evbrpoint!=RTSYN->evbwpoint) ) played=~0;
//		while( (RTSYN->evbuf[RTSYN->evbrpoint].status==B_OK)&&(RTSYN->evbrpoint!=RTSYN->evbwpoint) ){

		if( !(RTSYN->evbrpoint!=RTSYN->evbwpoint) ) played=~0;
		while( (RTSYN->evbrpoint!=RTSYN->evbwpoint) ){

			evbpoint=RTSYN->evbrpoint;
			if (++RTSYN->evbrpoint >= EVBUFF_SIZE)
					RTSYN->evbrpoint -= EVBUFF_SIZE;
			rtsyn_mutex_lock(RTSYN->midi_mutex);
			wMsg=RTSYN->evbuf[evbpoint].wMsg;
			dwInstance=RTSYN->evbuf[evbpoint].dwInstance;
			dwParam1=RTSYN->evbuf[evbpoint].dwParam1;
			dwParam2=RTSYN->evbuf[evbpoint].dwParam2;
			rtsyn_mutex_unlock(RTSYN->midi_mutex);
			port=(UINT)dwInstance;
			switch (wMsg) {
			case MIM_DATA:
				rtsyn_play_one_data(tmdy_struct, port, dwParam1);
				break;
			case MIM_LONGDATA:
				IIMidiHdr = (MIDIHDR *) dwParam1;
				exlen=(int)IIMidiHdr->dwBytesRecorded;
				sysexbuffer=IIMidiHdr->lpData;
				rtsyn_play_one_sysex (tmdy_struct, sysexbuffer,exlen );
				if(RTSYN->portID[port]!=-1){
				if (MMSYSERR_NOERROR != midiInUnprepareHeader(
						RTSYN->hMidiIn[port], IIMidiHdr, sizeof(MIDIHDR)))
					tmdy_struct->controls->ctl->cmsg(tmdy_struct,   CMSG_ERROR, VERB_NORMAL,"error1\n");
				if (MMSYSERR_NOERROR != midiInPrepareHeader(
						RTSYN->hMidiIn[port], IIMidiHdr, sizeof(MIDIHDR)))
					tmdy_struct->controls->ctl->cmsg(tmdy_struct,   CMSG_ERROR, VERB_NORMAL,"error5\n");
				if (MMSYSERR_NOERROR != midiInAddBuffer(
						RTSYN->hMidiIn[port], IIMidiHdr, sizeof(MIDIHDR)))
					tmdy_struct->controls->ctl->cmsg(tmdy_struct,   CMSG_ERROR, VERB_NORMAL,"error6\n");
				}
				break;
			}
		}	
#ifndef USE_WINSYN_TIMER_I
	}while(RTSYN->rtsyn_reachtime>get_current_calender_time());
#endif 
	return played;
}

void CALLBACK MidiInProc(HMIDIIN hMidiInL, UINT wMsg, DWORD dwInstance,
		DWORD dwParam1, DWORD dwParam2)
{
	UINT evbpoint;
	UINT port;
	
	port=(UINT)dwInstance;
	switch (wMsg) {
	case MIM_DATA:
	case MIM_LONGDATA:

		evbpoint = RTSYN->evbwpoint;
		if (++RTSYN->evbwpoint >= EVBUFF_SIZE)
			RTSYN->evbwpoint -= EVBUFF_SIZE;
		rtsyn_mutex_lock(RTSYN->midi_mutex);
//		RTSYN->evbuf[RTSYN->evbwpoint].status = B_END;
//		RTSYN->evbuf[evbpoint].status = B_WORK;
		RTSYN->evbuf[evbpoint].wMsg = wMsg;
		RTSYN->evbuf[evbpoint].dwInstance = dwInstance;
		RTSYN->evbuf[evbpoint].dwParam1 = dwParam1;
		RTSYN->evbuf[evbpoint].dwParam2 = dwParam2;
//		RTSYN->evbuf[evbpoint].status = B_OK;
		rtsyn_mutex_unlock(RTSYN->midi_mutex);
		break;
	case MIM_OPEN:
//		tmdy_struct->controls->ctl->cmsg(tmdy_struct,   CMSG_ERROR, VERB_NORMAL,"MIM_OPEN\n");
		break;
	case MIM_CLOSE:
//		tmdy_struct->controls->ctl->cmsg(tmdy_struct,   CMSG_ERROR, VERB_NORMAL,"MIM_CLOSE\n");
		break;
	case MIM_LONGERROR:
//		tmdy_struct->controls->ctl->cmsg(tmdy_struct,   CMSG_ERROR, VERB_NORMAL,"MIM_LONGERROR\n");
		break;
	case MIM_ERROR:
//		tmdy_struct->controls->ctl->cmsg(tmdy_struct,   CMSG_ERROR, VERB_NORMAL,"MIM_ERROR\n");
		break;
	case MIM_MOREDATA:
//		tmdy_struct->controls->ctl->cmsg(tmdy_struct,   CMSG_ERROR, VERB_NORMAL,"MIM_MOREDATA\n");
		break;
	}
}
