
/**** global functions ****/

extern int32 readmidi_set_track(tmdy_struct_ex_t *tmdy_struct, int trackno, int rewindp);
extern void readmidi_add_event(tmdy_struct_ex_t *tmdy_struct, MidiEvent *newev);
extern void readmidi_add_ctl_event(tmdy_struct_ex_t *tmdy_struct, int32 at, int ch, int control, int val);
extern int parse_sysex_event(tmdy_struct_ex_t *tmdy_struct, uint8 *data, int32 datalen, MidiEvent *ev_ret);
extern int parse_sysex_event_multi(tmdy_struct_ex_t *tmdy_struct, uint8 *data, int32 datalen, MidiEvent *ev_ret);
extern int convert_midi_control_change(tmdy_struct_ex_t *tmdy_struct, int chn, int type, int val,
				       MidiEvent *ev_ret);
extern char *readmidi_make_string_event(tmdy_struct_ex_t *tmdy_struct, int type, char *string, MidiEvent *ev,
					int cnv);
extern MidiEvent *read_midi_file(tmdy_struct_ex_t *tmdy_struct, struct timidity_file *mtf,
				 int32 *count, int32 *sp, char *file_name);
extern struct midi_file_info *get_midi_file_info(tmdy_struct_ex_t *tmdy_struct, char *filename,int newp);
extern struct midi_file_info *new_midi_file_info(tmdy_struct_ex_t *tmdy_struct, const char *filename);
extern void free_all_midi_file_info(tmdy_struct_ex_t *tmdy_struct);
extern int check_midi_file(tmdy_struct_ex_t *tmdy_struct, char *filename);
extern char *get_midi_title(tmdy_struct_ex_t *tmdy_struct, char *filename);
extern struct timidity_file *open_midi_file(tmdy_struct_ex_t *tmdy_struct, char *name,
					    int decompress, int noise_mode);
extern int midi_file_save_as(tmdy_struct_ex_t *tmdy_struct, char *in_name, char *out_name);
extern char *event2string(tmdy_struct_ex_t *tmdy_struct, int id);
extern void change_system_mode(tmdy_struct_ex_t *tmdy_struct, int mode);
extern int get_default_mapID(tmdy_struct_ex_t *tmdy_struct, int ch);
extern int dump_current_timesig(tmdy_struct_ex_t *tmdy_struct, MidiEvent *codes, int maxlen);



extern void recompute_delay_status(tmdy_struct_ex_t *tmdy_struct);
extern void set_delay_macro(tmdy_struct_ex_t *tmdy_struct, int macro);
extern void recompute_chorus_status(tmdy_struct_ex_t *tmdy_struct);
extern void set_chorus_macro(tmdy_struct_ex_t *tmdy_struct, int macro);
extern void recompute_reverb_status(tmdy_struct_ex_t *tmdy_struct);
extern void set_reverb_macro(tmdy_struct_ex_t *tmdy_struct, int macro);
extern void recompute_eq_status(tmdy_struct_ex_t *tmdy_struct);
extern void set_insertion_effect_default_parameter(tmdy_struct_ex_t *tmdy_struct);
extern void recompute_insertion_effect(tmdy_struct_ex_t *tmdy_struct);

extern void recompute_userdrum(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
extern void free_userdrum(tmdy_struct_ex_t *tmdy_struct);

extern void recompute_userinst(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
extern void free_userinst(tmdy_struct_ex_t *tmdy_struct);

extern void init_channel_layer(tmdy_struct_ex_t *tmdy_struct, int);
extern void add_channel_layer(tmdy_struct_ex_t *tmdy_struct, int, int);
extern void remove_channel_layer(tmdy_struct_ex_t *tmdy_struct, int);



/**** local definitions ****/
enum
{
    CHORUS_ST_NOT_OK = 0,
    CHORUS_ST_OK
};
#define SETMIDIEVENT(e, at, t, ch, pa, pb) \
    { (e).time = (at); (e).type = (t); \
      (e).channel = (uint8)(ch); (e).a = (uint8)(pa); (e).b = (uint8)(pb); }

#define MIDIEVENT(at, t, ch, pa, pb) \
    { MidiEvent event; SETMIDIEVENT(event, at, t, ch, pa, pb); \
      readmidi_add_event(tmdy_struct, &event); }

#if MAX_CHANNELS <= 16
#define MERGE_CHANNEL_PORT(ch) ((int)(ch))
#define MERGE_CHANNEL_PORT2(ch, port) ((int)(ch))
#else
#define MERGE_CHANNEL_PORT(ch) ((int)(ch) | (tmdy_struct->readmidi->midi_port_number << 4))
#define MERGE_CHANNEL_PORT2(ch, port) ((int)(ch) | ((int)port << 4))
#endif

#define alloc_midi_event() \
    (MidiEventList *)new_segment(&(tmdy_struct->readmidi->mempool), sizeof(MidiEventList))


/**** local functions ****/
void init_delay_status(tmdy_struct_ex_t *tmdy_struct);
void recompute_delay_status(tmdy_struct_ex_t *tmdy_struct);
void set_delay_macro(tmdy_struct_ex_t *tmdy_struct, int macro);

void init_chorus_status(tmdy_struct_ex_t *tmdy_struct);
void recompute_chorus_status(tmdy_struct_ex_t *tmdy_struct);
void set_chorus_macro(tmdy_struct_ex_t *tmdy_struct, int macro);

void init_reverb_status(tmdy_struct_ex_t *tmdy_struct);
void recompute_reverb_status(tmdy_struct_ex_t *tmdy_struct);
void set_reverb_macro(tmdy_struct_ex_t *tmdy_struct, int macro);

void init_eq_status(tmdy_struct_ex_t *tmdy_struct);
void recompute_eq_status(tmdy_struct_ex_t *tmdy_struct);

void init_insertion_effect_status(tmdy_struct_ex_t *tmdy_struct);
void set_insertion_effect_default_parameter(tmdy_struct_ex_t *tmdy_struct);
void recompute_insertion_effect(tmdy_struct_ex_t *tmdy_struct);


void init_userdrum(tmdy_struct_ex_t *tmdy_struct);
UserDrumset *get_userdrum(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
void recompute_userdrum(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
void recompute_userdrum_altassign(tmdy_struct_ex_t *tmdy_struct, int bank,int group);

void init_userinst(tmdy_struct_ex_t *tmdy_struct);
UserInstrument *get_userinst(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
void recompute_userinst(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
//void recompute_userinst_altassign(int bank,int group);


/* rcp.c */
int read_rcp_file(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf, char *magic0, char *fn);
/* smfconv.c */
#ifdef SMFCONV
#ifdef __W32__

int is_midifile_filename(tmdy_struct_ex_t *tmdy_struct, char *filename);
int smfconv_w32(tmdy_struct_ex_t *tmdy_struct, struct timidity_file *tf,char *fn);

#endif /* __W32__ */
#endif /* SMFCONV */

/* mfi.c */
extern int read_mfi_file(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf);
extern char *get_mfi_file_title(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf);

